/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.connect;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.connect.ProxyOptions;
import java.util.List;
import java.util.stream.Collectors;

@DataObject
public class SidecarServiceOptions {
    private static final String PROXY = "Proxy";
    private static final String PORT = "Port";
    private static final String CHECKS = "Checks";
    private ProxyOptions proxy;
    private int port;
    private List<JsonObject> checks;

    public SidecarServiceOptions() {
    }

    public SidecarServiceOptions(JsonObject options) {
        this.proxy = new ProxyOptions(options.getJsonObject(PROXY));
        this.port = options.getInteger(PORT);
        this.checks = options.getJsonArray(CHECKS).stream().map(o -> (JsonObject)o).collect(Collectors.toList());
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put(PORT, (Object)this.port);
        if (this.proxy != null) {
            jsonObject.put(PROXY, (Object)this.proxy.toJson());
        }
        if (this.checks != null) {
            jsonObject.put(CHECKS, this.checks);
        }
        return jsonObject;
    }

    public int getPort() {
        return this.port;
    }

    public SidecarServiceOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    public SidecarServiceOptions setProxy(ProxyOptions proxy) {
        this.proxy = proxy;
        return this;
    }

    public List<JsonObject> getChecks() {
        return this.checks;
    }

    public void setChecks(List<JsonObject> checks) {
        this.checks = checks;
    }
}

