/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.connect;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class UpstreamOptions {
    private static final String DC = "Datacenter";
    private static final String DEST_NAME = "DestinationName";
    private static final String LOCAL_PORT = "LocalBindPort";
    private String destinationName;
    private String dc;
    private int localBindPort;

    public UpstreamOptions() {
    }

    public UpstreamOptions(JsonObject options) {
        this.destinationName = options.getString(DEST_NAME);
        this.localBindPort = options.getInteger(LOCAL_PORT);
        this.dc = options.getString(DC);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.destinationName != null) {
            jsonObject.put(DEST_NAME, (Object)this.destinationName);
        }
        jsonObject.put(LOCAL_PORT, (Object)this.localBindPort);
        if (this.dc != null) {
            jsonObject.put(DC, (Object)this.dc);
        }
        return jsonObject;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public UpstreamOptions setDestinationName(String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    public String getDc() {
        return this.dc;
    }

    public UpstreamOptions setDc(String dc) {
        this.dc = dc;
        return this;
    }

    public int getLocalBindPort() {
        return this.localBindPort;
    }

    public UpstreamOptions setLocalBindPort(int localBindPort) {
        this.localBindPort = localBindPort;
        return this;
    }
}

