package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.CheckList}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.CheckList} original class using Vert.x codegen.
 */
public class CheckListConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, CheckList obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "index":
          if (member.getValue() instanceof Number) {
            obj.setIndex(((Number)member.getValue()).longValue());
          }
          break;
        case "list":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<io.vertx.ext.consul.Check> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof JsonObject)
                list.add(new io.vertx.ext.consul.Check((io.vertx.core.json.JsonObject)item));
            });
            obj.setList(list);
          }
          break;
      }
    }
  }

   static void toJson(CheckList obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(CheckList obj, java.util.Map<String, Object> json) {
    json.put("index", obj.getIndex());
    if (obj.getList() != null) {
      JsonArray array = new JsonArray();
      obj.getList().forEach(item -> array.add(item.toJson()));
      json.put("list", array);
    }
  }
}
