package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.CheckQueryOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.CheckQueryOptions} original class using Vert.x codegen.
 */
public class CheckQueryOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, CheckQueryOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "dc":
          if (member.getValue() instanceof String) {
            obj.setDc((String)member.getValue());
          }
          break;
        case "filter":
          if (member.getValue() instanceof String) {
            obj.setFilter((String)member.getValue());
          }
          break;
        case "ns":
          if (member.getValue() instanceof String) {
            obj.setNs((String)member.getValue());
          }
          break;
        case "near":
          if (member.getValue() instanceof String) {
            obj.setNear((String)member.getValue());
          }
          break;
        case "blockingOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setBlockingOptions(new io.vertx.ext.consul.BlockingQueryOptions((io.vertx.core.json.JsonObject)member.getValue()));
          }
          break;
      }
    }
  }

   static void toJson(CheckQueryOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(CheckQueryOptions obj, java.util.Map<String, Object> json) {
    if (obj.getDc() != null) {
      json.put("dc", obj.getDc());
    }
    if (obj.getFilter() != null) {
      json.put("filter", obj.getFilter());
    }
    if (obj.getNs() != null) {
      json.put("ns", obj.getNs());
    }
    if (obj.getNear() != null) {
      json.put("near", obj.getNear());
    }
    if (obj.getBlockingOptions() != null) {
      json.put("blockingOptions", obj.getBlockingOptions().toJson());
    }
  }
}
