package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.ServiceOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ServiceOptions} original class using Vert.x codegen.
 */
public class ServiceOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, ServiceOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "id":
          if (member.getValue() instanceof String) {
            obj.setId((String)member.getValue());
          }
          break;
        case "name":
          if (member.getValue() instanceof String) {
            obj.setName((String)member.getValue());
          }
          break;
        case "tags":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<java.lang.String> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof String)
                list.add((String)item);
            });
            obj.setTags(list);
          }
          break;
        case "address":
          if (member.getValue() instanceof String) {
            obj.setAddress((String)member.getValue());
          }
          break;
        case "meta":
          if (member.getValue() instanceof JsonObject) {
            java.util.Map<String, java.lang.String> map = new java.util.LinkedHashMap<>();
            ((Iterable<java.util.Map.Entry<String, Object>>)member.getValue()).forEach(entry -> {
              if (entry.getValue() instanceof String)
                map.put(entry.getKey(), (String)entry.getValue());
            });
            obj.setMeta(map);
          }
          break;
        case "port":
          if (member.getValue() instanceof Number) {
            obj.setPort(((Number)member.getValue()).intValue());
          }
          break;
        case "checkOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setCheckOptions(new io.vertx.ext.consul.CheckOptions((io.vertx.core.json.JsonObject)member.getValue()));
          }
          break;
        case "checkListOptions":
          if (member.getValue() instanceof JsonArray) {
            java.util.ArrayList<io.vertx.ext.consul.CheckOptions> list =  new java.util.ArrayList<>();
            ((Iterable<Object>)member.getValue()).forEach( item -> {
              if (item instanceof JsonObject)
                list.add(new io.vertx.ext.consul.CheckOptions((io.vertx.core.json.JsonObject)item));
            });
            obj.setCheckListOptions(list);
          }
          break;
        case "createIndex":
          if (member.getValue() instanceof Number) {
            obj.setCreateIndex(((Number)member.getValue()).longValue());
          }
          break;
        case "modifyIndex":
          if (member.getValue() instanceof Number) {
            obj.setModifyIndex(((Number)member.getValue()).longValue());
          }
          break;
        case "connectOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setConnectOptions(new io.vertx.ext.consul.connect.ConnectOptions((io.vertx.core.json.JsonObject)member.getValue()));
          }
          break;
      }
    }
  }

   static void toJson(ServiceOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(ServiceOptions obj, java.util.Map<String, Object> json) {
    if (obj.getId() != null) {
      json.put("id", obj.getId());
    }
    if (obj.getName() != null) {
      json.put("name", obj.getName());
    }
    if (obj.getTags() != null) {
      JsonArray array = new JsonArray();
      obj.getTags().forEach(item -> array.add(item));
      json.put("tags", array);
    }
    if (obj.getAddress() != null) {
      json.put("address", obj.getAddress());
    }
    if (obj.getMeta() != null) {
      JsonObject map = new JsonObject();
      obj.getMeta().forEach((key, value) -> map.put(key, value));
      json.put("meta", map);
    }
    json.put("port", obj.getPort());
    if (obj.getCheckOptions() != null) {
      json.put("checkOptions", obj.getCheckOptions().toJson());
    }
    if (obj.getCheckListOptions() != null) {
      JsonArray array = new JsonArray();
      obj.getCheckListOptions().forEach(item -> array.add(item.toJson()));
      json.put("checkListOptions", array);
    }
    json.put("createIndex", obj.getCreateIndex());
    json.put("modifyIndex", obj.getModifyIndex());
    if (obj.getConnectOptions() != null) {
      json.put("connectOptions", obj.getConnectOptions().toJson());
    }
  }
}
