package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.ext.consul.ServiceQueryOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ServiceQueryOptions} original class using Vert.x codegen.
 */
public class ServiceQueryOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, ServiceQueryOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "near":
          if (member.getValue() instanceof String) {
            obj.setNear((String)member.getValue());
          }
          break;
        case "tag":
          if (member.getValue() instanceof String) {
            obj.setTag((String)member.getValue());
          }
          break;
        case "blockingOptions":
          if (member.getValue() instanceof JsonObject) {
            obj.setBlockingOptions(new io.vertx.ext.consul.BlockingQueryOptions((io.vertx.core.json.JsonObject)member.getValue()));
          }
          break;
      }
    }
  }

   static void toJson(ServiceQueryOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(ServiceQueryOptions obj, java.util.Map<String, Object> json) {
    if (obj.getNear() != null) {
      json.put("near", obj.getNear());
    }
    if (obj.getTag() != null) {
      json.put("tag", obj.getTag());
    }
    if (obj.getBlockingOptions() != null) {
      json.put("blockingOptions", obj.getBlockingOptions().toJson());
    }
  }
}
