/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.impl.ConsulClientImpl;
import io.vertx.ext.consul.policy.AclPolicy;
import io.vertx.ext.consul.token.AclToken;
import io.vertx.ext.consul.token.CloneAclTokenOptions;
import java.util.List;

@VertxGen
public interface ConsulClient {
    public static ConsulClient create(Vertx vertx) {
        return new ConsulClientImpl(vertx, new ConsulClientOptions());
    }

    public static ConsulClient create(Vertx vertx, ConsulClientOptions options) {
        return new ConsulClientImpl(vertx, options);
    }

    public Future<JsonObject> agentInfo();

    public Future<CoordinateList> coordinateNodes();

    public Future<CoordinateList> coordinateNodesWithOptions(BlockingQueryOptions var1);

    public Future<List<DcCoordinates>> coordinateDatacenters();

    public Future<List<String>> getKeys(String var1);

    public Future<List<String>> getKeysWithOptions(String var1, BlockingQueryOptions var2);

    public Future<KeyValue> getValue(String var1);

    public Future<KeyValue> getValueWithOptions(String var1, BlockingQueryOptions var2);

    public Future<Void> deleteValue(String var1);

    public Future<KeyValueList> getValues(String var1);

    public Future<KeyValueList> getValuesWithOptions(String var1, BlockingQueryOptions var2);

    public Future<Void> deleteValues(String var1);

    public Future<Boolean> putValue(String var1, String var2);

    public Future<Boolean> putValueWithOptions(String var1, String var2, KeyValueOptions var3);

    public Future<TxnResponse> transaction(TxnRequest var1);

    public Future<String> createAclPolicy(AclPolicy var1);

    public Future<AclPolicy> readPolicy(String var1);

    public Future<AclPolicy> readPolicyByName(String var1);

    public Future<AclPolicy> updatePolicy(String var1, AclPolicy var2);

    public Future<Boolean> deletePolicy(String var1);

    public Future<List<AclPolicy>> getAclPolicies();

    public Future<AclToken> createAclToken(AclToken var1);

    public Future<AclToken> updateAclToken(String var1, AclToken var2);

    public Future<AclToken> cloneAclToken(String var1, CloneAclTokenOptions var2);

    public Future<List<AclToken>> getAclTokens();

    public Future<AclToken> readAclToken(String var1);

    public Future<Boolean> deleteAclToken(String var1);

    public Future<Event> fireEvent(String var1);

    public Future<Event> fireEventWithOptions(String var1, EventOptions var2);

    public Future<EventList> listEvents();

    public Future<EventList> listEventsWithOptions(EventListOptions var1);

    public Future<Void> registerService(ServiceOptions var1);

    public Future<Void> maintenanceService(MaintenanceOptions var1);

    public Future<Void> deregisterService(String var1);

    public Future<ServiceList> catalogServiceNodes(String var1);

    public Future<ServiceList> catalogServiceNodesWithOptions(String var1, ServiceQueryOptions var2);

    public Future<List<String>> catalogDatacenters();

    public Future<NodeList> catalogNodes();

    public Future<NodeList> catalogNodesWithOptions(NodeQueryOptions var1);

    public Future<CheckList> healthChecks(String var1);

    public Future<CheckList> healthChecksWithOptions(String var1, CheckQueryOptions var2);

    public Future<CheckList> healthState(HealthState var1);

    public Future<CheckList> healthStateWithOptions(HealthState var1, CheckQueryOptions var2);

    public Future<ServiceEntryList> healthServiceNodes(String var1, boolean var2);

    public Future<ServiceEntryList> healthServiceNodesWithOptions(String var1, boolean var2, ServiceQueryOptions var3);

    public Future<CheckList> healthNodesWithOptions(String var1, CheckQueryOptions var2);

    public Future<ServiceList> catalogServices();

    public Future<ServiceList> catalogServicesWithOptions(BlockingQueryOptions var1);

    public Future<ServiceList> catalogNodeServices(String var1);

    public Future<ServiceList> catalogNodeServicesWithOptions(String var1, BlockingQueryOptions var2);

    public Future<List<Service>> localServices();

    public Future<List<Check>> localChecks();

    public Future<Void> registerCheck(CheckOptions var1);

    public Future<Void> deregisterCheck(String var1);

    public Future<Void> passCheck(String var1);

    public Future<Void> passCheckWithNote(String var1, String var2);

    public Future<Void> warnCheck(String var1);

    public Future<Void> warnCheckWithNote(String var1, String var2);

    public Future<Void> failCheck(String var1);

    public Future<Void> failCheckWithNote(String var1, String var2);

    public Future<Void> updateCheck(String var1, CheckStatus var2);

    public Future<Void> updateCheckWithNote(String var1, CheckStatus var2, String var3);

    public Future<String> leaderStatus();

    public Future<List<String>> peersStatus();

    public Future<String> createSession();

    public Future<String> createSessionWithOptions(SessionOptions var1);

    public Future<Session> infoSession(String var1);

    public Future<Session> infoSessionWithOptions(String var1, BlockingQueryOptions var2);

    public Future<Session> renewSession(String var1);

    public Future<SessionList> listSessions();

    public Future<SessionList> listSessionsWithOptions(BlockingQueryOptions var1);

    public Future<SessionList> listNodeSessions(String var1);

    public Future<SessionList> listNodeSessionsWithOptions(String var1, BlockingQueryOptions var2);

    public Future<Void> destroySession(String var1);

    public Future<String> createPreparedQuery(PreparedQueryDefinition var1);

    public Future<PreparedQueryDefinition> getPreparedQuery(String var1);

    public Future<List<PreparedQueryDefinition>> getAllPreparedQueries();

    public Future<Void> updatePreparedQuery(PreparedQueryDefinition var1);

    public Future<Void> deletePreparedQuery(String var1);

    public Future<PreparedQueryExecuteResponse> executePreparedQuery(String var1);

    public Future<PreparedQueryExecuteResponse> executePreparedQueryWithOptions(String var1, PreparedQueryExecuteOptions var2);

    public Future<Void> registerCatalogService(Node var1, ServiceOptions var2);

    public Future<Void> deregisterCatalogService(String var1, String var2);

    public void close();
}

