/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.token;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.token.NodeTokenApplyingOptions;
import io.vertx.ext.consul.token.PolicyLink;
import io.vertx.ext.consul.token.ServiceTokenApplyingOptions;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class AclToken {
    private static final String ACCESSOR_ID_KEY = "AccessorID";
    private static final String SECRET_ID_KEY = "SecretID";
    private static final String DESCRIPTION_KEY = "Description";
    private static final String POLICIES_KEY = "Policies";
    private static final String SERVICE_IDENTITIES_KEY = "ServiceIdentities";
    private static final String NODE_IDENTITIES_KEY = "NodeIdentities";
    private static final String LOCAL_KEY = "Local";
    private static final String EXPIRATION_TIME_KEY = "ExpirationTime";
    private static final String NAMESPACE_KEY = "Namespace";
    private String accessorId;
    private String secretId;
    private String description;
    private List<PolicyLink> policies;
    private Boolean local = false;
    private List<ServiceTokenApplyingOptions> serviceIdentities;
    private List<NodeTokenApplyingOptions> nodeIdentities;
    private String expirationTime;
    private String namespace;

    public AclToken() {
    }

    public AclToken(JsonObject json) {
        this.description = json.getString(DESCRIPTION_KEY);
        this.accessorId = json.getString(ACCESSOR_ID_KEY);
        this.secretId = json.getString(SECRET_ID_KEY);
        this.policies = new ArrayList<PolicyLink>();
        JsonArray policiesArray = json.getJsonArray(POLICIES_KEY);
        if (policiesArray != null) {
            for (int i = 0; i < policiesArray.size(); ++i) {
                this.policies.add(new PolicyLink(policiesArray.getJsonObject(i)));
            }
        }
        this.local = json.getBoolean(LOCAL_KEY);
        this.nodeIdentities = new ArrayList<NodeTokenApplyingOptions>();
        JsonArray nodes = json.getJsonArray(NODE_IDENTITIES_KEY);
        if (nodes != null && !nodes.isEmpty()) {
            for (int i = 0; i < nodes.size(); ++i) {
                this.nodeIdentities.add(new NodeTokenApplyingOptions(nodes.getJsonObject(i)));
            }
        }
        this.serviceIdentities = new ArrayList<ServiceTokenApplyingOptions>();
        JsonArray services = json.getJsonArray(SERVICE_IDENTITIES_KEY);
        if (services != null && !services.isEmpty()) {
            for (int i = 0; i < services.size(); ++i) {
                this.serviceIdentities.add(new ServiceTokenApplyingOptions(services.getJsonObject(i)));
            }
        }
        this.expirationTime = json.getString(EXPIRATION_TIME_KEY);
        this.namespace = json.getString(NAMESPACE_KEY);
    }

    public JsonObject toJson() {
        JsonArray array;
        JsonObject json = new JsonObject();
        if (this.description != null) {
            json.put(DESCRIPTION_KEY, (Object)this.description);
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            array = new JsonArray();
            for (PolicyLink p : this.policies) {
                array.add((Object)p.toJson());
            }
            json.put(POLICIES_KEY, (Object)array);
        }
        if (this.serviceIdentities != null && !this.serviceIdentities.isEmpty()) {
            array = new JsonArray();
            for (ServiceTokenApplyingOptions s : this.serviceIdentities) {
                array.add((Object)s.toJson());
            }
            json.put(SERVICE_IDENTITIES_KEY, (Object)array);
        }
        if (this.nodeIdentities != null && !this.nodeIdentities.isEmpty()) {
            array = new JsonArray();
            for (NodeTokenApplyingOptions n : this.nodeIdentities) {
                array.add((Object)n.toJson());
            }
            json.put(NODE_IDENTITIES_KEY, (Object)array);
        }
        json.put(LOCAL_KEY, (Object)this.local);
        if (this.expirationTime != null) {
            json.put(EXPIRATION_TIME_KEY, (Object)this.expirationTime);
        }
        if (this.namespace != null) {
            json.put(NAMESPACE_KEY, (Object)this.namespace);
        }
        return json;
    }

    public String getAccessorId() {
        return this.accessorId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PolicyLink> getPolicies() {
        return this.policies;
    }

    public Boolean getLocal() {
        return this.local;
    }

    public AclToken setDescription(String description) {
        this.description = description;
        return this;
    }

    public AclToken setPolicies(List<PolicyLink> policies) {
        this.policies = policies;
        return this;
    }

    public AclToken addPolicy(PolicyLink policyLink) {
        if (this.policies == null) {
            this.policies = new ArrayList<PolicyLink>();
        }
        this.policies.add(policyLink);
        return this;
    }

    public AclToken local() {
        this.local = true;
        return this;
    }

    public AclToken setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public AclToken setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public AclToken setNodeIdentities(List<NodeTokenApplyingOptions> nodeIdentities) {
        this.nodeIdentities = nodeIdentities;
        return this;
    }

    public AclToken setServiceIdentities(List<ServiceTokenApplyingOptions> serviceIdentities) {
        this.serviceIdentities = serviceIdentities;
        return this;
    }
}

