/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.ConsulService;
import io.vertx.ext.consul.impl.ConsulServiceImpl;
import io.vertx.serviceproxy.ProxyHelper;

public class ConsulServiceVerticle
extends AbstractVerticle {
    private ConsulService service;
    private MessageConsumer<JsonObject> messageConsumer;

    public void start() throws Exception {
        this.service = new ConsulServiceImpl(ConsulClient.create((Vertx)this.vertx, (ConsulClientOptions)new ConsulClientOptions(this.config())));
        String address = this.config().getString("address");
        if (address == null) {
            throw new IllegalStateException("address field must be specified in config for client verticle");
        }
        this.messageConsumer = ProxyHelper.registerService(ConsulService.class, (Vertx)this.vertx, (Object)this.service, (String)address);
    }

    public void stop() throws Exception {
        if (this.messageConsumer != null) {
            ProxyHelper.unregisterService(this.messageConsumer);
        }
        this.service.close();
    }
}

