/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.ProxyIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.serviceproxy.ProxyHelper;
import java.util.List;

@ProxyGen
@VertxGen
public interface ConsulService
extends ConsulClient {
    public static ConsulService createEventBusProxy(Vertx vertx, String address) {
        return (ConsulService)ProxyHelper.createProxy(ConsulService.class, (Vertx)vertx, (String)address);
    }

    @Fluent
    public ConsulService agentInfo(Handler<AsyncResult<JsonObject>> var1);

    @Fluent
    public ConsulService coordinateNodes(Handler<AsyncResult<CoordinateList>> var1);

    @Fluent
    public ConsulService coordinateNodesWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<CoordinateList>> var2);

    @Fluent
    public ConsulService coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> var1);

    @Fluent
    public ConsulService getKeys(String var1, Handler<AsyncResult<List<String>>> var2);

    @Fluent
    public ConsulService getKeysWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<List<String>>> var3);

    @Fluent
    public ConsulService getValue(String var1, Handler<AsyncResult<KeyValue>> var2);

    @Fluent
    public ConsulService getValueWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<KeyValue>> var3);

    @Fluent
    public ConsulService deleteValue(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService getValues(String var1, Handler<AsyncResult<KeyValueList>> var2);

    @Fluent
    public ConsulService getValuesWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<KeyValueList>> var3);

    @Fluent
    public ConsulService deleteValues(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService putValue(String var1, String var2, Handler<AsyncResult<Boolean>> var3);

    @Fluent
    public ConsulService putValueWithOptions(String var1, String var2, KeyValueOptions var3, Handler<AsyncResult<Boolean>> var4);

    @Fluent
    public ConsulService transaction(TxnRequest var1, Handler<AsyncResult<TxnResponse>> var2);

    @Fluent
    public ConsulService createAclToken(AclToken var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulService updateAclToken(AclToken var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulService cloneAclToken(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulService listAclTokens(Handler<AsyncResult<List<AclToken>>> var1);

    @Fluent
    public ConsulService infoAclToken(String var1, Handler<AsyncResult<AclToken>> var2);

    @Fluent
    public ConsulService destroyAclToken(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService fireEvent(String var1, Handler<AsyncResult<Event>> var2);

    @Fluent
    public ConsulService fireEventWithOptions(String var1, EventOptions var2, Handler<AsyncResult<Event>> var3);

    @Fluent
    public ConsulService listEvents(Handler<AsyncResult<EventList>> var1);

    @Fluent
    public ConsulService listEventsWithOptions(EventListOptions var1, Handler<AsyncResult<EventList>> var2);

    @Fluent
    public ConsulService registerService(ServiceOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService maintenanceService(MaintenanceOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService deregisterService(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService healthChecks(String var1, Handler<AsyncResult<CheckList>> var2);

    @Fluent
    public ConsulService healthChecksWithOptions(String var1, CheckQueryOptions var2, Handler<AsyncResult<CheckList>> var3);

    @Fluent
    public ConsulService healthState(HealthState var1, Handler<AsyncResult<CheckList>> var2);

    @Fluent
    public ConsulService healthStateWithOptions(HealthState var1, CheckQueryOptions var2, Handler<AsyncResult<CheckList>> var3);

    @Fluent
    public ConsulService healthServiceNodes(String var1, boolean var2, Handler<AsyncResult<ServiceEntryList>> var3);

    @Fluent
    public ConsulService healthServiceNodesWithOptions(String var1, boolean var2, ServiceQueryOptions var3, Handler<AsyncResult<ServiceEntryList>> var4);

    @Fluent
    public ConsulService catalogServiceNodes(String var1, Handler<AsyncResult<ServiceList>> var2);

    @Fluent
    public ConsulService catalogServiceNodesWithOptions(String var1, ServiceQueryOptions var2, Handler<AsyncResult<ServiceList>> var3);

    @Fluent
    public ConsulService catalogDatacenters(Handler<AsyncResult<List<String>>> var1);

    @Fluent
    public ConsulService catalogNodes(Handler<AsyncResult<NodeList>> var1);

    @Fluent
    public ConsulService catalogNodesWithOptions(NodeQueryOptions var1, Handler<AsyncResult<NodeList>> var2);

    @Fluent
    public ConsulService catalogServices(Handler<AsyncResult<ServiceList>> var1);

    @Fluent
    public ConsulService catalogServicesWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<ServiceList>> var2);

    @Fluent
    public ConsulService localServices(Handler<AsyncResult<List<Service>>> var1);

    @Fluent
    public ConsulService catalogNodeServices(String var1, Handler<AsyncResult<ServiceList>> var2);

    @Fluent
    public ConsulService catalogNodeServicesWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<ServiceList>> var3);

    @Fluent
    public ConsulService localChecks(Handler<AsyncResult<List<Check>>> var1);

    @Fluent
    public ConsulService registerCheck(CheckOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService deregisterCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService passCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService passCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulService warnCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService warnCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulService failCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService failCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulService updateCheck(String var1, CheckStatus var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulService updateCheckWithNote(String var1, CheckStatus var2, String var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public ConsulService leaderStatus(Handler<AsyncResult<String>> var1);

    @Fluent
    public ConsulService peersStatus(Handler<AsyncResult<List<String>>> var1);

    @Fluent
    public ConsulService createSession(Handler<AsyncResult<String>> var1);

    @Fluent
    public ConsulService createSessionWithOptions(SessionOptions var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulService infoSession(String var1, Handler<AsyncResult<Session>> var2);

    @Fluent
    public ConsulService infoSessionWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<Session>> var3);

    @Fluent
    public ConsulService renewSession(String var1, Handler<AsyncResult<Session>> var2);

    @Fluent
    public ConsulService listSessions(Handler<AsyncResult<SessionList>> var1);

    @Fluent
    public ConsulService listSessionsWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<SessionList>> var2);

    @Fluent
    public ConsulService listNodeSessions(String var1, Handler<AsyncResult<SessionList>> var2);

    @Fluent
    public ConsulService listNodeSessionsWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<SessionList>> var3);

    @Fluent
    public ConsulService destroySession(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService createPreparedQuery(PreparedQueryDefinition var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulService getPreparedQuery(String var1, Handler<AsyncResult<PreparedQueryDefinition>> var2);

    @Fluent
    public ConsulService getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> var1);

    @Fluent
    public ConsulService updatePreparedQuery(PreparedQueryDefinition var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService deletePreparedQuery(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulService executePreparedQuery(String var1, Handler<AsyncResult<PreparedQueryExecuteResponse>> var2);

    @Fluent
    public ConsulService executePreparedQueryWithOptions(String var1, PreparedQueryExecuteOptions var2, Handler<AsyncResult<PreparedQueryExecuteResponse>> var3);

    @ProxyIgnore
    public void close();
}

