/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.internal.logging.LoggerAdapter;
import io.vertx.core.spi.logging.LogDelegate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4j2LogDelegate
implements LogDelegate {
    final ExtendedLogger logger;
    private static final String FQCN = LoggerAdapter.class.getCanonicalName();

    Log4j2LogDelegate(String name) {
        this.logger = (ExtendedLogger)LogManager.getLogger((String)name);
    }

    @Override
    public String implementation() {
        return "log4j2";
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.TRACE, message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Level.TRACE, message.toString(), t);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t) {
        if (message instanceof Message) {
            this.logger.logIfEnabled(FQCN, level, null, (Message)message, t);
        } else {
            this.logger.logIfEnabled(FQCN, level, null, message, t);
        }
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

