/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.MessageList;
import java.util.Map;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;
import org.vertx.java.core.net.impl.VertxInboundHandler;

public abstract class VertxHttpHandler<C extends ConnectionBase>
extends VertxInboundHandler<C> {
    private final VertxInternal vertx;

    protected VertxHttpHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        super(vertx, connectionMap);
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(final ChannelHandlerContext chctx, MessageList<Object> msgs) throws Exception {
        Channel ch = chctx.channel();
        for (int i = 0; i < msgs.size(); ++i) {
            final Object msg = msgs.get(i);
            final ConnectionBase connection = (ConnectionBase)this.connectionMap.get(ch);
            if (connection != null) {
                final DefaultContext context = this.getContext(connection);
                if (context.isOnCorrectWorker(ch.eventLoop())) {
                    try {
                        this.vertx.setContext(context);
                        context.startExecute();
                        this.doMessageReceived(connection, chctx, msg);
                        continue;
                    }
                    catch (Throwable t) {
                        context.reportException(t);
                        continue;
                    }
                    finally {
                        ByteBufUtil.release((Object)msg);
                        context.endExecute();
                    }
                }
                context.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            VertxHttpHandler.this.doMessageReceived(connection, chctx, msg);
                        }
                        catch (Throwable t) {
                            context.reportException(t);
                        }
                        finally {
                            ByteBufUtil.release((Object)msg);
                        }
                    }
                });
                continue;
            }
            try {
                this.doMessageReceived(connection, chctx, msg);
                continue;
            }
            catch (Throwable t) {
                chctx.pipeline().fireExceptionCaught(t);
                continue;
            }
            finally {
                ByteBufUtil.release((Object)msg);
            }
        }
        msgs.recycle();
    }

    protected abstract void doMessageReceived(C var1, ChannelHandlerContext var2, Object var3) throws Exception;
}

