/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import io.netty.buffer.BufType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOperationHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import org.vertx.java.core.impl.FlowControlStateEvent;

public class FlowControlHandler
extends ChannelOperationHandlerAdapter {
    private final FlowControlStateEvent state = new FlowControlStateEvent();
    private final ChannelFutureListener listener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!FlowControlHandler.this.state.isWritable()) {
                if (!FlowControlHandler.this.outboundBuf.isReadable(FlowControlHandler.this.lowMark)) {
                    FlowControlHandler.this.state.updateWritable(true);
                    FlowControlHandler.this.ctx.fireUserEventTriggered((Object)FlowControlHandler.this.state);
                } else if (future.isSuccess() && FlowControlHandler.this.outboundBuf.isReadable()) {
                    FlowControlHandler.this.ctx.flush().addListener((GenericFutureListener)this);
                }
            }
        }
    };
    private volatile int lowMark;
    private ChannelHandlerContext ctx;
    private ByteBuf outboundBuf;
    private volatile int highMark;

    public FlowControlHandler(int lowMark, int highMark) {
        if (lowMark < 1) {
            throw new IllegalArgumentException("minWritable must be >= 1");
        }
        if (lowMark > highMark) {
            throw new IllegalArgumentException("lowMark must be >= highMark");
        }
        this.lowMark = lowMark;
        this.highMark = highMark;
    }

    public FlowControlHandler() {
        this(32768, 65536);
    }

    public void setLimit(int lowMark, int highMark) {
        if (lowMark < 1) {
            throw new IllegalArgumentException("minWritable must be >= 1");
        }
        if (lowMark > highMark) {
            throw new IllegalArgumentException("lowMark must be >= highMark");
        }
        this.lowMark = lowMark;
        this.highMark = highMark;
        this.ctx.executor().execute(new Runnable(){

            @Override
            public void run() {
                if (FlowControlHandler.this.state.isWritable() && FlowControlHandler.this.outboundBuf.isReadable(FlowControlHandler.this.highMark)) {
                    FlowControlHandler.this.state.updateWritable(false);
                    FlowControlHandler.this.ctx.fireUserEventTriggered((Object)FlowControlHandler.this.state);
                } else if (!FlowControlHandler.this.state.isWritable() && FlowControlHandler.this.outboundBuf.isReadable(FlowControlHandler.this.lowMark)) {
                    FlowControlHandler.this.state.updateWritable(true);
                    FlowControlHandler.this.ctx.fireUserEventTriggered((Object)FlowControlHandler.this.state);
                }
            }
        });
    }

    public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        boolean writable = this.state.isWritable();
        if (writable) {
            boolean bl = writable = !this.outboundBuf.isReadable(this.highMark);
        }
        if (!writable) {
            if (this.state.isWritable()) {
                this.state.updateWritable(false);
                ctx.fireUserEventTriggered((Object)this.state);
            }
            promise.addListener((GenericFutureListener)this.listener);
        }
        ctx.flush(promise);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        Channel channel = ctx.channel();
        if (channel.metadata().bufferType() != BufType.BYTE) {
            throw new IllegalStateException("Only supported for Channels which handle bytes");
        }
        this.outboundBuf = channel.unsafe().headContext().outboundByteBuffer();
        super.handlerAdded(ctx);
    }
}

