/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.vertx.java.core.impl.management;

/**
 * @author swilliams
 *
 */
public class EventBusMXBeanImpl implements EventBusMXBean {

  private final int port;

  private final String host;

  public EventBusMXBeanImpl(String host, int port) {
    this.host = host;
    this.port = port;
  }

  /* (non-Javadoc)
   * @see org.vertx.java.core.impl.management.EventBusMXBean#getPort()
   */
  @Override
  public int getPort() {
    return port;
  }

  /* (non-Javadoc)
   * @see org.vertx.java.core.impl.management.EventBusMXBean#getHostname()
   */
  @Override
  public String getHostname() {
    return host;
  }

}
