/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.AbstractConnection;
import org.vertx.java.core.http.impl.DefaultHttpServer;
import org.vertx.java.core.http.impl.DefaultHttpServerRequest;
import org.vertx.java.core.http.impl.DefaultHttpServerResponse;
import org.vertx.java.core.http.impl.DefaultServerWebSocket;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.VertxNetHandler;

class ServerConnection
extends AbstractConnection {
    private static final int CHANNEL_PAUSE_QUEUE_SIZE = 5;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<ServerWebSocket> wsHandler;
    private DefaultHttpServerRequest currentRequest;
    private DefaultHttpServerResponse pendingResponse;
    private DefaultServerWebSocket ws;
    private boolean channelPaused;
    private boolean paused;
    private boolean sentCheck;
    private final Queue<Object> pending = new LinkedList<Object>();
    private final String serverOrigin;
    private final DefaultHttpServer server;
    private ChannelFuture lastWriteFuture;

    ServerConnection(DefaultHttpServer server, Channel channel, DefaultContext context, String serverOrigin) {
        super(server.vertx, channel, context);
        this.serverOrigin = serverOrigin;
        this.server = server;
    }

    public void pause() {
        if (!this.paused) {
            this.paused = true;
        }
    }

    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.checkNextTick();
        }
    }

    void handleMessage(Object msg) {
        if (this.paused || msg instanceof HttpRequest && this.pendingResponse != null || !this.pending.isEmpty()) {
            this.pending.add(msg);
            if (this.pending.size() == 5) {
                super.doPause();
                this.channelPaused = true;
            }
        } else {
            this.processMessage(msg);
        }
    }

    void responseComplete() {
        this.pendingResponse = null;
        this.checkNextTick();
    }

    void requestHandler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
    }

    void wsHandler(Handler<ServerWebSocket> handler) {
        this.wsHandler = handler;
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    @Override
    ChannelFuture write(Object obj) {
        ChannelFuture future = this.lastWriteFuture = super.write(obj);
        return future;
    }

    NetSocket createNetSocket() {
        DefaultNetSocket socket = new DefaultNetSocket(this.vertx, this.channel, this.context);
        HashMap<Channel, DefaultNetSocket> connectionMap = new HashMap<Channel, DefaultNetSocket>(1);
        connectionMap.put(this.channel, socket);
        this.endReadAndFlush();
        this.channel.pipeline().remove("httpDecoder");
        if (this.channel.pipeline().get("chunkedWriter") != null) {
            this.channel.pipeline().remove("chunkedWriter");
        }
        this.channel.pipeline().replace("handler", "handler", (ChannelHandler)new VertxNetHandler(this.server.vertx, connectionMap){

            @Override
            public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
                ((ServerConnection)ServerConnection.this).server.connectionMap.remove(ServerConnection.this.channel);
                super.exceptionCaught(chctx, t);
            }

            @Override
            public void channelInactive(ChannelHandlerContext chctx) throws Exception {
                ((ServerConnection)ServerConnection.this).server.connectionMap.remove(ServerConnection.this.channel);
                super.channelInactive(chctx);
            }

            @Override
            public void channelRead(ChannelHandlerContext chctx, Object msg) {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                super.channelRead(chctx, msg);
            }
        });
        if (this.lastWriteFuture == null) {
            this.channel.pipeline().remove("httpEncoder");
        } else {
            this.lastWriteFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ServerConnection.this.channel.pipeline().remove("httpEncoder");
                }
            });
        }
        return socket;
    }

    private void handleRequest(DefaultHttpServerRequest req, DefaultHttpServerResponse resp) {
        this.setContext();
        try {
            this.currentRequest = req;
            this.pendingResponse = resp;
            if (this.requestHandler != null) {
                this.requestHandler.handle(req);
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleChunk(Buffer chunk) {
        try {
            this.setContext();
            this.currentRequest.handleData(chunk);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleEnd() {
        try {
            this.setContext();
            this.currentRequest.handleEnd();
            this.currentRequest = null;
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    @Override
    public void handleInterestedOpsChanged() {
        try {
            if (!this.doWriteQueueFull()) {
                this.setContext();
                if (this.pendingResponse != null) {
                    this.pendingResponse.handleDrained();
                } else if (this.ws != null) {
                    this.ws.writable();
                }
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleWebsocketConnect(DefaultServerWebSocket ws) {
        try {
            if (this.wsHandler != null) {
                this.setContext();
                this.wsHandler.handle(ws);
                this.ws = ws;
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleWsFrame(WebSocketFrame frame) {
        try {
            if (this.ws != null) {
                this.setContext();
                this.ws.handleFrame(frame);
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
        if (this.pendingResponse != null) {
            this.pendingResponse.handleClosed();
        }
    }

    @Override
    protected DefaultContext getContext() {
        return super.getContext();
    }

    @Override
    protected void handleException(Throwable t) {
        super.handleException(t);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(t);
        }
        if (this.pendingResponse != null) {
            this.pendingResponse.handleException(t);
        }
        if (this.ws != null) {
            this.ws.handleException(t);
        }
    }

    @Override
    protected void addFuture(Handler<AsyncResult<Void>> doneHandler, ChannelFuture future) {
        super.addFuture(doneHandler, future);
    }

    @Override
    protected boolean isSSL() {
        return super.isSSL();
    }

    @Override
    protected ChannelFuture sendFile(File file) {
        return super.sendFile(file);
    }

    private void processMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            DefaultHttpServerResponse resp = new DefaultHttpServerResponse(this.vertx, this, request);
            DefaultHttpServerRequest req = new DefaultHttpServerRequest(this, request, resp);
            this.handleRequest(req, resp);
        }
        if (msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            if (chunk.content().isReadable()) {
                Buffer buff = new Buffer(chunk.content());
                this.handleChunk(buff);
            }
            if (msg instanceof LastHttpContent) {
                if (!this.paused) {
                    this.handleEnd();
                } else {
                    this.pending.add(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            this.handleWsFrame(frame);
        }
        this.checkNextTick();
    }

    private void checkNextTick() {
        if (!(this.sentCheck || this.pending.isEmpty() || this.paused || this.pendingResponse != null && !(this.pending.peek() instanceof HttpContent))) {
            this.sentCheck = true;
            this.vertx.runOnContext(new VoidHandler(){

                @Override
                public void handle() {
                    ServerConnection.this.sentCheck = false;
                    if (!ServerConnection.this.paused) {
                        Object msg = ServerConnection.this.pending.poll();
                        if (msg != null) {
                            ServerConnection.this.processMessage(msg);
                        }
                        if (ServerConnection.this.channelPaused && ServerConnection.this.pending.isEmpty()) {
                            ServerConnection.super.doResume();
                            ServerConnection.this.channelPaused = false;
                        }
                    }
                }
            });
        }
    }
}

