/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl.netty.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.vertx.java.core.dns.impl.netty.DnsResource;
import org.vertx.java.core.dns.impl.netty.DnsResponse;
import org.vertx.java.core.dns.impl.netty.decoder.RecordDecoder;

public class AddressDecoder
implements RecordDecoder<InetAddress> {
    private final int octets;

    public AddressDecoder(int octets) {
        this.octets = octets;
    }

    @Override
    public InetAddress decode(DnsResponse response, DnsResource resource) {
        ByteBuf data = resource.content().copy().readerIndex(response.originalIndex());
        int size = data.writerIndex() - data.readerIndex();
        if (data.readerIndex() != 0 || size != this.octets) {
            throw new DecoderException("Invalid content length, or reader index when decoding address [index: " + data.readerIndex() + ", expected length: " + this.octets + ", actual: " + size + "].");
        }
        byte[] address = new byte[this.octets];
        data.getBytes(data.readerIndex(), address);
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new DecoderException("Could not convert address " + data.toString(data.readerIndex(), size, CharsetUtil.UTF_8) + " to InetAddress.");
        }
    }
}

