/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl.netty;

public class DnsEntry {
    public static final int TYPE_A = 1;
    public static final int TYPE_NS = 2;
    public static final int TYPE_CNAME = 5;
    public static final int TYPE_SOA = 6;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_MX = 15;
    public static final int TYPE_TXT = 16;
    public static final int TYPE_RP = 17;
    public static final int TYPE_AFSDB = 18;
    public static final int TYPE_SIG = 24;
    public static final int TYPE_KEY = 25;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_LOC = 29;
    public static final int TYPE_SRV = 33;
    public static final int TYPE_NAPTR = 35;
    public static final int TYPE_KX = 36;
    public static final int TYPE_CERT = 37;
    public static final int TYPE_DNAME = 39;
    public static final int TYPE_OPT = 41;
    public static final int TYPE_APL = 42;
    public static final int TYPE_DS = 43;
    public static final int TYPE_SSHFP = 44;
    public static final int TYPE_IPSECKEY = 45;
    public static final int TYPE_RRSIG = 46;
    public static final int TYPE_NSEC = 47;
    public static final int TYPE_DNSKEY = 48;
    public static final int TYPE_DHCID = 49;
    public static final int TYPE_NSEC3 = 50;
    public static final int TYPE_NSEC3PARAM = 51;
    public static final int TYPE_TLSA = 52;
    public static final int TYPE_HIP = 55;
    public static final int TYPE_SPF = 99;
    public static final int TYPE_TKEY = 249;
    public static final int TYPE_TSIG = 250;
    public static final int TYPE_IXFR = 251;
    public static final int TYPE_AXFR = 252;
    public static final int TYPE_ANY = 255;
    public static final int TYPE_CAA = 257;
    public static final int TYPE_TA = 32768;
    public static final int TYPE_DLV = 32769;
    public static final int CLASS_IN = 1;
    public static final int CLASS_CSNET = 2;
    public static final int CLASS_CHAOS = 3;
    public static final int CLASS_HESIOD = 4;
    public static final int CLASS_NONE = 254;
    public static final int CLASS_ANY = 255;
    private final String name;
    private final int type;
    private final int dnsClass;

    public DnsEntry(String name, int type, int dnsClass) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must not be null or left blank.");
        }
        if ((type & 0xFFFF) != type) {
            throw new IllegalArgumentException("type must be an unsigned short.");
        }
        if (dnsClass < 1 || dnsClass > 4 && dnsClass != 254 && dnsClass != 255) {
            throw new IllegalArgumentException("an invalid class has been supplied.");
        }
        this.name = name;
        this.type = type;
        this.dnsClass = dnsClass;
    }

    public String name() {
        return this.name;
    }

    public int type() {
        return this.type;
    }

    public int dnsClass() {
        return this.dnsClass;
    }

    public int hashCode() {
        int hash = 7;
        for (int i = 0; i < this.name.length(); ++i) {
            hash = hash * 31 + this.name.charAt(i);
        }
        hash = hash * 31 + this.type;
        return hash * 31 + this.dnsClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(domain name: " + this.name + ", type: " + this.type + ", class: " + this.dnsClass + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DnsEntry) {
            if (o.hashCode() != this.hashCode()) {
                return false;
            }
            DnsEntry other = (DnsEntry)o;
            return other.name().equals(this.name) && other.type() == this.type && other.dnsClass() == this.dnsClass;
        }
        return false;
    }
}

