/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vertx.java.core.json.EncodeException;
import org.vertx.java.core.json.JsonElement;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.json.impl.Base64;
import org.vertx.java.core.json.impl.Json;

public class JsonArray
extends JsonElement
implements Iterable<Object> {
    final List<Object> list;

    public JsonArray(List<Object> array) {
        this.list = array;
    }

    public JsonArray(Object[] array) {
        this.list = Arrays.asList(array);
    }

    public JsonArray() {
        this.list = new ArrayList<Object>();
    }

    public JsonArray(String jsonString) {
        this.list = (List)Json.decodeValue(jsonString, List.class);
    }

    public JsonArray addString(String str) {
        this.list.add(str);
        return this;
    }

    public JsonArray addObject(JsonObject value) {
        this.list.add(value.map);
        return this;
    }

    public JsonArray addArray(JsonArray value) {
        this.list.add(value.list);
        return this;
    }

    public JsonArray addElement(JsonElement value) {
        if (value.isArray()) {
            return this.addArray(value.asArray());
        }
        return this.addObject(value.asObject());
    }

    public JsonArray addNumber(Number value) {
        this.list.add(value);
        return this;
    }

    public JsonArray addBoolean(Boolean value) {
        this.list.add(value);
        return this;
    }

    public JsonArray addBinary(byte[] value) {
        String encoded = Base64.encodeBytes(value);
        this.list.add(encoded);
        return this;
    }

    public JsonArray add(Object obj) {
        if (obj instanceof JsonObject) {
            obj = ((JsonObject)obj).map;
        } else if (obj instanceof JsonArray) {
            obj = ((JsonArray)obj).list;
        }
        this.list.add(obj);
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public <T> T get(int index) {
        return JsonArray.convertObject(this.list.get(index));
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            Iterator<Object> iter;
            {
                this.iter = JsonArray.this.list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Object next() {
                return JsonArray.convertObject(this.iter.next());
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    public String encode() throws EncodeException {
        return Json.encode(this.list);
    }

    public String encodePrettily() throws EncodeException {
        return Json.encodePrettily(this.list);
    }

    public JsonArray copy() {
        return new JsonArray(this.encode());
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray that = (JsonArray)o;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        Iterator<Object> iter = that.list.iterator();
        for (Object entry : this.list) {
            Object other;
            if (entry.equals(other = iter.next())) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        return JsonArray.convertList(this.list).toArray();
    }

    static List<Object> convertList(List<?> list) {
        ArrayList<Object> arr = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            if (obj instanceof Map) {
                arr.add(JsonObject.convertMap((Map)obj));
                continue;
            }
            if (obj instanceof JsonObject) {
                arr.add(((JsonObject)obj).toMap());
                continue;
            }
            if (obj instanceof List) {
                arr.add(JsonArray.convertList((List)obj));
                continue;
            }
            arr.add(obj);
        }
        return arr;
    }

    private static <T> T convertObject(Object obj) {
        Object retVal = obj;
        if (obj != null) {
            if (obj instanceof List) {
                retVal = new JsonArray((List)obj);
            } else if (obj instanceof Map) {
                retVal = new JsonObject((Map)obj);
            }
        }
        return (T)retVal;
    }
}

