/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.WebSocket;
import org.vertx.java.core.http.WebSocketVersion;
import org.vertx.java.core.http.impl.DefaultHttpClient;
import org.vertx.java.core.http.impl.DefaultHttpClientRequest;
import org.vertx.java.core.http.impl.DefaultHttpClientResponse;
import org.vertx.java.core.http.impl.DefaultWebSocket;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.ConnectionBase;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.VertxNetHandler;

class ClientConnection
extends ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(ClientConnection.class);
    final DefaultHttpClient client;
    final String hostHeader;
    private final boolean ssl;
    private final String host;
    private final int port;
    boolean keepAlive;
    private boolean wsHandshakeConnection;
    private WebSocketClientHandshaker handshaker;
    private volatile DefaultHttpClientRequest currentRequest;
    private final Queue<DefaultHttpClientRequest> requests = new ArrayDeque<DefaultHttpClientRequest>();
    private volatile DefaultHttpClientResponse currentResponse;
    private DefaultWebSocket ws;

    ClientConnection(VertxInternal vertx, DefaultHttpClient client, Channel channel, boolean ssl, String host, int port, boolean keepAlive, DefaultContext context) {
        super(vertx, channel, context);
        this.client = client;
        this.ssl = ssl;
        this.host = host;
        this.port = port;
        this.hostHeader = port == 80 && !ssl || port == 443 && ssl ? host : host + ':' + port;
        this.keepAlive = keepAlive;
    }

    void toWebSocket(String uri, WebSocketVersion wsVersion, MultiMap headers, int maxWebSocketFrameSize, Handler<WebSocket> wsConnect) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        try {
            DefaultHttpHeaders nettyHeaders;
            io.netty.handler.codec.http.websocketx.WebSocketVersion version;
            URI wsuri = new URI(uri);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.host + ":" + this.port + uri);
            }
            if (wsVersion == WebSocketVersion.HYBI_00) {
                version = io.netty.handler.codec.http.websocketx.WebSocketVersion.V00;
            } else if (wsVersion == WebSocketVersion.HYBI_08) {
                version = io.netty.handler.codec.http.websocketx.WebSocketVersion.V08;
            } else if (wsVersion == WebSocketVersion.RFC6455) {
                version = io.netty.handler.codec.http.websocketx.WebSocketVersion.V13;
            } else {
                throw new IllegalArgumentException("Invalid version");
            }
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    nettyHeaders.add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)wsuri, (io.netty.handler.codec.http.websocketx.WebSocketVersion)version, null, (boolean)false, (HttpHeaders)nettyHeaders, (int)maxWebSocketFrameSize);
            ChannelPipeline p = this.channel.pipeline();
            p.addBefore("handler", "handshakeCompleter", (ChannelHandler)new HandshakeInboundHandler(wsConnect));
            this.handshaker.handshake(this.channel).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ClientConnection.this.client.handleException((Exception)future.cause());
                    }
                }
            });
            this.wsHandshakeConnection = true;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
    }

    @Override
    public void close() {
        if (!this.wsHandshakeConnection) {
            if (!this.keepAlive) {
                super.close();
            } else {
                this.client.returnConnection(this);
            }
        }
    }

    boolean isClosed() {
        return !this.channel.isOpen();
    }

    int getOutstandingRequestCount() {
        return this.requests.size();
    }

    @Override
    public void handleInterestedOpsChanged() {
        try {
            if (!this.doWriteQueueFull()) {
                if (this.currentRequest != null) {
                    this.setContext();
                    this.currentRequest.handleDrained();
                } else if (this.ws != null) {
                    this.ws.writable();
                }
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponse(HttpResponse resp) {
        DefaultHttpClientResponse nResp;
        DefaultHttpClientRequest req = resp.getStatus().code() == 100 ? this.requests.peek() : this.requests.poll();
        if (req == null) {
            throw new IllegalStateException("No response handler");
        }
        this.setContext();
        this.currentResponse = nResp = new DefaultHttpClientResponse(this.vertx, req, this, resp);
        req.handleResponse(nResp);
    }

    void handleResponseChunk(Buffer buff) {
        this.setContext();
        try {
            this.currentResponse.handleChunk(buff);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponseEnd(LastHttpContent trailer) {
        this.setContext();
        try {
            this.currentResponse.handleEnd(trailer);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
        if (!this.keepAlive) {
            this.close();
        }
    }

    void handleWsFrame(WebSocketFrame frame) {
        if (this.ws != null) {
            this.setContext();
            this.ws.handleFrame(frame);
        }
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
    }

    @Override
    protected DefaultContext getContext() {
        return super.getContext();
    }

    @Override
    protected void handleException(Throwable e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        } else if (this.currentResponse != null) {
            this.currentResponse.handleException(e);
        }
    }

    void setCurrentRequest(DefaultHttpClientRequest req) {
        if (this.currentRequest != null) {
            throw new IllegalStateException("Connection is already writing a request");
        }
        this.currentRequest = req;
        this.requests.add(req);
    }

    void endRequest() {
        if (this.currentRequest == null) {
            throw new IllegalStateException("No write in progress");
        }
        this.currentRequest = null;
        if (this.keepAlive) {
            this.close();
        }
    }

    NetSocket createNetSocket() {
        DefaultNetSocket socket = new DefaultNetSocket(this.vertx, this.channel, this.context);
        HashMap<Channel, DefaultNetSocket> connectionMap = new HashMap<Channel, DefaultNetSocket>(1);
        connectionMap.put(this.channel, socket);
        this.endReadAndFlush();
        ChannelPipeline pipeline = this.channel.pipeline();
        ChannelHandler inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        pipeline.remove("codec");
        pipeline.replace("handler", "handler", (ChannelHandler)new VertxNetHandler(this.client.vertx, connectionMap){

            @Override
            public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
                ClientConnection.this.client.connectionMap.remove(ClientConnection.this.channel);
                super.exceptionCaught(chctx, t);
            }

            @Override
            public void channelInactive(ChannelHandlerContext chctx) throws Exception {
                ClientConnection.this.client.connectionMap.remove(ClientConnection.this.channel);
                super.channelInactive(chctx);
            }

            @Override
            public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                super.channelRead(chctx, msg);
            }
        });
        return socket;
    }

    private final class HandshakeInboundHandler
    extends ChannelInboundHandlerAdapter {
        private final Handler<WebSocket> wsConnect;
        private final DefaultContext context;
        private FullHttpResponse response;
        private boolean handshaking;
        private Queue<Object> buffered = new ArrayDeque<Object>();

        public HandshakeInboundHandler(Handler<WebSocket> wsConnect) {
            this.wsConnect = wsConnect;
            this.context = ClientConnection.this.vertx.getContext();
        }

        public void channelRead(final ChannelHandlerContext ctx, final Object msg) throws Exception {
            this.context.execute(ctx.channel().eventLoop(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean fire = false;
                    try {
                        if (ClientConnection.this.handshaker != null && !HandshakeInboundHandler.this.handshaking) {
                            if (msg instanceof HttpResponse) {
                                HttpResponse resp = (HttpResponse)msg;
                                if (resp.getStatus().code() != 101) {
                                    throw new WebSocketHandshakeException("Websocket connection attempt returned HTTP status code " + resp.getStatus().code());
                                }
                                HandshakeInboundHandler.this.response = (FullHttpResponse)new DefaultFullHttpResponse(resp.getProtocolVersion(), resp.getStatus());
                                HandshakeInboundHandler.this.response.headers().add(resp.headers());
                            }
                            if (msg instanceof HttpContent && HandshakeInboundHandler.this.response != null) {
                                HandshakeInboundHandler.this.response.content().writeBytes(((HttpContent)msg).content());
                                if (msg instanceof LastHttpContent) {
                                    HandshakeInboundHandler.this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                                    HandshakeInboundHandler.this.handshakeComplete(ctx, HandshakeInboundHandler.this.response);
                                    ClientConnection.this.channel.pipeline().remove((ChannelHandler)HandshakeInboundHandler.this);
                                    fire = true;
                                }
                            }
                        } else {
                            HandshakeInboundHandler.this.buffered.add(msg);
                        }
                    }
                    catch (WebSocketHandshakeException e) {
                        Object m;
                        fire = false;
                        while ((m = HandshakeInboundHandler.this.buffered.poll()) != null) {
                        }
                        ClientConnection.this.client.handleException((Exception)((Object)e));
                    }
                    finally {
                        if (fire) {
                            Object m;
                            while ((m = HandshakeInboundHandler.this.buffered.poll()) != null) {
                                ctx.fireChannelRead(m);
                            }
                        }
                    }
                }
            });
        }

        private void handshakeComplete(ChannelHandlerContext ctx, FullHttpResponse response) {
            this.handshaking = true;
            try {
                ChannelHandler handler = ctx.pipeline().get(HttpContentDecompressor.class);
                if (handler != null) {
                    ctx.pipeline().remove(handler);
                }
                ClientConnection.this.ws = new DefaultWebSocket(ClientConnection.this.vertx, ClientConnection.this);
                ClientConnection.this.handshaker.finishHandshake(ClientConnection.this.channel, response);
                log.debug("WebSocket handshake complete");
                this.wsConnect.handle(ClientConnection.this.ws);
            }
            catch (WebSocketHandshakeException e) {
                ClientConnection.this.client.handleException((Exception)((Object)e));
            }
        }
    }
}

