/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.VertxHandler;
import java.util.Map;

public class VertxNetHandler
extends VertxHandler<NetSocketImpl> {
    public VertxNetHandler(VertxInternal vertx, Map<Channel, NetSocketImpl> connectionMap) {
        super(vertx, connectionMap);
    }

    @Override
    protected void channelRead(NetSocketImpl sock, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        if (sock != null) {
            ByteBuf buf = (ByteBuf)msg;
            context.executeSync(() -> sock.handleDataReceived(Buffer.buffer(buf)));
        }
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof ByteBuf) {
            return VertxNetHandler.safeBuffer((ByteBuf)msg, allocator);
        }
        return msg;
    }
}

