/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class VertxEventLoopGroup
extends AbstractEventExecutorGroup
implements EventLoopGroup {
    private int pos;
    private final List<EventLoopHolder> workers = new ArrayList<EventLoopHolder>();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean gracefulShutdown = new AtomicBoolean();
    private final Promise<?> terminationFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);

    public synchronized EventLoop next() {
        if (this.workers.isEmpty()) {
            throw new IllegalStateException();
        }
        EventLoop worker = this.workers.get((int)this.pos).worker;
        ++this.pos;
        this.checkPos();
        return worker;
    }

    public Iterator<EventExecutor> iterator() {
        return new EventLoopIterator(this.workers.iterator());
    }

    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    public boolean isShutdown() {
        return this.latch.getCount() == 0L;
    }

    public boolean isTerminated() {
        return this.isShutdown();
    }

    public synchronized boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public synchronized void addWorker(EventLoop worker) {
        EventLoopHolder holder = this.findHolder(worker);
        if (holder == null) {
            this.workers.add(new EventLoopHolder(worker));
        } else {
            ++holder.count;
        }
    }

    public synchronized void shutdown() {
        for (EventLoopHolder holder : this.workers) {
            holder.worker.shutdown();
        }
        this.latch.countDown();
    }

    public boolean isShuttingDown() {
        return this.gracefulShutdown.get();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        if (this.gracefulShutdown.compareAndSet(false, true)) {
            AtomicInteger counter = new AtomicInteger(this.workers.size());
            for (EventLoopHolder holder : this.workers) {
                holder.worker.shutdownGracefully().addListener(future -> {
                    if (counter.decrementAndGet() == 0) {
                        this.terminationFuture.setSuccess(null);
                    }
                });
            }
        }
        return this.terminationFuture;
    }

    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    private EventLoopHolder findHolder(EventLoop worker) {
        EventLoopHolder wh = new EventLoopHolder(worker);
        for (EventLoopHolder holder : this.workers) {
            if (!holder.equals(wh)) continue;
            return holder;
        }
        return null;
    }

    public synchronized void removeWorker(EventLoop worker) {
        EventLoopHolder holder = this.findHolder(worker);
        if (holder != null) {
            --holder.count;
            if (holder.count == 0) {
                this.workers.remove(holder);
            }
        } else {
            throw new IllegalStateException("Can't find worker to remove");
        }
        this.checkPos();
    }

    public synchronized int workerCount() {
        return this.workers.size();
    }

    private void checkPos() {
        if (this.pos == this.workers.size()) {
            this.pos = 0;
        }
    }

    private static final class EventLoopIterator
    implements Iterator<EventExecutor> {
        private final Iterator<EventLoopHolder> holderIt;

        public EventLoopIterator(Iterator<EventLoopHolder> holderIt) {
            this.holderIt = holderIt;
        }

        @Override
        public boolean hasNext() {
            return this.holderIt.hasNext();
        }

        @Override
        public EventExecutor next() {
            return this.holderIt.next().worker;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read-only");
        }
    }

    private static class EventLoopHolder {
        int count = 1;
        final EventLoop worker;

        EventLoopHolder(EventLoop worker) {
            this.worker = worker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventLoopHolder that = (EventLoopHolder)o;
            return !(this.worker != null ? !this.worker.equals(that.worker) : that.worker != null);
        }

        public int hashCode() {
            return this.worker != null ? this.worker.hashCode() : 0;
        }
    }
}

