/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class ContextTest
extends VertxTestBase {
    @Test
    public void testRunOnContext() throws Exception {
        this.vertx.runOnContext(v -> {
            final Thread th = Thread.currentThread();
            final Context ctx = Vertx.currentContext();
            ctx.runOnContext(v2 -> {
                this.assertEquals(th, Thread.currentThread());
                for (int i = 0; i < 10; ++i) {
                    Context c = Vertx.currentContext();
                    this.assertEquals(ctx, c);
                }
                new Thread(){

                    @Override
                    public void run() {
                        ctx.runOnContext(v3 -> {
                            ContextTest.this.assertEquals(th, Thread.currentThread());
                            ContextTest.this.assertEquals(ctx, Vertx.currentContext());
                            ContextTest.this.testComplete();
                        });
                    }
                }.start();
            });
        });
        this.await();
    }

    @Test
    public void testNoContext() throws Exception {
        this.assertNull(Vertx.currentContext());
    }

    @Test
    public void testPutGetRemoveData() throws Exception {
        SomeObject obj = new SomeObject();
        this.vertx.runOnContext(v -> {
            Context ctx = Vertx.currentContext();
            ctx.put("foo", (Object)obj);
            ctx.runOnContext(v2 -> {
                this.assertEquals(obj, ctx.get("foo"));
                this.assertTrue(ctx.remove("foo"));
                ctx.runOnContext(v3 -> {
                    this.assertNull(ctx.get("foo"));
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testGettingContextContextUnderContextAnotherInstanceShouldReturnDifferentContext() throws Exception {
        Vertx other = Vertx.vertx();
        Context context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> {
            Context otherContext = other.getOrCreateContext();
            this.assertNotSame(otherContext, context);
            this.testComplete();
        });
        this.await();
    }

    class SomeObject {
        SomeObject() {
        }
    }
}

