/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Future;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;

public class FutureTest
extends VertxTestBase {
    @Test
    public void testStateAfterCompletion() {
        Object foo = new Object();
        Future future = Future.succeededFuture((Object)foo);
        this.assertTrue(future.succeeded());
        this.assertFalse(future.failed());
        this.assertTrue(future.isComplete());
        this.assertEquals(foo, future.result());
        this.assertNull(future.cause());
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        this.assertFalse(future.succeeded());
        this.assertTrue(future.failed());
        this.assertTrue(future.isComplete());
        this.assertNull(future.result());
        this.assertEquals(cause, future.cause());
    }

    @Test
    public void testSetResultOnCompletedFuture() {
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        for (Future future : futures) {
            try {
                future.complete(new Object());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                future.complete(null);
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                future.fail((Throwable)new Exception());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @Test
    public void testCallSetHandlerBeforeCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.future();
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertFalse(called.get());
        future.complete(null);
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.future();
        future.setHandler(result -> {
            called.set(true);
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
        });
        this.assertFalse(called.get());
        future.complete(foo);
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.future();
        future.setHandler(result -> {
            called.set(true);
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
        });
        this.assertFalse(called.get());
        future.fail((Throwable)cause);
        this.assertTrue(called.get());
    }

    @Test
    public void testCallSetHandlerAfterCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.succeededFuture();
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.succeededFuture((Object)foo);
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        future.setHandler(result -> {
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
    }
}

