/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.HAVerticle1;
import io.vertx.test.core.HAVerticle2;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class HATest
extends VertxTestBase {
    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Test
    public void testSimpleFailover() throws Exception {
        this.startNodes(2, new VertxOptions().setHAEnabled(true));
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertices[0].deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(1L, this.vertices[0].deploymentIDs().size());
            this.assertEquals(0L, this.vertices[1].deploymentIDs().size());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.kill(0);
        this.waitUntil(() -> this.vertices[1].deploymentIDs().size() == 1);
        this.checkDeploymentExists(1, "java:" + HAVerticle1.class.getName(), options);
    }

    @Test
    public void testQuorum() throws Exception {
        Vertx vertx1 = this.startVertx(2);
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx1.deploymentIDs().contains(ar.result()));
            this.testComplete();
        });
        this.waitUntil(() -> vertx1.deploymentIDs().isEmpty());
        Vertx vertx2 = this.startVertx(2);
        this.await();
        this.closeVertices(vertx1, vertx2);
    }

    @Test
    public void testQuorumLost() throws Exception {
        Vertx vertx1 = this.startVertx(3);
        Vertx vertx2 = this.startVertx(3);
        Vertx vertx3 = this.startVertx(3);
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx1.deploymentIDs().contains(ar.result()));
        });
        vertx2.deployVerticle("java:" + HAVerticle2.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx2.deploymentIDs().contains(ar.result()));
        });
        this.waitUntil(() -> vertx1.deploymentIDs().size() == 1 && vertx2.deploymentIDs().size() == 1);
        CountDownLatch latch = new CountDownLatch(1);
        vertx3.close(ar -> latch.countDown());
        this.awaitLatch(latch);
        this.waitUntil(() -> vertx1.deploymentIDs().isEmpty() && vertx2.deploymentIDs().isEmpty());
        Vertx vertx4 = this.startVertx(3);
        this.waitUntil(() -> vertx1.deploymentIDs().size() == 1 && vertx2.deploymentIDs().size() == 1);
        this.closeVertices(vertx1, vertx2, vertx4);
    }

    @Test
    public void testCleanCloseNoFailover() throws Exception {
        Vertx vertx1 = this.startVertx();
        Vertx vertx2 = this.startVertx();
        DeploymentOptions options = new DeploymentOptions().setHa(true);
        JsonObject config = new JsonObject().put("foo", "bar");
        options.setConfig(config);
        CountDownLatch deployLatch = new CountDownLatch(1);
        vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), options, ar -> {
            this.assertTrue(ar.succeeded());
            deployLatch.countDown();
        });
        this.awaitLatch(deployLatch);
        ((VertxInternal)vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not be called"));
        vertx2.close(ar -> this.vertx.setTimer(500L, tid -> this.testComplete()));
        this.await();
        this.closeVertices(vertx1);
    }

    @Test
    public void testFailureInFailover() throws Exception {
        Vertx vertx1 = this.startVertx();
        Vertx vertx2 = this.startVertx();
        Vertx vertx3 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx1.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        ((VertxInternal)vertx2).failDuringFailover(true);
        ((VertxInternal)vertx3).failDuringFailover(true);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxInternal)vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertFalse(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)vertx3).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertFalse(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)vertx1).simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(vertx2.deploymentIDs().isEmpty());
        this.assertTrue(vertx3.deploymentIDs().isEmpty());
        ((VertxInternal)vertx2).failDuringFailover(false);
        CountDownLatch latch3 = new CountDownLatch(1);
        ((VertxInternal)vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch3.countDown();
        });
        ((VertxInternal)vertx3).simulateKill();
        this.awaitLatch(latch3);
        this.waitUntil(() -> vertx2.deploymentIDs().size() == 1);
        this.closeVertices(vertx1, vertx2, vertx3);
    }

    @Test
    public void testHaGroups() throws Exception {
        Vertx vertx1 = this.startVertx("group1", 1);
        Vertx vertx2 = this.startVertx("group1", 1);
        Vertx vertx3 = this.startVertx("group2", 1);
        Vertx vertx4 = this.startVertx("group2", 1);
        CountDownLatch latch1 = new CountDownLatch(2);
        vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx1.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        vertx3.deployVerticle("java:" + HAVerticle2.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx3.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxInternal)vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 1"));
        ((VertxInternal)vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 2"));
        ((VertxInternal)vertx4).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)vertx3).simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(vertx4.deploymentIDs().size() == 1);
        CountDownLatch latch3 = new CountDownLatch(1);
        ((VertxInternal)vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch3.countDown();
        });
        ((VertxInternal)vertx4).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 4"));
        ((VertxInternal)vertx1).simulateKill();
        this.awaitLatch(latch3);
        this.assertTrue(vertx2.deploymentIDs().size() == 1);
        this.closeVertices(vertx1, vertx2, vertx3, vertx4);
    }

    @Test
    public void testNoFailoverToNonHANode() throws Exception {
        Vertx vertx1 = this.startVertx();
        Vertx vertx2 = this.startVertx(null, 0, false);
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx1.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        ((VertxInternal)vertx2).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 2"));
        ((VertxInternal)vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.fail("Should not failover here 1"));
        ((VertxInternal)vertx1).simulateKill();
        vertx2.close(ar -> this.vertx.setTimer(500L, tid -> this.testComplete()));
        this.await();
        this.closeVertices(vertx2);
    }

    @Test
    public void testNonHADeployments() throws Exception {
        Vertx vertx1 = this.startVertx();
        Vertx vertx2 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(2);
        vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx2.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        vertx2.deployVerticle("java:" + HAVerticle2.class.getName(), new DeploymentOptions().setHa(false), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx2.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((VertxInternal)vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
            this.assertTrue(succeeded);
            latch2.countDown();
        });
        ((VertxInternal)vertx2).simulateKill();
        this.awaitLatch(latch2);
        this.assertTrue(vertx1.deploymentIDs().size() == 1);
        String depID = (String)vertx1.deploymentIDs().iterator().next();
        this.assertTrue(((VertxInternal)vertx1).getDeployment(depID).verticleIdentifier().equals("java:" + HAVerticle1.class.getName()));
        this.closeVertices(vertx1, vertx2);
    }

    @Test
    public void testCloseRemovesFromCluster() throws Exception {
        Vertx vertx1 = this.startVertx();
        Vertx vertx2 = this.startVertx();
        Vertx vertx3 = this.startVertx();
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx3.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx3.deploymentIDs().contains(ar.result()));
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx2.close(ar -> {
            ((VertxInternal)vertx1).failoverCompleteHandler((nodeID, haInfo, succeeded) -> {
                this.assertTrue(succeeded);
                latch2.countDown();
            });
            ((VertxInternal)vertx3).simulateKill();
        });
        this.awaitLatch(latch2);
        this.assertTrue(vertx1.deploymentIDs().size() == 1);
        String depID = (String)vertx1.deploymentIDs().iterator().next();
        this.assertTrue(((VertxInternal)vertx1).getDeployment(depID).verticleIdentifier().equals("java:" + HAVerticle1.class.getName()));
        this.closeVertices(vertx1, vertx3);
    }

    @Test
    public void testQuorumWithHaGroups() throws Exception {
        Vertx vertx1 = this.startVertx("group1", 2);
        Vertx vertx2 = this.startVertx("group2", 2);
        vertx1.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx1.deploymentIDs().contains(ar.result()));
        });
        Thread.sleep(500L);
        this.assertTrue(vertx1.deploymentIDs().isEmpty());
        Vertx vertx3 = this.startVertx("group1", 2);
        this.waitUntil(() -> vertx1.deploymentIDs().size() == 1);
        vertx2.deployVerticle("java:" + HAVerticle1.class.getName(), new DeploymentOptions().setHa(true), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertTrue(vertx2.deploymentIDs().contains(ar.result()));
        });
        Thread.sleep(500L);
        this.assertTrue(vertx2.deploymentIDs().isEmpty());
        Vertx vertx4 = this.startVertx("group2", 2);
        this.waitUntil(() -> vertx2.deploymentIDs().size() == 1);
        CountDownLatch latch = new CountDownLatch(1);
        vertx4.close(ar -> latch.countDown());
        this.awaitLatch(latch);
        this.waitUntil(() -> vertx2.deploymentIDs().isEmpty());
        this.assertTrue(vertx1.deploymentIDs().size() == 1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx3.close(ar -> latch2.countDown());
        this.awaitLatch(latch2);
        this.waitUntil(() -> vertx1.deploymentIDs().isEmpty());
        this.closeVertices(vertx1, vertx2);
    }

    protected Vertx startVertx() throws Exception {
        return this.startVertx(null, 1);
    }

    protected Vertx startVertx(int quorumSize) throws Exception {
        return this.startVertx(null, quorumSize);
    }

    protected Vertx startVertx(String haGroup, int quorumSize) throws Exception {
        return this.startVertx(haGroup, quorumSize, true);
    }

    protected Vertx startVertx(String haGroup, int quorumSize, boolean ha) throws Exception {
        VertxOptions options = new VertxOptions().setHAEnabled(ha).setClustered(true).setClusterHost("localhost").setClusterManager(this.getClusterManager());
        if (ha) {
            options.setQuorumSize(quorumSize);
            if (haGroup != null) {
                options.setHAGroup(haGroup);
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference vertxRef = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options, this.onSuccess(vertx -> {
            vertxRef.set(vertx);
            latch.countDown();
        }));
        latch.await(2L, TimeUnit.MINUTES);
        return (Vertx)vertxRef.get();
    }

    protected void checkDeploymentExists(int pos, String verticleName, DeploymentOptions options) {
        VertxInternal vi = (VertxInternal)this.vertices[pos];
        for (String deploymentID : vi.deploymentIDs()) {
            Deployment dep = vi.getDeployment(deploymentID);
            if (!verticleName.equals(dep.verticleIdentifier()) || !options.equals((Object)dep.deploymentOptions())) continue;
            return;
        }
        this.fail("Can't find deployment for verticleName: " + verticleName + " on node " + pos);
    }

    protected void kill(int pos) {
        VertxInternal v = (VertxInternal)this.vertices[pos];
        v.executeBlocking(fut -> {
            v.simulateKill();
            fut.complete();
        }, ar -> this.assertTrue(ar.succeeded()));
    }

    protected void closeVertices(Vertx ... vertices) throws Exception {
        CountDownLatch latch = new CountDownLatch(vertices.length);
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i].close(this.onSuccess(res -> latch.countDown()));
        }
        latch.await(2L, TimeUnit.MINUTES);
    }
}

