/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.NetworkOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.SocketDefaults;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.HttpTestBase;
import io.vertx.test.core.KeyCert;
import io.vertx.test.core.SimpleServer;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.Trust;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HttpTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    private File testDir;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testDir = this.testFolder.newFolder();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        this.client = this.vertx.createHttpClient(new HttpClientOptions());
    }

    @Test
    public void testClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        this.assertEquals(NetworkOptions.DEFAULT_SEND_BUFFER_SIZE, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(NetworkOptions.DEFAULT_RECEIVE_BUFFER_SIZE, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(NetworkOptions.DEFAULT_TRAFFIC_CLASS, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-1));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = SocketDefaults.instance.isTcpKeepAlive();
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = SocketDefaults.instance.getSoLinger();
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-1));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(10));
        this.assertEquals(10L, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertFalse(options.isTrustAll());
        this.assertEquals(options, options.setTrustAll(true));
        this.assertTrue(options.isTrustAll());
        this.assertTrue(options.isVerifyHost());
        this.assertEquals(options, options.setVerifyHost(false));
        this.assertFalse(options.isVerifyHost());
        this.assertEquals(5L, options.getMaxPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxPoolSize(rand));
        this.assertEquals(rand, options.getMaxPoolSize());
        TestUtils.assertIllegalArgumentException(() -> options.setMaxPoolSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setMaxPoolSize(-1));
        this.assertTrue(options.isKeepAlive());
        this.assertEquals(options, options.setKeepAlive(false));
        this.assertFalse(options.isKeepAlive());
        this.assertFalse(options.isPipelining());
        this.assertEquals(options, options.setPipelining(true));
        this.assertTrue(options.isPipelining());
        this.assertEquals(60000L, options.getConnectTimeout());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setConnectTimeout(rand));
        this.assertEquals(rand, options.getConnectTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setConnectTimeout(-2));
        this.assertFalse(options.isTryUseCompression());
        this.assertEquals(options, options.setTryUseCompression(true));
        this.assertEquals(true, options.isTryUseCompression());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.testComplete();
    }

    @Test
    public void testServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        this.assertEquals(NetworkOptions.DEFAULT_SEND_BUFFER_SIZE, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(NetworkOptions.DEFAULT_RECEIVE_BUFFER_SIZE, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(NetworkOptions.DEFAULT_TRAFFIC_CLASS, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-1));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = SocketDefaults.instance.isTcpKeepAlive();
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = SocketDefaults.instance.getSoLinger();
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-1));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(10));
        this.assertEquals(10L, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(1024L, options.getAcceptBacklog());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setAcceptBacklog(rand));
        this.assertEquals(rand, options.getAcceptBacklog());
        this.assertFalse(options.isCompressionSupported());
        this.assertEquals(options, options.setCompressionSupported(true));
        this.assertTrue(options.isCompressionSupported());
        this.assertEquals(65536L, options.getMaxWebsocketFrameSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxWebsocketFrameSize(rand));
        this.assertEquals(rand, options.getMaxWebsocketFrameSize());
        this.assertEquals(80L, options.getPort());
        this.assertEquals(options, options.setPort(1234));
        this.assertEquals(1234L, options.getPort());
        TestUtils.assertIllegalArgumentException(() -> options.setPort(-1));
        TestUtils.assertIllegalArgumentException(() -> options.setPort(65536));
        this.assertEquals("0.0.0.0", options.getHost());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHost(randString));
        this.assertEquals(randString, options.getHost());
        this.assertNull(options.getWebsocketSubProtocols());
        this.assertEquals(options, options.setWebsocketSubProtocol("foo"));
        this.assertEquals("foo", options.getWebsocketSubProtocols());
        HttpServerOptions optionsCopy = new HttpServerOptions(options);
        this.assertEquals(options, optionsCopy.setWebsocketSubProtocol(new String(options.getWebsocketSubProtocols())));
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.testComplete();
    }

    @Test
    public void testCopyClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        boolean verifyHost = rand.nextBoolean();
        int maxPoolSize = TestUtils.randomPositiveInt();
        boolean keepAlive = rand.nextBoolean();
        boolean pipelining = rand.nextBoolean();
        boolean tryUseCompression = rand.nextBoolean();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setSsl(ssl);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.setConnectTimeout(connectTimeout);
        options.setTrustAll(trustAll);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setVerifyHost(verifyHost);
        options.setMaxPoolSize(maxPoolSize);
        options.setKeepAlive(keepAlive);
        options.setPipelining(pipelining);
        options.setTryUseCompression(tryUseCompression);
        HttpClientOptions copy = new HttpClientOptions(options);
        this.assertEquals(sendBufferSize, copy.getSendBufferSize());
        this.assertEquals(receiverBufferSize, copy.getReceiveBufferSize());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(trafficClass, copy.getTrafficClass());
        this.assertEquals(tcpNoDelay, copy.isTcpNoDelay());
        this.assertEquals(tcpKeepAlive, copy.isTcpKeepAlive());
        this.assertEquals(soLinger, copy.getSoLinger());
        this.assertEquals(usePooledBuffers, copy.isUsePooledBuffers());
        this.assertEquals(idleTimeout, copy.getIdleTimeout());
        this.assertEquals(ssl, copy.isSsl());
        this.assertNotSame(keyStoreOptions, copy.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)copy.getKeyCertOptions()).getPassword());
        this.assertNotSame(trustStoreOptions, copy.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)copy.getTrustOptions()).getPassword());
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertTrue(copy.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, copy.getConnectTimeout());
        this.assertEquals(trustAll, copy.isTrustAll());
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(crlPath, copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(crlValue, copy.getCrlValues().get(0));
        this.assertEquals(verifyHost, copy.isVerifyHost());
        this.assertEquals(maxPoolSize, copy.getMaxPoolSize());
        this.assertEquals(keepAlive, copy.isKeepAlive());
        this.assertEquals(pipelining, copy.isPipelining());
        this.assertEquals(tryUseCompression, copy.isTryUseCompression());
    }

    @Test
    public void testDefaultClientOptionsJson() {
        HttpClientOptions def = new HttpClientOptions();
        HttpClientOptions json = new HttpClientOptions(new JsonObject());
        this.assertEquals(def.getMaxPoolSize(), json.getMaxPoolSize());
        this.assertEquals(def.isKeepAlive(), json.isKeepAlive());
        this.assertEquals(def.isPipelining(), json.isPipelining());
        this.assertEquals(def.isVerifyHost(), json.isVerifyHost());
        this.assertEquals(def.isTryUseCompression(), json.isTryUseCompression());
        this.assertEquals(def.isTrustAll(), json.isTrustAll());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getConnectTimeout(), json.getConnectTimeout());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
    }

    @Test
    public void testClientOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 127;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        boolean verifyHost = rand.nextBoolean();
        int maxPoolSize = TestUtils.randomPositiveInt();
        boolean keepAlive = rand.nextBoolean();
        boolean pipelining = rand.nextBoolean();
        boolean tryUseCompression = rand.nextBoolean();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("connectTimeout", Integer.valueOf(connectTimeout)).put("trustAll", Boolean.valueOf(trustAll)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("type", "jks").put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("type", "jks").put("password", tsPassword).put("path", tsPath)).put("verifyHost", Boolean.valueOf(verifyHost)).put("maxPoolSize", Integer.valueOf(maxPoolSize)).put("keepAlive", Boolean.valueOf(keepAlive)).put("pipelining", Boolean.valueOf(pipelining)).put("tryUseCompression", Boolean.valueOf(tryUseCompression));
        HttpClientOptions options = new HttpClientOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, options.getConnectTimeout());
        this.assertEquals(trustAll, options.isTrustAll());
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(verifyHost, options.isVerifyHost());
        this.assertEquals(maxPoolSize, options.getMaxPoolSize());
        this.assertEquals(keepAlive, options.isKeepAlive());
        this.assertEquals(pipelining, options.isPipelining());
        this.assertEquals(tryUseCompression, options.isTryUseCompression());
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new HttpClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new HttpClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testCopyServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean compressionSupported = rand.nextBoolean();
        int maxWebsocketFrameSize = TestUtils.randomPositiveInt();
        String wsSubProtocol = TestUtils.randomAlphaString(10);
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setSsl(ssl);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setPort(port);
        options.setHost(host);
        options.setAcceptBacklog(acceptBacklog);
        options.setCompressionSupported(compressionSupported);
        options.setMaxWebsocketFrameSize(maxWebsocketFrameSize);
        options.setWebsocketSubProtocol(wsSubProtocol);
        HttpServerOptions copy = new HttpServerOptions(options);
        this.assertEquals(sendBufferSize, copy.getSendBufferSize());
        this.assertEquals(receiverBufferSize, copy.getReceiveBufferSize());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(trafficClass, copy.getTrafficClass());
        this.assertEquals(tcpNoDelay, copy.isTcpNoDelay());
        this.assertEquals(tcpKeepAlive, copy.isTcpKeepAlive());
        this.assertEquals(soLinger, copy.getSoLinger());
        this.assertEquals(usePooledBuffers, copy.isUsePooledBuffers());
        this.assertEquals(idleTimeout, copy.getIdleTimeout());
        this.assertEquals(ssl, copy.isSsl());
        this.assertNotSame(keyStoreOptions, copy.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)copy.getKeyCertOptions()).getPassword());
        this.assertNotSame(trustStoreOptions, copy.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)copy.getTrustOptions()).getPassword());
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertTrue(copy.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(crlPath, copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(crlValue, copy.getCrlValues().get(0));
        this.assertEquals(port, copy.getPort());
        this.assertEquals(host, copy.getHost());
        this.assertEquals(acceptBacklog, copy.getAcceptBacklog());
        this.assertEquals(compressionSupported, copy.isCompressionSupported());
        this.assertEquals(maxWebsocketFrameSize, options.getMaxWebsocketFrameSize());
        this.assertEquals(wsSubProtocol, options.getWebsocketSubProtocols());
    }

    @Test
    public void testDefaultServerOptionsJson() {
        HttpServerOptions def = new HttpServerOptions();
        HttpServerOptions json = new HttpServerOptions(new JsonObject());
        this.assertEquals(def.getMaxWebsocketFrameSize(), json.getMaxWebsocketFrameSize());
        this.assertEquals(def.getWebsocketSubProtocols(), json.getWebsocketSubProtocols());
        this.assertEquals(def.isCompressionSupported(), json.isCompressionSupported());
        this.assertEquals(def.isClientAuthRequired(), json.isClientAuthRequired());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
    }

    @Test
    public void testServerOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 127;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean compressionSupported = rand.nextBoolean();
        int maxWebsocketFrameSize = TestUtils.randomPositiveInt();
        String wsSubProtocol = TestUtils.randomAlphaString(10);
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("type", "jks").put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("type", "jks").put("password", tsPassword).put("path", tsPath)).put("port", Integer.valueOf(port)).put("host", host).put("acceptBacklog", Integer.valueOf(acceptBacklog)).put("compressionSupported", Boolean.valueOf(compressionSupported)).put("maxWebsocketFrameSize", Integer.valueOf(maxWebsocketFrameSize)).put("websocketSubProtocols", wsSubProtocol);
        HttpServerOptions options = new HttpServerOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(port, options.getPort());
        this.assertEquals(host, options.getHost());
        this.assertEquals(acceptBacklog, options.getAcceptBacklog());
        this.assertEquals(compressionSupported, options.isCompressionSupported());
        this.assertEquals(maxWebsocketFrameSize, options.getMaxWebsocketFrameSize());
        this.assertEquals(wsSubProtocol, options.getWebsocketSubProtocols());
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new HttpServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new HttpServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testServerChaining() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().setChunked(true) == req.response());
            this.assertTrue(req.response().write("foo", "UTF-8") == req.response());
            this.assertTrue(req.response().write("foo") == req.response());
            this.testComplete();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testServerChainingSendFile() throws Exception {
        File file = this.setupFile("test-server-chaining.dat", "blah");
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().sendFile(file.getAbsolutePath()) == req.response());
            this.assertTrue(req.response().ended());
            file.delete();
            this.testComplete();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testClientRequestArguments() throws Exception {
        HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler());
        TestUtils.assertNullPointerException(() -> req.putHeader((String)null, "someValue"));
        TestUtils.assertNullPointerException(() -> req.putHeader((CharSequence)null, (CharSequence)"someValue"));
        TestUtils.assertNullPointerException(() -> req.putHeader("someKey", (Iterable)null));
        TestUtils.assertNullPointerException(() -> req.write((Buffer)null));
        TestUtils.assertNullPointerException(() -> req.write((String)null));
        TestUtils.assertNullPointerException(() -> req.write(null, "UTF-8"));
        TestUtils.assertNullPointerException(() -> req.write("someString", null));
        TestUtils.assertNullPointerException(() -> req.end((Buffer)null));
        TestUtils.assertNullPointerException(() -> req.end((String)null));
        TestUtils.assertNullPointerException(() -> req.end(null, "UTF-8"));
        TestUtils.assertNullPointerException(() -> req.end("someString", null));
        TestUtils.assertIllegalArgumentException(() -> req.setTimeout(0L));
    }

    @Test
    public void testClientChaining() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler());
            this.assertTrue(req.setChunked(true) == req);
            this.assertTrue(req.sendHead() == req);
            this.assertTrue(req.write("foo", "UTF-8") == req);
            this.assertTrue(req.write("foo") == req);
            this.assertTrue(req.write(Buffer.buffer((String)"foo")) == req);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testLowerCaseHeaders() {
        this.server.requestHandler(req -> {
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.response().putHeader("Quux", "quux");
            this.assertEquals("quux", req.response().headers().get("Quux"));
            this.assertEquals("quux", req.response().headers().get("quux"));
            this.assertEquals("quux", req.response().headers().get("qUUX"));
            this.assertTrue(req.response().headers().contains("Quux"));
            this.assertTrue(req.response().headers().contains("quux"));
            this.assertTrue(req.response().headers().contains("qUUX"));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals("quux", resp.headers().get("Quux"));
                this.assertEquals("quux", resp.headers().get("quux"));
                this.assertEquals("quux", resp.headers().get("qUUX"));
                this.assertTrue(resp.headers().contains("Quux"));
                this.assertTrue(resp.headers().contains("quux"));
                this.assertTrue(resp.headers().contains("qUUX"));
                this.testComplete();
            });
            req.putHeader("Foo", "foo");
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testPutHeadersOnRequest() {
        this.server.requestHandler(req -> {
            this.assertEquals("bar", req.headers().get("foo"));
            this.assertEquals("bar", req.getHeader("foo"));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).putHeader("foo", "bar").end()));
        this.await();
    }

    @Test
    public void testRequestNPE() {
        String uri = "/some-uri?foo=bar";
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", uri, null));
        TestUtils.assertNullPointerException(() -> this.client.request((HttpMethod)null, 8080, "localhost", uri, resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.requestAbs((HttpMethod)null, "http://someuri", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", "/somepath", null));
        TestUtils.assertNullPointerException(() -> this.client.request((HttpMethod)null, 8080, "localhost", "/somepath", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, null, "/somepath", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", null, resp -> {}));
    }

    @Test
    public void testInvalidAbsoluteURI() {
        try {
            this.client.requestAbs(HttpMethod.GET, "ijdijwidjqwoijd192d192192ej12d", resp -> {}).end();
            this.fail("Should throw exception");
        }
        catch (VertxException vertxException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleGET() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOST() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEAD() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONS() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCH() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleGETAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOSTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEADAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONSAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCHAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    private void testSimpleRequest(String uri, HttpMethod method, Handler<HttpClientResponse> handler) {
        this.testSimpleRequest(uri, method, false, handler);
    }

    private void testSimpleRequest(String uri, HttpMethod method, boolean absolute, Handler<HttpClientResponse> handler) {
        HttpClientRequest req = absolute ? this.client.requestAbs(method, "http://localhost:8080" + uri, handler) : this.client.request(method, 8080, "localhost", uri, handler);
        this.testSimpleRequest(uri, method, req);
    }

    private void testSimpleRequest(String uri, HttpMethod method, HttpClientRequest request) {
        int index = uri.indexOf(63);
        String path = index == -1 ? uri : uri.substring(0, index);
        String query = index == -1 ? null : uri.substring(index + 1);
        this.server.requestHandler(req -> {
            this.assertEquals(path, req.path());
            this.assertEquals(method, req.method());
            this.assertEquals(query, req.query());
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> request.end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlers1() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(fut -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
                fut.complete();
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end();
        }).listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            this.complete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlers2() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(fut -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
                fut.complete();
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end("blah");
        }).listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)"blah"), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlersSendFile() throws Exception {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String content = "iqdioqwdqwiojqwijdwqd";
        File toSend = this.setupFile("somefile.txt", content);
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(fut -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
                fut.complete();
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().sendFile(toSend.getAbsolutePath());
        }).listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testAbsoluteURI() {
        this.testURIAndPath("http://localhost:8080/this/is/a/path/foo.html", "/this/is/a/path/foo.html");
    }

    @Test
    public void testRelativeURI() {
        this.testURIAndPath("/this/is/a/path/foo.html", "/this/is/a/path/foo.html");
    }

    @Test
    public void testAbsoluteURIWithHttpSchemaInQuery() {
        this.testURIAndPath("http://localhost:8080/correct/path?url=http://localhost:8008/wrong/path", "/correct/path");
    }

    @Test
    public void testRelativeURIWithHttpSchemaInQuery() {
        this.testURIAndPath("/correct/path?url=http://localhost:8008/wrong/path", "/correct/path");
    }

    @Test
    public void testAbsoluteURIEmptyPath() {
        this.testURIAndPath("http://localhost:8080/", "/");
    }

    private void testURIAndPath(String uri, String path) {
        this.server.requestHandler(req -> {
            this.assertEquals(uri, req.uri());
            this.assertEquals(path, req.path());
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", uri, resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testParamUmlauteDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6");
    }

    @Test
    public void testParamPlusDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("+");
    }

    @Test
    public void testParamPercentDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("%");
    }

    @Test
    public void testParamSpaceDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding(" ");
    }

    @Test
    public void testParamNormalDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("hello");
    }

    @Test
    public void testParamAltogetherDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6+% hello");
    }

    private void testParamDecoding(String value) throws UnsupportedEncodingException {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                MultiMap formAttributes = req.formAttributes();
                this.assertEquals(value, formAttributes.get("param"));
            });
            req.response().end();
        });
        String postData = "param=" + URLEncoder.encode(value, "UTF-8");
        this.server.listen(this.onSuccess(server -> this.client.post(8080, "localhost", "/").putHeader(io.vertx.core.http.HttpHeaders.CONTENT_TYPE, io.vertx.core.http.HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED).putHeader(io.vertx.core.http.HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(postData.length())).handler(resp -> this.testComplete()).write(postData).end()));
        this.await();
    }

    @Test
    public void testParamsAmpersand() {
        this.testParams('&');
    }

    @Test
    public void testParamsSemiColon() {
        this.testParams(';');
    }

    private void testParams(char delim) {
        Map<String, String> params = HttpTest.genMap(10);
        String query = HttpTest.generateQueryString(params, delim);
        this.server.requestHandler(req -> {
            this.assertEquals(query, req.query());
            this.assertEquals(params.size(), req.params().size());
            for (Map.Entry entry : req.params()) {
                this.assertEquals(entry.getValue(), params.get(entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri/?" + query, resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testNoParams() {
        this.server.requestHandler(req -> {
            this.assertNull(req.query());
            this.assertTrue(req.params().isEmpty());
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testDefaultRequestHeaders() {
        this.server.requestHandler(req -> {
            this.assertEquals(1L, req.headers().size());
            this.assertEquals("localhost:8080", req.headers().get("host"));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testRequestHeadersPutAll() {
        this.testRequestHeaders(false);
    }

    @Test
    public void testRequestHeadersIndividually() {
        this.testRequestHeaders(true);
    }

    private void testRequestHeaders(boolean individually) {
        MultiMap headers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            this.assertEquals(headers.size() + 1, req.headers().size());
            for (Map.Entry entry : headers) {
                this.assertEquals(entry.getValue(), req.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), req.getHeader((String)entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete());
            if (individually) {
                for (Map.Entry header : headers) {
                    req.headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.headers().setAll(headers);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testResponseHeadersPutAll() {
        this.testResponseHeaders(false);
    }

    @Test
    public void testResponseHeadersIndividually() {
        this.testResponseHeaders(true);
    }

    private void testResponseHeaders(boolean individually) {
        MultiMap headers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            if (individually) {
                for (Map.Entry header : headers) {
                    req.response().headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().headers().setAll(headers);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(headers.size() + 1, resp.headers().size());
            for (Map.Entry entry : headers) {
                this.assertEquals(entry.getValue(), resp.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getHeader((String)entry.getKey()));
            }
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseMultipleSetCookieInHeader() {
        this.testResponseMultipleSetCookie(true, false);
    }

    @Test
    public void testResponseMultipleSetCookieInTrailer() {
        this.testResponseMultipleSetCookie(false, true);
    }

    @Test
    public void testResponseMultipleSetCookieInHeaderAndTrailer() {
        this.testResponseMultipleSetCookie(true, true);
    }

    private void testResponseMultipleSetCookie(boolean inHeader, boolean inTrailer) {
        ArrayList cookies = new ArrayList();
        this.server.requestHandler(req -> {
            if (inHeader) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("h1=h1v1");
                headers.add("h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(headers);
                req.response().headers().set("Set-Cookie", headers);
            }
            if (inTrailer) {
                req.response().setChunked(true);
                ArrayList<String> trailers = new ArrayList<String>();
                trailers.add("t1=t1v1");
                trailers.add("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(trailers);
                req.response().trailers().set("Set-Cookie", trailers);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertEquals(cookies.size(), resp.cookies().size());
            for (int i = 0; i < cookies.size(); ++i) {
                this.assertEquals(cookies.get(i), resp.cookies().get(i));
            }
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testUseRequestAfterComplete() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            req.end();
            Buffer buff = Buffer.buffer();
            TestUtils.assertIllegalStateException(() -> req.end());
            TestUtils.assertIllegalStateException(() -> req.continueHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> req.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> req.end("foo"));
            TestUtils.assertIllegalStateException(() -> req.end(buff));
            TestUtils.assertIllegalStateException(() -> req.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> req.sendHead());
            TestUtils.assertIllegalStateException(() -> req.setChunked(false));
            TestUtils.assertIllegalStateException(() -> req.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateException(() -> req.write(buff));
            TestUtils.assertIllegalStateException(() -> req.write("foo"));
            TestUtils.assertIllegalStateException(() -> req.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> req.write(buff));
            TestUtils.assertIllegalStateException(() -> req.writeQueueFull());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRequestBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buffer2 -> {
            this.assertEquals(body, buffer2);
            req.response().end();
        }));
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> this.testComplete()).end(body)));
        this.await();
    }

    @Test
    public void testRequestBodyStringDefaultEncodingAtEnd() {
        this.testRequestBodyStringAtEnd(null);
    }

    @Test
    public void testRequestBodyStringUTF8AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-8");
    }

    @Test
    public void testRequestBodyStringUTF16AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-16");
    }

    private void testRequestBodyStringAtEnd(String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buffer2 -> {
            this.assertEquals(bodyBuff, buffer2);
            this.testComplete();
        }));
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            if (encoding == null) {
                req.end(body);
            } else {
                req.end(body, encoding);
            }
        }));
        this.await();
    }

    @Test
    public void testRequestBodyWriteChunked() {
        this.testRequestBodyWrite(true);
    }

    @Test
    public void testRequestBodyWriteNonChunked() {
        this.testRequestBodyWrite(false);
    }

    private void testRequestBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        this.server.requestHandler(req -> req.bodyHandler(buffer2 -> {
            this.assertEquals(body, buffer2);
            req.response().end();
        }));
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> this.testComplete());
            int numWrites = 10;
            int chunkSize = 100;
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.write(b);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestBodyWriteStringChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(true, null);
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF8() {
        this.testRequestBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF16() {
        this.testRequestBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(false, null);
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF8() {
        this.testRequestBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF16() {
        this.testRequestBodyWriteString(false, "UTF-16");
    }

    private void testRequestBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        }));
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.write(body);
            } else {
                req.write(body, encoding);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestWrite() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        }));
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            req.write(body);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testConnectWithoutResponseHandler() throws Exception {
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end("whatever");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end("whatever", "UTF-8");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end(Buffer.buffer((String)"whatever"));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").sendHead();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write(Buffer.buffer((String)"whatever"));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write("whatever");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write("whatever", "UTF-8");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testClientExceptionHandlerCalledWhenFailingToConnect() throws Exception {
        this.client.request(HttpMethod.GET, 9998, "255.255.255.255", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(error -> this.testComplete()).endHandler(done -> this.fail()).end();
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnection() throws Exception {
        int numReqs = 10;
        CountDownLatch latch = new CountDownLatch(numReqs);
        this.server.requestHandler(request -> request.response().close()).listen(8080, this.onSuccess(s -> {
            for (int i = 0; i < numReqs; ++i) {
                this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(error -> latch.countDown()).endHandler(done -> this.fail()).end();
            }
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnectionAfterPartialResponse() throws Exception {
        this.server.requestHandler(request -> request.response().setChunked(true).write("foo").close()).listen(8080, this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.exceptionHandler(t -> this.testComplete())).exceptionHandler(error -> this.fail()).end()));
        this.await();
    }

    @Test
    public void testDefaultStatus() {
        this.testStatusCode(-1, null);
    }

    @Test
    public void testDefaultOther() {
        this.testStatusCode(405, null);
    }

    @Test
    public void testOverrideStatusMessage() {
        this.testStatusCode(404, "some message");
    }

    @Test
    public void testOverrideDefaultStatusMessage() {
        this.testStatusCode(-1, "some other message");
    }

    private void testStatusCode(int code, String statusMessage) {
        this.server.requestHandler(req -> {
            if (code != -1) {
                req.response().setStatusCode(code);
            }
            if (statusMessage != null) {
                req.response().setStatusMessage(statusMessage);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            int theCode;
            if (code == -1) {
                this.assertEquals(200L, resp.statusCode());
                theCode = 200;
            } else {
                theCode = code;
            }
            if (statusMessage != null) {
                this.assertEquals(statusMessage, resp.statusMessage());
            } else {
                this.assertEquals(HttpResponseStatus.valueOf((int)theCode).reasonPhrase(), resp.statusMessage());
            }
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseTrailersPutAll() {
        this.testResponseTrailers(false);
    }

    @Test
    public void testResponseTrailersPutIndividually() {
        this.testResponseTrailers(true);
    }

    private void testResponseTrailers(boolean individually) {
        MultiMap trailers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            if (individually) {
                for (Map.Entry header : trailers) {
                    req.response().trailers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().trailers().setAll(trailers);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertEquals(trailers.size(), resp.trailers().size());
            for (Map.Entry entry : trailers) {
                this.assertEquals(entry.getValue(), resp.trailers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getTrailer((String)entry.getKey()));
            }
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseNoTrailers() {
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertTrue(resp.trailers().isEmpty());
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testUseResponseAfterComplete() {
        this.server.requestHandler(req -> {
            Buffer buff = Buffer.buffer();
            HttpServerResponse resp = req.response();
            this.assertFalse(resp.ended());
            resp.end();
            this.assertTrue(resp.ended());
            TestUtils.assertIllegalStateException(() -> resp.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.end());
            TestUtils.assertIllegalStateException(() -> resp.end("foo"));
            TestUtils.assertIllegalStateException(() -> resp.end(buff));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.exceptionHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.setChunked(false));
            TestUtils.assertIllegalStateException(() -> resp.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateException(() -> resp.write(buff));
            TestUtils.assertIllegalStateException(() -> resp.write("foo"));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.write(buff));
            TestUtils.assertIllegalStateException(() -> resp.writeQueueFull());
            TestUtils.assertIllegalStateException(() -> resp.sendFile("asokdasokd"));
            this.testComplete();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testResponseBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.response().end(body));
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseBodyStringDefaultEncodingAtEnd() {
        this.testResponseBodyStringAtEnd(null);
    }

    @Test
    public void testResponseBodyStringUTF8AtEnd() {
        this.testResponseBodyStringAtEnd("UTF-8");
    }

    @Test
    public void testResponseBodyStringUTF16AtEnd() {
        this.testResponseBodyStringAtEnd("UTF-16");
    }

    private void testResponseBodyStringAtEnd(String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> {
            if (encoding == null) {
                req.response().end(body);
            } else {
                req.response().end(body, encoding);
            }
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseBodyWriteStringNonChunked() {
        this.server.requestHandler(req -> {
            TestUtils.assertIllegalStateException(() -> req.response().write("foo"));
            this.testComplete();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testResponseBodyWriteChunked() {
        this.testResponseBodyWrite(true);
    }

    @Test
    public void testResponseBodyWriteNonChunked() {
        this.testResponseBodyWrite(false);
    }

    private void testResponseBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        int numWrites = 10;
        int chunkSize = 100;
        this.server.requestHandler(req -> {
            this.assertFalse(req.response().headWritten());
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            this.assertFalse(req.response().headWritten());
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.response().write(b);
                this.assertTrue(req.response().headWritten());
            }
            req.response().end();
            this.assertTrue(req.response().headWritten());
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseBodyWriteStringChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(true, null);
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF8() {
        this.testResponseBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF16() {
        this.testResponseBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(false, null);
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF8() {
        this.testResponseBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF16() {
        this.testResponseBodyWriteString(false, "UTF-16");
    }

    private void testResponseBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> {
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.response().write(body);
            } else {
                req.response().write(body, encoding);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseWrite() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write(body);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testPipeliningOrder() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(true).setPipelining(true).setMaxPoolSize(1));
        int requests = 100;
        AtomicInteger reqCount = new AtomicInteger(0);
        this.server.requestHandler(req -> {
            int theCount = reqCount.get();
            this.assertEquals(theCount, Integer.parseInt(req.headers().get("count")));
            reqCount.incrementAndGet();
            req.response().setChunked(true);
            req.bodyHandler(buff -> {
                this.assertEquals("This is content " + theCount, buff.toString());
                this.vertx.setTimer(1L + (long)(10.0 * Math.random()), id -> {
                    req.response().headers().set("count", String.valueOf(theCount));
                    req.response().write(buff);
                    req.response().end();
                });
            });
        });
        CountDownLatch latch = new CountDownLatch(requests);
        this.server.listen(this.onSuccess(s -> this.vertx.setTimer(500L, id -> {
            for (int count = 0; count < requests; ++count) {
                int theCount = count;
                HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> {
                    this.assertEquals(theCount, Integer.parseInt(resp.headers().get("count")));
                    resp.bodyHandler(buff -> {
                        this.assertEquals("This is content " + theCount, buff.toString());
                        latch.countDown();
                    });
                });
                req.setChunked(true);
                req.headers().set("count", String.valueOf(count));
                req.write("This is content " + count);
                req.end();
            }
        })));
        this.awaitLatch(latch);
    }

    @Test
    public void testKeepAlive() throws Exception {
        this.testKeepAlive(true, 5, 10, 5);
    }

    @Test
    public void testNoKeepAlive() throws Exception {
        this.testKeepAlive(false, 5, 10, 10);
    }

    private void testKeepAlive(boolean keepAlive, int poolSize, int numServers, int expectedConnectedServers) throws Exception {
        this.client.close();
        CountDownLatch firstCloseLatch = new CountDownLatch(1);
        this.server.close(this.onSuccess(v -> firstCloseLatch.countDown()));
        this.awaitLatch(firstCloseLatch);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(keepAlive).setPipelining(false).setMaxPoolSize(poolSize));
        int requests = 100;
        HttpServer[] servers = new HttpServer[numServers];
        CountDownLatch startServerLatch = new CountDownLatch(numServers);
        ConcurrentHashSet connectedServers = new ConcurrentHashSet();
        for (int i = 0; i < numServers; ++i) {
            HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(8080));
            server.requestHandler(arg_0 -> HttpTest.lambda$testKeepAlive$1567((Set)connectedServers, server, arg_0));
            server.listen(ar -> {
                this.assertTrue(ar.succeeded());
                startServerLatch.countDown();
            });
            servers[i] = server;
        }
        this.awaitLatch(startServerLatch);
        CountDownLatch reqLatch = new CountDownLatch(requests);
        this.vertx.runOnContext(v -> {
            for (int count = 0; count < requests; ++count) {
                this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    reqLatch.countDown();
                }).end();
            }
        });
        this.awaitLatch(reqLatch);
        this.assertEquals(expectedConnectedServers, connectedServers.size());
        CountDownLatch serverCloseLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                serverCloseLatch.countDown();
            });
        }
        this.awaitLatch(serverCloseLatch);
    }

    @Test
    public void testSendFile() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, false);
    }

    @Test
    public void testSendFileWithHandler() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, true);
    }

    private void sendFile(String fileName, String contentExpected, boolean handler) throws Exception {
        File fileToSend = this.setupFile(fileName, contentExpected);
        CountDownLatch latch = handler ? new CountDownLatch(2) : new CountDownLatch(1);
        this.server.requestHandler(req -> {
            if (handler) {
                Handler<AsyncResult<Void>> completionHandler = this.onSuccess(v -> latch.countDown());
                req.response().sendFile(fileToSend.getAbsolutePath(), completionHandler);
            } else {
                req.response().sendFile(fileToSend.getAbsolutePath());
            }
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("text/html", resp.headers().get("Content-Type"));
            resp.bodyHandler(buff -> {
                this.assertEquals(contentExpected, buff.toString());
                this.assertEquals(fileToSend.length(), Long.parseLong(resp.headers().get("content-length")));
                latch.countDown();
            });
        }).end()));
        this.assertTrue("Timed out waiting for test to complete.", latch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSendFileOverrideHeaders() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile("test-send-file.html", content);
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(file.getAbsolutePath());
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(file.length(), Long.parseLong(resp.headers().get("content-length")));
            this.assertEquals("wibble", resp.headers().get("content-type"));
            resp.bodyHandler(buff -> {
                this.assertEquals(content, buff.toString());
                file.delete();
                this.testComplete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testSendFileNotFound() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html");
        });
        this.server.listen(this.onSuccess(s -> {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end();
            this.vertx.setTimer(100L, tid -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testSendFileNotFoundWithHandler() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html", this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end()));
        this.await();
    }

    @Test
    public void testSendFileDirectoryWithHandler() throws Exception {
        File dir = this.testFolder.newFolder();
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(dir.getAbsolutePath(), this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end()));
        this.await();
    }

    @Test
    public void test100ContinueDefault() throws Exception {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(data -> {
            this.assertEquals(toSend, data);
            req.response().end();
        }));
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete()));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write(toSend);
                req.end();
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void test100ContinueHandled() throws Exception {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            req.response().headers().set("HTTP/1.1", "100 Continue");
            req.bodyHandler(data -> {
                this.assertEquals(toSend, data);
                req.response().end();
            });
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete()));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write(toSend);
                req.end();
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testClientDrainHandler() {
        this.pausingServer(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            this.assertFalse(req.writeQueueFull());
            req.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.write(buff);
                if (req.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.drainHandler(v -> {
                        this.assertFalse(req.writeQueueFull());
                        this.testComplete();
                    });
                    this.vertx.eventBus().send("server_resume", (Object)"");
                }
            });
        });
        this.await();
    }

    @Test
    public void testServerDrainHandler() {
        this.drainingServer(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            resp.pause();
            Handler resumeHandler = msg -> resp.resume();
            MessageConsumer reg = this.vertx.eventBus().consumer("client_resume").handler(resumeHandler);
            resp.endHandler(v -> reg.unregister());
        }).end());
        this.await();
    }

    @Test
    public void testPoolingKeepAliveAndPipelining() {
        this.testPooling(true, true);
    }

    @Test
    public void testPoolingKeepAliveNoPipelining() {
        this.testPooling(true, false);
    }

    @Test
    public void testPoolingNoKeepAliveNoPipelining() {
        this.testPooling(false, false);
    }

    @Test
    public void testPoolingNoKeepAliveAndPipelining() {
        this.testPooling(false, true);
    }

    private void testPooling(boolean keepAlive, boolean pipelining) {
        String path = "foo.txt";
        int numGets = 100;
        int maxPoolSize = 10;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(keepAlive).setPipelining(pipelining).setMaxPoolSize(maxPoolSize));
        this.server.requestHandler(req -> {
            String cnt = req.headers().get("count");
            req.response().headers().set("count", cnt);
            req.response().end();
        });
        AtomicBoolean completeAlready = new AtomicBoolean();
        this.server.listen(this.onSuccess(s -> {
            AtomicInteger cnt = new AtomicInteger(0);
            for (int i = 0; i < numGets; ++i) {
                int theCount = i;
                HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", path, resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    this.assertEquals(theCount, Integer.parseInt(resp.headers().get("count")));
                    if (cnt.incrementAndGet() == numGets) {
                        this.testComplete();
                    }
                });
                req.exceptionHandler(t -> {
                    if (pipelining && !keepAlive) {
                        this.assertTrue(t instanceof IllegalStateException);
                        if (completeAlready.compareAndSet(false, true)) {
                            this.testComplete();
                        }
                    } else {
                        this.fail("Should not throw exception: " + t.getMessage());
                    }
                });
                req.headers().set("count", String.valueOf(i));
                req.end();
            }
        }));
        this.await();
    }

    @Test
    public void testConnectionErrorsGetReportedToRequest() throws InterruptedException {
        AtomicInteger req1Exceptions = new AtomicInteger();
        AtomicInteger req2Exceptions = new AtomicInteger();
        AtomicInteger req3Exceptions = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(3);
        HttpClientRequest req1 = this.client.request(HttpMethod.GET, 9998, "localhost", "someurl1", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req1.exceptionHandler(t -> {
            this.assertEquals("More than one call to req1 exception handler was not expected", 1L, req1Exceptions.incrementAndGet());
            latch.countDown();
        });
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, 9998, "localhost", "someurl2", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req2.exceptionHandler(t -> {
            this.assertEquals("More than one call to req2 exception handler was not expected", 1L, req2Exceptions.incrementAndGet());
            latch.countDown();
        });
        HttpClientRequest req3 = this.client.request(HttpMethod.GET, 9998, "localhost", "someurl2", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req3.exceptionHandler(t -> {
            this.assertEquals("More than one call to req2 exception handler was not expected", 1L, req3Exceptions.incrementAndGet());
            latch.countDown();
        });
        req1.end();
        req2.end();
        req3.end();
        this.awaitLatch(latch);
        this.testComplete();
    }

    @Test
    public void testRequestTimesoutWhenIndicatedPeriodExpiresWithoutAResponseFromRemoteServer() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("End should not be called because the request should timeout"));
            req.exceptionHandler(t -> {
                this.assertTrue("Expected to end with timeout exception but ended with other exception: " + t, t instanceof TimeoutException);
                this.testComplete();
            });
            req.setTimeout(1000L);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestTimeoutExtendedWhenResponseChunksReceived() {
        long timeout = 2000L;
        int numChunks = 100;
        AtomicInteger count = new AtomicInteger(0);
        long interval = timeout * 2L / (long)numChunks;
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            this.vertx.setPeriodic(interval, timerID -> {
                req.response().write("foo");
                if (count.incrementAndGet() == numChunks) {
                    req.response().end();
                    this.vertx.cancelTimer(timerID.longValue());
                }
            });
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.endHandler(v -> this.testComplete());
            });
            req.exceptionHandler(t -> this.fail("Should not be called"));
            req.setTimeout(timeout);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestTimeoutCanceledWhenRequestHasAnOtherError() {
        AtomicReference exception = new AtomicReference();
        HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("End should not be called because the request should fail to connect"));
        req.exceptionHandler(exception::set);
        req.setTimeout(800L);
        req.end();
        this.vertx.setTimer(1500L, id -> {
            this.assertNotNull("Expected an exception to be set", exception.get());
            this.assertFalse("Expected to not end with timeout exception, but did: " + exception.get(), exception.get() instanceof TimeoutException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testRequestTimeoutCanceledWhenRequestEndsNormally() {
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> {
            AtomicReference exception = new AtomicReference();
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", this.noOpHandler());
            req.exceptionHandler(exception::set);
            req.setTimeout(500L);
            req.end();
            this.vertx.setTimer(1000L, id -> {
                this.assertNull("Did not expect any exception", exception.get());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testRequestNotReceivedIfTimedout() {
        this.server.requestHandler(req -> this.vertx.setTimer(500L, id -> {
            req.response().setStatusCode(200);
            req.response().end("OK");
        }));
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Response should not be handled"));
            req.exceptionHandler(t -> {
                this.assertTrue("Expected to end with timeout exception but ended with other exception: " + t, t instanceof TimeoutException);
                this.vertx.setTimer(500L, id -> this.testComplete());
            });
            req.setTimeout(100L);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testServerWebsocketIdleTimeout() {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(1).setPort(8080).setHost("localhost"));
        this.server.websocketHandler(ws -> {}).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocket(8080, "localhost", "/", ws -> ws.closeHandler(v -> this.testComplete()));
        });
        this.await();
    }

    @Test
    public void testClientWebsocketIdleTimeout() {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setIdleTimeout(1));
        this.server.websocketHandler(ws -> {}).listen(ar -> this.client.websocket(8080, "localhost", "/", ws -> ws.closeHandler(v -> this.testComplete())));
        this.await();
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.NONE, KeyCert.JKS, Trust.NONE, false, false, true, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.PKCS12, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.PEM, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertJKS_CAWithJKS_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS_CA, KeyCert.JKS_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertJKS_CAWithPKCS12_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PKCS12_CA, KeyCert.JKS_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertJKS_CAWithPEM_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM_CA, KeyCert.JKS_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12_CAWithJKS_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS_CA, KeyCert.PKCS12_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12_CAWithPKCS12_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PKCS12_CA, KeyCert.PKCS12_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12_CAWithPEM_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM_CA, KeyCert.PKCS12_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM_CAWithJKS_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS_CA, KeyCert.PEM_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM_CAWithPKCS12_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PKCS12_CA, KeyCert.PEM_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM_CAWithPEM_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM_CA, KeyCert.PEM_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPKCS12ServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PKCS12, KeyCert.JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPEMServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM, KeyCert.JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.NONE, KeyCert.JKS, Trust.NONE, false, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientUntrustedServerPEM() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.NONE, KeyCert.PEM, Trust.NONE, false, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.JKS, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertNotRequiredPEM() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.PEM, Trust.JKS, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPKCS12() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.PKCS12, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPEM() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.PEM, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPKCS12Required() throws Exception {
        this.testTLS(KeyCert.PKCS12, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEMRequired() throws Exception {
        this.testTLS(KeyCert.PEM, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEM_CARequired() throws Exception {
        this.testTLS(KeyCert.PEM_CA, Trust.JKS, KeyCert.JKS, Trust.PEM_CA, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.NONE, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientRevokedServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM_CA, KeyCert.PEM_CA, Trust.NONE, false, false, false, true, false, new String[0]);
    }

    @Test
    public void testTLSRevokedClientCertServer() throws Exception {
        this.testTLS(KeyCert.PEM_CA, Trust.JKS, KeyCert.JKS, Trust.PEM_CA, true, true, false, false, false, new String[0]);
    }

    @Test
    public void testTLSCipherSuites() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.NONE, KeyCert.JKS, Trust.NONE, false, false, true, false, true, ENABLED_CIPHER_SUITES);
    }

    private void testTLS(KeyCert clientCert, Trust clientTrust, KeyCert serverCert, Trust serverTrust, boolean requireClientAuth, boolean serverUsesCrl, boolean clientTrustAll, boolean clientUsesCrl, boolean shouldPass, String ... enabledCipherSuites) throws Exception {
        this.client.close();
        this.server.close();
        HttpClientOptions options = new HttpClientOptions();
        options.setSsl(true);
        if (clientTrustAll) {
            options.setTrustAll(true);
        }
        if (clientUsesCrl) {
            options.addCrlPath(this.findFileOnClasspath("tls/ca/crl.pem"));
        }
        this.setOptions((TCPSSLOptions)options, this.getClientTrustOptions(clientTrust));
        this.setOptions((TCPSSLOptions)options, this.getClientCertOptions(clientCert));
        for (String suite : enabledCipherSuites) {
            options.addEnabledCipherSuite(suite);
        }
        this.client = this.vertx.createHttpClient(options);
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setSsl(true);
        this.setOptions((TCPSSLOptions)serverOptions, this.getServerTrustOptions(serverTrust));
        this.setOptions((TCPSSLOptions)serverOptions, this.getServerCertOptions(serverCert));
        if (requireClientAuth) {
            serverOptions.setClientAuthRequired(true);
        }
        if (serverUsesCrl) {
            serverOptions.addCrlPath(this.findFileOnClasspath("tls/ca/crl.pem"));
        }
        for (String suite : enabledCipherSuites) {
            serverOptions.addEnabledCipherSuite(suite);
        }
        this.server = this.vertx.createHttpServer(serverOptions.setPort(4043));
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals("foo", buffer.toString());
            req.response().end("bar");
        }));
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientRequest req = this.client.request(HttpMethod.GET, 4043, "localhost", "some-uri", response -> {
                response.bodyHandler(data -> this.assertEquals("bar", data.toString()));
                this.testComplete();
            });
            req.exceptionHandler(t -> {
                if (shouldPass) {
                    this.fail("Should not throw exception");
                } else {
                    this.testComplete();
                }
            });
            req.end("foo");
        });
        this.await();
    }

    @Test
    public void testJKSInvalidPath() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)this.getServerCertOptions(KeyCert.JKS)).setPath("/invalid.jks"), "java.nio.file.NoSuchFileException: ", "invalid.jks");
    }

    @Test
    public void testJKSMissingPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)this.getServerCertOptions(KeyCert.JKS)).setPassword(null), "Password must not be null", null);
    }

    @Test
    public void testJKSInvalidPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)this.getServerCertOptions(KeyCert.JKS)).setPassword("wrongpassword"), "Keystore was tampered with, or password was incorrect", null);
    }

    @Test
    public void testPKCS12InvalidPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)this.getServerCertOptions(KeyCert.PKCS12)).setPath("/invalid.p12"), "java.nio.file.NoSuchFileException: ", "invalid.p12");
    }

    @Test
    public void testPKCS12MissingPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)this.getServerCertOptions(KeyCert.PKCS12)).setPassword(null), "Get Key failed: null", null);
    }

    @Test
    public void testPKCS12InvalidPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)this.getServerCertOptions(KeyCert.PKCS12)).setPassword("wrongpassword"), "failed to decrypt safe contents entry: javax.crypto.BadPaddingException: Given final block not properly padded", null);
    }

    @Test
    public void testKeyCertMissingKeyPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)this.getServerCertOptions(KeyCert.PEM)).setKeyPath(null), "Missing private key", null);
    }

    @Test
    public void testKeyCertInvalidKeyPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)this.getServerCertOptions(KeyCert.PEM)).setKeyPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testKeyCertMissingCertPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)this.getServerCertOptions(KeyCert.PEM)).setCertPath(null), "Missing X.509 certificate", null);
    }

    @Test
    public void testKeyCertInvalidCertPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)this.getServerCertOptions(KeyCert.PEM)).setCertPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testKeyCertInvalidPem() throws IOException {
        String[] contents = new String[]{"", "-----BEGIN PRIVATE KEY-----", "-----BEGIN PRIVATE KEY-----\n-----END PRIVATE KEY-----", "-----BEGIN PRIVATE KEY-----\n*\n-----END PRIVATE KEY-----"};
        String[] messages = new String[]{"Missing -----BEGIN PRIVATE KEY----- delimiter", "Missing -----END PRIVATE KEY----- delimiter", "Empty pem file", "Input byte[] should at least have 2 bytes for base64 bytes"};
        for (int i = 0; i < contents.length; ++i) {
            Path file = this.testFolder.newFile("vertx" + UUID.randomUUID().toString() + ".pem").toPath();
            Files.write(file, Collections.singleton(contents[i]), new OpenOption[0]);
            String expectedMessage = messages[i];
            this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)this.getServerCertOptions(KeyCert.PEM)).setKeyPath(file.toString()), expectedMessage, null);
        }
    }

    @Test
    public void testCaInvalidPath() {
        this.testInvalidTrustStore((TrustOptions)new PemTrustOptions().addCertPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testCaInvalidPem() throws IOException {
        String[] contents = new String[]{"", "-----BEGIN CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\n-----END CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\n*\n-----END CERTIFICATE-----"};
        String[] messages = new String[]{"Missing -----BEGIN CERTIFICATE----- delimiter", "Missing -----END CERTIFICATE----- delimiter", "Empty pem file", "Input byte[] should at least have 2 bytes for base64 bytes"};
        for (int i = 0; i < contents.length; ++i) {
            Path file = this.testFolder.newFile("vertx" + UUID.randomUUID().toString() + ".pem").toPath();
            Files.write(file, Collections.singleton(contents[i]), new OpenOption[0]);
            String expectedMessage = messages[i];
            this.testInvalidTrustStore((TrustOptions)new PemTrustOptions().addCertPath(file.toString()), expectedMessage, null);
        }
    }

    private void testInvalidKeyStore(KeyCertOptions options, String expectedPrefix, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        this.setOptions((TCPSSLOptions)serverOptions, options);
        serverOptions.setSsl(true);
        serverOptions.setPort(4043);
        this.testStore(serverOptions, expectedPrefix, expectedSuffix);
    }

    private void testInvalidTrustStore(TrustOptions options, String expectedPrefix, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        this.setOptions((TCPSSLOptions)serverOptions, options);
        serverOptions.setSsl(true);
        serverOptions.setPort(4043);
        this.testStore(serverOptions, expectedPrefix, expectedSuffix);
    }

    private void testStore(HttpServerOptions serverOptions, String expectedPrefix, String expectedSuffix) {
        HttpServer server = this.vertx.createHttpServer(serverOptions);
        server.requestHandler(req -> {});
        try {
            server.listen();
            this.fail("Was expecting a failure");
        }
        catch (VertxException e) {
            this.assertNotNull(e.getCause());
            if (expectedSuffix == null) {
                this.assertEquals(expectedPrefix, e.getCause().getMessage());
            }
            this.assertTrue(e.getCause().getMessage().startsWith(expectedPrefix));
            this.assertTrue(e.getCause().getMessage().endsWith(expectedSuffix));
        }
    }

    @Test
    public void testCrlInvalidPath() throws Exception {
        HttpClientOptions clientOptions = new HttpClientOptions();
        this.setOptions((TCPSSLOptions)clientOptions, this.getClientTrustOptions(Trust.PEM_CA));
        clientOptions.setSsl(true);
        clientOptions.addCrlPath("/invalid.pem");
        HttpClient client = this.vertx.createHttpClient(clientOptions);
        HttpClientRequest req = client.request(HttpMethod.CONNECT, 8080, "localhost", "/", handler -> {});
        try {
            req.end();
            this.fail("Was expecting a failure");
        }
        catch (VertxException e) {
            this.assertNotNull(e.getCause());
            this.assertEquals(NoSuchFileException.class, e.getCause().getCause().getClass());
        }
    }

    @Test
    public void testConnectInvalidPort() {
        this.client.request(HttpMethod.GET, 9998, "localhost", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(t -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testConnectInvalidHost() {
        this.client.request(HttpMethod.GET, 9998, "255.255.255.255", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(t -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(s -> {
            TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> this.server.websocketHandler(this.noOpHandler()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening2() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen();
        TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
        TestUtils.assertIllegalStateException(() -> this.server.websocketHandler(this.noOpHandler()));
    }

    @Test
    public void testListenNoHandlers() throws Exception {
        TestUtils.assertIllegalStateException(() -> this.server.listen(ar -> {}));
    }

    @Test
    public void testListenNoHandlers2() throws Exception {
        TestUtils.assertIllegalStateException(() -> this.server.listen());
    }

    @Test
    public void testListenTwice() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen();
        TestUtils.assertIllegalStateException(() -> this.server.listen());
    }

    @Test
    public void testListenTwice2() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            TestUtils.assertIllegalStateException(() -> this.server.listen());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        this.client.close();
        this.server.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false));
        int numServers = 5;
        int numRequests = numServers * 100;
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        Set connectedServers = Collections.newSetFromMap(new ConcurrentHashMap());
        ConcurrentHashMap requestCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numRequests);
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        for (int i = 0; i < numServers; ++i) {
            HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
            servers.add(theServer);
            AtomicReference context = new AtomicReference();
            theServer.requestHandler(arg_0 -> this.lambda$testSharedServersRoundRobin$1673(context, (Set)contexts, connectedServers, theServer, requestCount, latchConns, arg_0)).listen(this.onSuccess(s -> latchListen.countDown()));
        }
        this.assertTrue(latchListen.await(10L, TimeUnit.SECONDS));
        CountDownLatch latchClient = new CountDownLatch(numRequests);
        for (int i = 0; i < numRequests; ++i) {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", res -> latchClient.countDown()).end();
        }
        this.assertTrue(latchClient.await(10L, TimeUnit.SECONDS));
        this.assertTrue(latchConns.await(10L, TimeUnit.SECONDS));
        this.assertEquals(numServers, connectedServers.size());
        for (HttpServer server : servers) {
            this.assertTrue(connectedServers.contains(server));
        }
        this.assertEquals(numServers, requestCount.size());
        Iterator<Object> i = requestCount.values().iterator();
        while (i.hasNext()) {
            int cnt = (Integer)i.next();
            this.assertEquals(numRequests / numServers, cnt);
        }
        this.assertEquals(numServers, contexts.size());
        CountDownLatch closeLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                closeLatch.countDown();
            });
        }
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8081));
        theServer.requestHandler(req -> this.fail("Should not process request")).listen(this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        theServer.requestHandler(req -> this.fail("Should not process request")).listen(this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        theServer.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testHeadNoBody() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().headers().set("Content-Length", String.valueOf(41));
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.HEAD, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(41L, Integer.parseInt(resp.headers().get("Content-Length")));
            resp.endHandler(v -> this.testComplete());
        }).end()));
        this.await();
    }

    @Test
    public void testRemoteAddress() {
        this.server.requestHandler(req -> {
            this.assertEquals("127.0.0.1", req.remoteAddress().host());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testGetAbsoluteURI() {
        this.server.requestHandler(req -> {
            this.assertEquals("http://localhost:8080/foo/bar", req.absoluteURI().toString());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "/foo/bar", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testListenInvalidPort() throws Exception {
        Assume.assumeFalse((boolean)System.getProperty("os.name").startsWith("Windows"));
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(7));
        this.server.requestHandler(this.noOpHandler()).listen(this.onFailure(server -> this.testComplete()));
        this.await();
    }

    @Test
    public void testListenInvalidHost() {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("iqwjdoqiwjdoiqwdiojwd"));
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onFailure(s -> this.testComplete()));
    }

    @Test
    public void testPauseClientResponse() {
        int numWrites = 10;
        int numBytes = 100;
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            for (int i = 0; i < numWrites; ++i) {
                req.response().write(TestUtils.randomBuffer(numBytes));
            }
            req.response().end();
        });
        AtomicBoolean paused = new AtomicBoolean();
        Buffer totBuff = Buffer.buffer();
        HttpClientRequest clientRequest = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            resp.pause();
            paused.set(true);
            resp.handler(chunk -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    totBuff.appendBuffer(chunk);
                }
            });
            resp.endHandler(v -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    this.assertEquals(numWrites * numBytes, totBuff.length());
                    this.testComplete();
                }
            });
            this.vertx.setTimer(500L, id -> {
                paused.set(false);
                resp.resume();
            });
        });
        this.server.listen(this.onSuccess(s -> clientRequest.end()));
        this.await();
    }

    @Test
    public void testHttpVersion() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testFormUploadSmallFile() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), false);
    }

    @Test
    public void testFormUploadLargerFile() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(20000), false);
    }

    @Test
    public void testFormUploadSmallFileStreamToDisk() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true);
    }

    @Test
    public void testFormUploadLargerFileStreamToDisk() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(20000), true);
    }

    private void testFormUploadFile(String contentStr, boolean streamToDisk) throws Exception {
        Buffer content = Buffer.buffer((String)contentStr);
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.uploadHandler(upload -> {
                    String uploadedFileName;
                    Buffer tot = Buffer.buffer();
                    this.assertEquals("file", upload.name());
                    this.assertEquals("tmp-0.txt", upload.filename());
                    this.assertEquals("image/gif", upload.contentType());
                    if (!streamToDisk) {
                        upload.handler(buffer2 -> tot.appendBuffer(buffer2));
                        uploadedFileName = null;
                    } else {
                        uploadedFileName = new File(this.testDir, UUID.randomUUID().toString()).getPath();
                        upload.streamToFileSystem(uploadedFileName);
                    }
                    upload.endHandler(v -> {
                        if (streamToDisk) {
                            Buffer uploaded = this.vertx.fileSystem().readFileBlocking(uploadedFileName);
                            this.assertEquals(content, uploaded);
                        } else {
                            this.assertEquals(content, tot);
                        }
                        this.assertTrue(upload.isSizeAvailable());
                        this.assertEquals(content.length(), upload.size());
                    });
                });
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    req.response().end();
                });
            }
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(0L, attributeCount.get());
                this.testComplete();
            });
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String body = "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\n" + "Content-Type: image/gif\r\n" + "\r\n" + contentStr + "\r\n" + "--" + boundary + "--\r\n";
            buffer.appendString(body);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer).end();
        }));
        this.await();
    }

    @Test
    public void testFormUploadAttributes() throws Exception {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                req.uploadHandler(upload -> upload.handler(buffer -> this.fail("Should get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("vert x", attrs.get("framework"));
                    this.assertEquals("vert x", req.getFormAttribute("framework"));
                    this.assertEquals("jvm", attrs.get("runson"));
                    this.assertEquals("jvm", req.getFormAttribute("runson"));
                    req.response().end();
                });
            }
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(2L, attributeCount.get());
                this.testComplete();
            });
            try {
                Buffer buffer = Buffer.buffer();
                buffer.appendString("framework=" + URLEncoder.encode("vert x", "UTF-8") + "&runson=jvm", "UTF-8");
                req.headers().set("content-length", String.valueOf(buffer.length()));
                req.headers().set("content-type", "application/x-www-form-urlencoded");
                req.write(buffer).end();
            }
            catch (UnsupportedEncodingException e) {
                this.fail(e.getMessage());
            }
        }));
        this.await();
    }

    @Test
    public void testFormUploadAttributes2() throws Exception {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.setExpectMultipart(true);
                req.uploadHandler(event -> event.handler(buffer -> this.fail("Should not get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("junit-testUserAlias", attrs.get("origin"));
                    this.assertEquals("admin@foo.bar", attrs.get("login"));
                    this.assertEquals("admin", attrs.get("pass word"));
                    req.response().end();
                });
            }
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(3L, attributeCount.get());
                this.testComplete();
            });
            Buffer buffer = Buffer.buffer();
            buffer.appendString("origin=junit-testUserAlias&login=admin%40foo.bar&pass+word=admin");
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "application/x-www-form-urlencoded");
            req.write(buffer).end();
        }));
        this.await();
    }

    @Test
    public void testAccessNetSocket() throws Exception {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            req.response().headers().set("HTTP/1.1", "101 Upgrade");
            req.bodyHandler(data -> {
                this.assertEquals(toSend, data);
                req.response().end();
            });
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
                this.assertNotNull(resp.netSocket());
                this.testComplete();
            }));
            req.headers().set("content-length", String.valueOf(toSend.length()));
            req.write(toSend);
        }));
        this.await();
    }

    @Test
    public void testHostHeaderOverridePossible() {
        this.server.requestHandler(req -> {
            this.assertEquals("localhost:4444", req.headers().get("Host"));
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete());
            req.putHeader("Host", "localhost:4444");
            req.end();
        }));
        this.await();
    }

    @Test
    public void testResponseBodyWriteFixedString() {
        String body = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        Buffer bodyBuff = Buffer.buffer((String)body);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write(body);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testHttpConnect() {
        Buffer buffer = TestUtils.randomBuffer(128);
        Buffer received = Buffer.buffer();
        this.vertx.createNetServer(new NetServerOptions().setPort(1235)).connectHandler(socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0))).listen(this.onSuccess(netServer -> {
            this.server.requestHandler(req -> this.vertx.createNetClient(new NetClientOptions()).connect(netServer.actualPort(), "localhost", this.onSuccess(socket -> {
                req.response().setStatusCode(200);
                req.response().setStatusMessage("Connection established");
                req.response().end();
                Pump.pump((ReadStream)req.netSocket(), (WriteStream)socket).start();
                Pump.pump((ReadStream)socket, (WriteStream)req.netSocket()).start();
                req.netSocket().closeHandler(v -> socket.close());
            })));
            this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.CONNECT, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(200L, resp.statusCode());
                NetSocket socket = resp.netSocket();
                socket.handler(buff -> {
                    received.appendBuffer(buff);
                    if (received.length() == buffer.length()) {
                        netServer.close();
                        this.assertEquals(buffer, received);
                        this.testComplete();
                    }
                });
                socket.write(buffer);
            }).end()));
        }));
        this.await();
    }

    @Test
    public void testRequestsTimeoutInQueue() {
        this.server.requestHandler(req -> this.vertx.setTimer(1000L, id -> req.response().end()));
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setKeepAlive(false).setMaxPoolSize(1));
        this.server.listen(this.onSuccess(s -> {
            for (int i = 0; i < 5; ++i) {
                HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not be called"));
                req.exceptionHandler(t -> this.assertTrue(t instanceof TimeoutException));
                req.setTimeout(500L);
                req.end();
            }
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
            req.exceptionHandler(t -> this.fail("Should not throw exception"));
            req.setTimeout(3000L);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testServerOptionsCopiedBeforeUse() {
        this.server.close();
        HttpServerOptions options = new HttpServerOptions().setHost("localhost").setPort(8080);
        HttpServer server = this.vertx.createHttpServer(options);
        options.setPort(8081);
        server.requestHandler(req -> req.response().end());
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.request(HttpMethod.GET, 8080, "localhost", "/uri", res -> {
                this.assertEquals(200L, res.statusCode());
                this.testComplete();
            }).end();
        });
        this.await();
    }

    @Test
    public void testClientOptionsCopiedBeforeUse() {
        this.client.close();
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientOptions options = new HttpClientOptions();
            this.client = this.vertx.createHttpClient(options);
            options.setSsl(true);
            this.client.request(HttpMethod.GET, 8080, "localhost", "/uri", res -> {
                this.assertEquals(200L, res.statusCode());
                this.testComplete();
            }).end();
        });
        this.await();
    }

    @Test
    public void testClientMultiThreaded() throws Exception {
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(numThreads);
        this.server.requestHandler(req -> {
            req.response().putHeader("count", req.headers().get("count"));
            req.response().end();
        }).listen(ar -> {
            this.assertTrue(ar.succeeded());
            for (int i = 0; i < numThreads; ++i) {
                final int index = i;
                threadArray[i] = new Thread(){

                    @Override
                    public void run() {
                        HttpTest.this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
                            HttpTest.this.assertEquals(200L, res.statusCode());
                            HttpTest.this.assertEquals(String.valueOf(index), res.headers().get("count"));
                            latch.countDown();
                        }).putHeader("count", String.valueOf(index)).end();
                    }
                };
                threads[i].start();
            }
        });
        this.awaitLatch(latch);
        for (int i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testInVerticle() throws Exception {
        this.testInVerticle(false);
    }

    private void testInVerticle(final boolean worker) throws Exception {
        this.client.close();
        this.server.close();
        class MyVerticle
        extends AbstractVerticle {
            Context ctx;

            MyVerticle() {
            }

            public void start() {
                this.ctx = Vertx.currentContext();
                if (worker) {
                    HttpTest.this.assertTrue(this.ctx instanceof WorkerContext);
                } else {
                    HttpTest.this.assertTrue(this.ctx instanceof EventLoopContext);
                }
                Thread thr = Thread.currentThread();
                HttpTest.this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
                HttpTest.this.server.requestHandler(req -> {
                    req.response().end();
                    HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                });
                HttpTest.this.server.listen(ar -> {
                    HttpTest.this.assertTrue(ar.succeeded());
                    HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                    HttpTest.this.client = this.vertx.createHttpClient(new HttpClientOptions());
                    HttpTest.this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
                        HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                        if (!worker) {
                            HttpTest.this.assertSame(thr, Thread.currentThread());
                        }
                        HttpTest.this.assertEquals(200L, res.statusCode());
                        HttpTest.this.testComplete();
                    }).end();
                });
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(worker));
        this.await();
    }

    @Test
    public void testUseInMultithreadedWorker() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            MyVerticle() {
            }

            public void start() {
                TestUtils.assertIllegalStateException(() -> {
                    HttpTest.this.server = this.vertx.createHttpServer(new HttpServerOptions());
                });
                TestUtils.assertIllegalStateException(() -> {
                    HttpTest.this.client = this.vertx.createHttpClient(new HttpClientOptions());
                });
                HttpTest.this.testComplete();
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testContexts() throws Exception {
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        AtomicInteger cnt = new AtomicInteger();
        AtomicReference serverRequestContext = new AtomicReference();
        this.server.requestHandler(req -> {
            ContextImpl serverContext = ((VertxInternal)this.vertx).getContext();
            if (serverRequestContext.get() != null) {
                this.assertSame(serverRequestContext.get(), serverContext);
            } else {
                serverRequestContext.set(serverContext);
            }
            req.response().end();
        });
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference listenContext = new AtomicReference();
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            listenContext.set(((VertxInternal)this.vertx).getContext());
            latch.countDown();
        });
        this.awaitLatch(latch);
        CountDownLatch latch2 = new CountDownLatch(1);
        int numReqs = 16;
        int numConns = 8;
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setMaxPoolSize(numConns));
        for (int i = 0; i < numReqs; ++i) {
            this.client.request(HttpMethod.GET, 8080, "localhost", "/", arg_0 -> this.lambda$testContexts$1771((Set)contexts, cnt, numReqs, numConns, latch2, arg_0)).end();
        }
        this.awaitLatch(latch2);
        this.server.close(arg_0 -> this.lambda$testContexts$1772((Set)contexts, serverRequestContext, listenContext, arg_0));
        this.server = null;
        this.await();
    }

    @Test
    public void testRequestHandlerNotCalledInvalidRequest() {
        this.server.requestHandler(req -> this.fail());
        this.server.listen(this.onSuccess(s -> this.vertx.createNetClient(new NetClientOptions()).connect(8080, "127.0.0.1", result -> {
            NetSocket socket = (NetSocket)result.result();
            socket.closeHandler(r -> this.testComplete());
            socket.write("GET HTTP1/1\r\n");
            socket.write("X-Header: test\r\n");
        })));
        this.await();
    }

    @Test
    public void testTwoServersSameAddressDifferentContext() throws Exception {
        this.vertx.deployVerticle(SimpleServer.class.getName(), new DeploymentOptions().setInstances(2), this.onSuccess(id -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.requestStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testClearHandlersOnEnd() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(req -> req.response().setStatusCode(200).end());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", path);
            AtomicInteger count = new AtomicInteger();
            req.handler(resp -> resp.endHandler(v -> {
                try {
                    resp.endHandler(null);
                    resp.exceptionHandler(null);
                    resp.handler(null);
                }
                catch (Exception e) {
                    this.fail("Was expecting to set to null the handlers when the response is completed");
                    return;
                }
                if (count.incrementAndGet() == 2) {
                    this.testComplete();
                }
            }));
            req.endHandler(done -> {
                try {
                    req.handler(null);
                    req.exceptionHandler(null);
                    req.endHandler(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.fail("Was expecting to set to null the handlers when the response is completed");
                    return;
                }
                if (count.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
            req.end();
        });
        this.await();
    }

    @Test
    public void testSetHandlersOnEnd() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(req -> req.response().setStatusCode(200).end());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", path);
            req.handler(resp -> {});
            req.endHandler(done -> {
                try {
                    req.handler(arg -> {});
                    this.fail();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    req.exceptionHandler(arg -> {});
                    this.fail();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    req.endHandler(arg -> {});
                    this.fail();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.testComplete();
            });
            req.end();
        });
        this.await();
    }

    @Test
    public void testRequestEnded() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.endHandler(v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                req.response().setStatusCode(200).end();
            });
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.getNow(8080, "localhost", "/blah", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testRequestEndedNoEndHandler() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.response().setStatusCode(200).end();
            this.vertx.setTimer(500L, v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.testComplete();
            });
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.getNow(8080, "localhost", "/blah", resp -> this.assertEquals(200L, resp.statusCode()));
        });
        this.await();
    }

    @Test
    public void testInWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                HttpTest.this.assertTrue(Context.isOnWorkerThread());
                HttpServer server1 = this.vertx.createHttpServer(new HttpServerOptions().setHost("localhost").setPort(8080));
                server1.requestHandler(req -> {
                    HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    HttpTest.this.assertTrue(Context.isOnWorkerThread());
                    Buffer buf = Buffer.buffer();
                    req.handler(arg_0 -> ((Buffer)buf).appendBuffer(arg_0));
                    req.endHandler(v -> {
                        HttpTest.this.assertEquals("hello", buf.toString());
                        req.response().end("bye");
                    });
                }).listen(HttpTest.this.onSuccess(s -> {
                    HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    HttpTest.this.assertTrue(Context.isOnWorkerThread());
                    HttpClient client = this.vertx.createHttpClient();
                    client.put(8080, "localhost", "/blah", resp -> {
                        HttpTest.this.assertEquals(200L, resp.statusCode());
                        HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        HttpTest.this.assertTrue(Context.isOnWorkerThread());
                        resp.handler(buf -> {
                            HttpTest.this.assertEquals("bye", buf.toString());
                            resp.endHandler(v -> HttpTest.this.testComplete());
                        });
                    }).setChunked(true).write(Buffer.buffer((String)"hello")).end();
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    @Test
    public void testInMultithreadedWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                HttpTest.this.assertTrue(Vertx.currentContext().isMultiThreadedWorkerContext());
                HttpTest.this.assertTrue(Context.isOnWorkerThread());
                try {
                    this.vertx.createHttpServer();
                    HttpTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    this.vertx.createHttpClient();
                    HttpTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                HttpTest.this.testComplete();
            }
        }, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testAbsoluteURIServer() {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("0.0.0.0"));
        this.server.requestHandler(req -> {
            String absURI = req.absoluteURI();
            this.assertEquals("http://localhost:8080/path", absURI);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> {
            String host = "localhost";
            String path = "/path";
            int port = 8080;
            this.client.getNow(port, host, path, resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
        }));
        this.await();
    }

    private void pausingServer(Consumer<HttpServer> consumer) {
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.pause();
            Handler resumeHandler = msg -> req.resume();
            MessageConsumer reg = this.vertx.eventBus().consumer("server_resume").handler(resumeHandler);
            req.endHandler(v -> reg.unregister());
            req.handler(buff -> req.response().write(buff));
        });
        this.server.listen(this.onSuccess(consumer));
    }

    private void drainingServer(Consumer<HttpServer> consumer) {
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            this.assertFalse(req.response().writeQueueFull());
            req.response().setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.response().write(buff);
                if (req.response().writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.response().drainHandler(v -> {
                        this.assertFalse(req.response().writeQueueFull());
                        this.testComplete();
                    });
                    this.vertx.eventBus().send("client_resume", (Object)"");
                }
            });
        });
        this.server.listen(this.onSuccess(consumer));
    }

    private static MultiMap getHeaders(int num) {
        Map<String, String> map = HttpTest.genMap(num);
        HeadersAdaptor headers = new HeadersAdaptor((HttpHeaders)new DefaultHttpHeaders());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        return headers;
    }

    private static Map<String, String> genMap(int num) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            String key;
            while (map.containsKey(key = TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())).toLowerCase())) {
            }
            map.put(key, TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())));
        }
        return map;
    }

    private static String generateQueryString(Map<String, String> params, char delim) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> param : params.entrySet()) {
            sb.append(param.getKey()).append("=").append(param.getValue());
            if (++count == params.size()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    private File setupFile(String fileName, String content) throws Exception {
        File file = new File(this.testDir, fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write(content);
        out.close();
        return file;
    }

    private /* synthetic */ void lambda$testContexts$1772(Set set, AtomicReference atomicReference, AtomicReference atomicReference2, AsyncResult ar) {
        this.assertTrue(ar.succeeded());
        ContextImpl closeContext = ((VertxInternal)this.vertx).getContext();
        this.assertFalse(set.contains(closeContext));
        this.assertNotSame(atomicReference.get(), closeContext);
        this.assertFalse(set.contains(atomicReference2.get()));
        this.assertSame(atomicReference.get(), atomicReference2.get());
        this.testComplete();
    }

    private /* synthetic */ void lambda$testContexts$1771(Set set, AtomicInteger atomicInteger, int n, int n2, CountDownLatch countDownLatch, HttpClientResponse resp) {
        this.assertEquals(200L, resp.statusCode());
        set.add(((VertxInternal)this.vertx).getContext());
        if (atomicInteger.incrementAndGet() == n) {
            this.assertTrue(set.size() >= n2);
            countDownLatch.countDown();
        }
    }

    private /* synthetic */ void lambda$testSharedServersRoundRobin$1673(AtomicReference atomicReference, Set set, Set set2, HttpServer httpServer, Map map, CountDownLatch countDownLatch, HttpServerRequest req) {
        Context ctx = Vertx.currentContext();
        if (atomicReference.get() != null) {
            this.assertSame(ctx, atomicReference.get());
        } else {
            atomicReference.set(ctx);
            set.add(ctx);
        }
        set2.add(httpServer);
        Integer cnt = (Integer)map.get(httpServer);
        int icnt = cnt == null ? 0 : cnt;
        map.put(httpServer, ++icnt);
        countDownLatch.countDown();
        req.response().end();
    }

    private static /* synthetic */ void lambda$testKeepAlive$1567(Set set, HttpServer httpServer, HttpServerRequest req) {
        set.add(httpServer);
        req.response().end();
    }
}

