/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import io.vertx.test.core.KeyCert;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.Trust;
import io.vertx.test.core.VertxTestBase;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.junit.Test;

public class KeyStoreTest
extends VertxTestBase {
    @Test
    public void testJKSOptions() throws Exception {
        JksOptions options = new JksOptions();
        this.assertNull(options.getPath());
        String randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPath(randString));
        this.assertEquals(randString, options.getPath());
        this.assertNull(options.getPassword());
        randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPassword(randString));
        this.assertEquals(randString, options.getPassword());
    }

    @Test
    public void testDefaultJKSOptionsJson() {
        JksOptions def = new JksOptions();
        JksOptions json = new JksOptions(new JsonObject());
        this.assertEquals(def.getPassword(), json.getPassword());
        this.assertEquals(def.getPath(), json.getPath());
        this.assertEquals(def.getValue(), json.getValue());
    }

    @Test
    public void testJKSOptionsJson() throws Exception {
        JksOptions options = new JksOptions(new JsonObject());
        this.assertEquals(null, options.getPassword());
        this.assertEquals(null, options.getPath());
        this.assertEquals(null, options.getValue());
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        String value = TestUtils.randomAlphaString(100);
        options = new JksOptions(new JsonObject().put("password", password).put("path", path).put("value", value.getBytes()));
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(Buffer.buffer((String)value), options.getValue());
    }

    @Test
    public void testCopyJKSOptions() throws Exception {
        JksOptions options = new JksOptions();
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        Buffer value = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.setPassword(password);
        options.setPath(path);
        options.setValue(value);
        options = new JksOptions(options);
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(value, options.getValue());
    }

    @Test
    public void testPKCS12Options() throws Exception {
        PfxOptions options = new PfxOptions();
        this.assertNull(options.getPath());
        String randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPath(randString));
        this.assertEquals(randString, options.getPath());
        this.assertNull(options.getPassword());
        randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setPassword(randString));
        this.assertEquals(randString, options.getPassword());
    }

    @Test
    public void testDefaultPKCS12OptionsJson() {
        PfxOptions def = new PfxOptions();
        PfxOptions json = new PfxOptions(new JsonObject());
        this.assertEquals(def.getPassword(), json.getPassword());
        this.assertEquals(def.getPath(), json.getPath());
        this.assertEquals(def.getValue(), json.getValue());
    }

    @Test
    public void testPKCS12OptionsJson() throws Exception {
        PfxOptions options = new PfxOptions(new JsonObject());
        this.assertEquals(null, options.getPassword());
        this.assertEquals(null, options.getPath());
        this.assertEquals(null, options.getValue());
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        String value = TestUtils.randomAlphaString(100);
        options = new PfxOptions(new JsonObject().put("password", password).put("path", path).put("value", value.getBytes()));
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(Buffer.buffer((String)value), options.getValue());
    }

    @Test
    public void testCopyPKCS12Options() throws Exception {
        PfxOptions options = new PfxOptions();
        String password = TestUtils.randomAlphaString(100);
        String path = TestUtils.randomAlphaString(100);
        Buffer value = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.setPassword(password);
        options.setPath(path);
        options.setValue(value);
        options = new PfxOptions(options);
        this.assertEquals(password, options.getPassword());
        this.assertEquals(path, options.getPath());
        this.assertEquals(value, options.getValue());
    }

    @Test
    public void testKeyCertOptions() throws Exception {
        PemKeyCertOptions options = new PemKeyCertOptions();
        this.assertNull(options.getKeyPath());
        String randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setKeyPath(randString));
        this.assertEquals(randString, options.getKeyPath());
        this.assertNull(options.getCertPath());
        randString = TestUtils.randomAlphaString(100);
        this.assertEquals(options, options.setCertPath(randString));
        this.assertEquals(randString, options.getCertPath());
    }

    @Test
    public void testDefaultKeyCertOptionsJson() throws Exception {
        PemKeyCertOptions def = new PemKeyCertOptions();
        PemKeyCertOptions json = new PemKeyCertOptions(new JsonObject());
        this.assertEquals(def.getKeyPath(), json.getKeyPath());
        this.assertEquals(def.getCertPath(), json.getCertPath());
        this.assertEquals(def.getKeyValue(), json.getKeyValue());
        this.assertEquals(def.getCertValue(), json.getCertValue());
    }

    @Test
    public void testKeyCertOptionsJson() throws Exception {
        PemKeyCertOptions options = new PemKeyCertOptions(new JsonObject());
        this.assertEquals(null, options.getKeyPath());
        this.assertEquals(null, options.getKeyValue());
        this.assertEquals(null, options.getCertPath());
        this.assertEquals(null, options.getCertValue());
        String keyPath = TestUtils.randomAlphaString(100);
        String keyValue = TestUtils.randomAlphaString(100);
        String certPath = TestUtils.randomAlphaString(100);
        String certValue = TestUtils.randomAlphaString(100);
        options = new PemKeyCertOptions(new JsonObject().put("keyPath", keyPath).put("keyValue", keyValue.getBytes()).put("certPath", certPath).put("certValue", certValue.getBytes()));
        this.assertEquals(keyPath, options.getKeyPath());
        this.assertEquals(Buffer.buffer((String)keyValue), options.getKeyValue());
        this.assertEquals(certPath, options.getCertPath());
        this.assertEquals(Buffer.buffer((String)certValue), options.getCertValue());
    }

    @Test
    public void testCopyKeyCertOptions() throws Exception {
        PemKeyCertOptions options = new PemKeyCertOptions(new JsonObject());
        String keyPath = TestUtils.randomAlphaString(100);
        Buffer keyValue = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        String certPath = TestUtils.randomAlphaString(100);
        Buffer certValue = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.setKeyPath(keyPath);
        options.setKeyValue(keyValue);
        options.setCertPath(certPath);
        options.setCertValue(certValue);
        options = new PemKeyCertOptions(options);
        this.assertEquals(keyPath, options.getKeyPath());
        this.assertEquals(keyValue, options.getKeyValue());
        this.assertEquals(certPath, options.getCertPath());
        this.assertEquals(certValue, options.getCertValue());
    }

    @Test
    public void testTrustOptions() throws Exception {
        PemTrustOptions options = new PemTrustOptions();
        this.assertEquals(Collections.emptyList(), options.getCertPaths());
        TestUtils.assertNullPointerException(() -> options.addCertPath(null));
        TestUtils.assertIllegalArgumentException(() -> options.addCertPath(""));
        String randString = TestUtils.randomAlphaString(100);
        options.addCertPath(randString);
        this.assertEquals(Collections.singletonList(randString), options.getCertPaths());
        this.assertEquals(Collections.emptyList(), options.getCertValues());
        TestUtils.assertNullPointerException(() -> options.addCertValue(null));
        randString = TestUtils.randomAlphaString(100);
        options.addCertValue(Buffer.buffer((String)randString));
        this.assertEquals(Collections.singletonList(Buffer.buffer((String)randString)), options.getCertValues());
    }

    @Test
    public void testTrustOptionsJson() throws Exception {
        PemTrustOptions options = new PemTrustOptions(new JsonObject());
        this.assertEquals(Collections.emptyList(), options.getCertPaths());
        this.assertEquals(Collections.emptyList(), options.getCertValues());
        String certPath = TestUtils.randomAlphaString(100);
        String certValue = TestUtils.randomAlphaString(100);
        JsonObject json = new JsonObject().put("certPaths", new JsonArray().add(certPath)).put("certValues", new JsonArray().add(certValue.getBytes()));
        options = new PemTrustOptions(json);
        this.assertEquals(Collections.singletonList(certPath), options.getCertPaths());
        this.assertEquals(Collections.singletonList(Buffer.buffer((String)certValue)), options.getCertValues());
    }

    @Test
    public void testDefaultTrustOptionsJson() {
        PemTrustOptions def = new PemTrustOptions();
        PemTrustOptions json = new PemTrustOptions(new JsonObject());
        this.assertEquals(def.getCertPaths(), json.getCertPaths());
        this.assertEquals(def.getCertValues(), json.getCertValues());
    }

    @Test
    public void testCopyTrustOptions() throws Exception {
        PemTrustOptions options = new PemTrustOptions(new JsonObject());
        String certPath = TestUtils.randomAlphaString(100);
        Buffer certValue = Buffer.buffer((String)TestUtils.randomAlphaString(100));
        options.addCertPath(certPath);
        options.addCertValue(certValue);
        options = new PemTrustOptions(options);
        this.assertEquals(Collections.singletonList(certPath), options.getCertPaths());
        this.assertEquals(Collections.singletonList(certValue), options.getCertValues());
    }

    @Test
    public void testJKSPath() throws Exception {
        this.testKeyStore(this.getServerCertOptions(KeyCert.JKS));
    }

    @Test
    public void testJKSValue() throws Exception {
        JksOptions options = (JksOptions)this.getServerCertOptions(KeyCert.JKS);
        Buffer store = this.vertx.fileSystem().readFileBlocking(options.getPath());
        options.setPath(null).setValue(store);
        this.testKeyStore((KeyCertOptions)options);
    }

    @Test
    public void testPKCS12Path() throws Exception {
        this.testKeyStore(this.getServerCertOptions(KeyCert.PKCS12));
    }

    @Test
    public void testPKCS12Value() throws Exception {
        PfxOptions options = (PfxOptions)this.getServerCertOptions(KeyCert.PKCS12);
        Buffer store = this.vertx.fileSystem().readFileBlocking(options.getPath());
        options.setPath(null).setValue(store);
        this.testKeyStore((KeyCertOptions)options);
    }

    @Test
    public void testKeyCertPath() throws Exception {
        this.testKeyStore(this.getServerCertOptions(KeyCert.PEM));
    }

    @Test
    public void testKeyCertValue() throws Exception {
        PemKeyCertOptions options = (PemKeyCertOptions)this.getServerCertOptions(KeyCert.PEM);
        Buffer key = this.vertx.fileSystem().readFileBlocking(options.getKeyPath());
        options.setKeyValue(null).setKeyValue(key);
        Buffer cert = this.vertx.fileSystem().readFileBlocking(options.getCertPath());
        options.setCertValue(null).setCertValue(cert);
        this.testKeyStore((KeyCertOptions)options);
    }

    @Test
    public void testCaPath() throws Exception {
        this.testTrustStore(this.getServerTrustOptions(Trust.PEM));
    }

    @Test
    public void testCaPathValue() throws Exception {
        PemTrustOptions options = (PemTrustOptions)this.getServerTrustOptions(Trust.PEM);
        options.getCertPaths().stream().map(arg_0 -> ((FileSystem)this.vertx.fileSystem()).readFileBlocking(arg_0)).forEach(arg_0 -> ((PemTrustOptions)options).addCertValue(arg_0));
        options.getCertPaths().clear();
        this.testTrustStore((TrustOptions)options);
    }

    @Test
    public void testKeyOptionsEquality() {
        JksOptions jksOptions = (JksOptions)this.getServerCertOptions(KeyCert.JKS);
        JksOptions jksOptionsCopy = new JksOptions(jksOptions);
        PfxOptions pfxOptions = (PfxOptions)this.getServerCertOptions(KeyCert.PKCS12);
        PfxOptions pfxOptionsCopy = new PfxOptions(pfxOptions);
        PemKeyCertOptions pemKeyCertOptions = (PemKeyCertOptions)this.getServerCertOptions(KeyCert.PEM);
        PemKeyCertOptions pemKeyCertOptionsCopy = new PemKeyCertOptions(pemKeyCertOptions);
        this.assertEquals(jksOptions, jksOptionsCopy);
        this.assertEquals(jksOptions.hashCode(), jksOptionsCopy.hashCode());
        this.assertEquals(pfxOptions, pfxOptionsCopy);
        this.assertEquals(pfxOptions.hashCode(), pfxOptionsCopy.hashCode());
        this.assertEquals(pemKeyCertOptions, pemKeyCertOptionsCopy);
        this.assertEquals(pemKeyCertOptions.hashCode(), pemKeyCertOptionsCopy.hashCode());
    }

    private void testKeyStore(KeyCertOptions options) throws Exception {
        KeyStoreHelper helper = KeyStoreHelper.create((VertxInternal)((VertxInternal)this.vertx), (KeyCertOptions)options);
        KeyManager[] keyManagers = helper.getKeyMgrs((VertxInternal)this.vertx);
        this.assertTrue(keyManagers.length > 0);
    }

    private void testTrustStore(TrustOptions options) throws Exception {
        KeyStoreHelper helper = KeyStoreHelper.create((VertxInternal)((VertxInternal)this.vertx), (TrustOptions)options);
        TrustManager[] keyManagers = helper.getTrustMgrs((VertxInternal)this.vertx);
        this.assertTrue(keyManagers.length > 0);
    }
}

