/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.metrics.Measured;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.test.core.ConfigurableMetricsFactory;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakemetrics.FakeEventBusMetrics;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.FakeMetricsFactory;
import io.vertx.test.fakemetrics.HandlerMetric;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.HttpServerMetric;
import io.vertx.test.fakemetrics.ReceivedMessage;
import io.vertx.test.fakemetrics.SentMessage;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetricsTest
extends VertxTestBase {
    private static final String ADDRESS1 = "some-address1";

    @BeforeClass
    public static void setFactory() {
        ConfigurableMetricsFactory.delegate = new FakeMetricsFactory();
    }

    @AfterClass
    public static void unsetFactory() {
        ConfigurableMetricsFactory.delegate = null;
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.setMetricsOptions(new MetricsOptions().setEnabled(true));
        return options;
    }

    @Test
    public void testSendMessage() {
        this.testBroadcastMessage(this.vertx, new Vertx[]{this.vertx}, false, true, false);
    }

    @Test
    public void testSendMessageInCluster() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], new Vertx[]{this.vertices[1]}, false, false, true);
    }

    @Test
    public void testPublishMessageToSelf() {
        this.testBroadcastMessage(this.vertx, new Vertx[]{this.vertx}, true, true, false);
    }

    @Test
    public void testPublishMessageToRemote() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], new Vertx[]{this.vertices[1]}, true, false, true);
    }

    @Test
    public void testPublishMessageToCluster() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], this.vertices, true, true, true);
    }

    private void testBroadcastMessage(Vertx from, Vertx[] to, boolean publish, boolean expectedLocal, boolean expectedRemote) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)from.eventBus());
        AtomicInteger broadcastCount = new AtomicInteger();
        AtomicInteger receiveCount = new AtomicInteger();
        for (Vertx vertx : to) {
            MessageConsumer consumer = vertx.eventBus().consumer(ADDRESS1);
            consumer.completionHandler(done -> {
                this.assertTrue(done.succeeded());
                if (broadcastCount.incrementAndGet() == to.length) {
                    String msg = TestUtils.randomAlphaString(10);
                    if (publish) {
                        from.eventBus().publish(ADDRESS1, (Object)msg);
                    } else {
                        from.eventBus().send(ADDRESS1, (Object)msg);
                    }
                }
            });
            consumer.handler(msg -> {
                if (receiveCount.incrementAndGet() == to.length) {
                    this.assertEquals(Arrays.asList(new SentMessage(ADDRESS1, publish, expectedLocal, expectedRemote)), eventBusMetrics.getSentMessages());
                    this.testComplete();
                }
            });
        }
        this.await();
    }

    @Test
    public void testReceiveSentMessageFromSelf() {
        this.testReceiveMessageSent(this.vertx, this.vertx, true, 1);
    }

    @Test
    public void testReceiveMessageSentFromRemote() {
        this.startNodes(2);
        this.testReceiveMessageSent(this.vertices[0], this.vertices[1], false, 1);
    }

    private void testReceiveMessageSent(Vertx from, Vertx to, boolean expectedLocal, int expectedHandlers) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        consumer.completionHandler(done -> {
            this.assertTrue(done.succeeded());
            String msg = TestUtils.randomAlphaString(10);
            from.eventBus().send(ADDRESS1, (Object)msg);
        });
        consumer.handler(msg -> {
            this.assertEquals(Arrays.asList(new ReceivedMessage(ADDRESS1, false, expectedLocal, expectedHandlers)), eventBusMetrics.getReceivedMessages());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testReceivePublishedMessageFromSelf() {
        this.testReceiveMessagePublished(this.vertx, this.vertx, true, 3);
    }

    @Test
    public void testReceiveMessagePublishedFromRemote() {
        this.startNodes(2);
        this.testReceiveMessagePublished(this.vertices[0], this.vertices[1], false, 3);
    }

    private void testReceiveMessagePublished(Vertx from, Vertx to, boolean expectedLocal, int expectedHandlers) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        AtomicInteger count = new AtomicInteger();
        int i = 0;
        while (i < expectedHandlers) {
            MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
            consumer.completionHandler(done -> {
                this.assertTrue(done.succeeded());
                if (count.incrementAndGet() == expectedHandlers) {
                    String msg = TestUtils.randomAlphaString(10);
                    from.eventBus().publish(ADDRESS1, (Object)msg);
                }
            });
            int index = i++;
            consumer.handler(msg -> {
                if (index == 0) {
                    this.assertEquals(Arrays.asList(new ReceivedMessage(ADDRESS1, true, expectedLocal, expectedHandlers)), eventBusMetrics.getReceivedMessages());
                    this.testComplete();
                }
            });
        }
        this.await();
    }

    @Test
    public void testReplyMessageFromSelf() {
        this.testReply(this.vertx, this.vertx, true, false);
    }

    @Test
    public void testReplyMessageFromRemote() {
        this.startNodes(2);
        this.testReply(this.vertices[0], this.vertices[1], false, true);
    }

    private void testReply(Vertx from, Vertx to, boolean expectedLocal, boolean expectedRemote) {
        FakeEventBusMetrics fromMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)from.eventBus());
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        consumer.completionHandler(done -> {
            this.assertTrue(done.succeeded());
            String msg = TestUtils.randomAlphaString(10);
            from.eventBus().send(ADDRESS1, (Object)msg, reply -> {
                this.assertEquals(1L, fromMetrics.getReceivedMessages().size());
                ReceivedMessage receivedMessage = fromMetrics.getReceivedMessages().get(0);
                this.assertEquals(false, receivedMessage.publish);
                this.assertEquals(expectedLocal, receivedMessage.local);
                this.assertEquals(1L, receivedMessage.handlers);
                this.assertEquals(1L, toMetrics.getSentMessages().size());
                SentMessage sentMessage = toMetrics.getSentMessages().get(0);
                this.assertEquals(false, sentMessage.publish);
                this.assertEquals(expectedLocal, sentMessage.local);
                this.assertEquals(expectedRemote, sentMessage.remote);
                this.assertEquals(sentMessage.address, receivedMessage.address);
                this.testComplete();
            });
        });
        consumer.handler(msg -> {
            toMetrics.getReceivedMessages().clear();
            toMetrics.getSentMessages().clear();
            msg.reply((Object)TestUtils.randomAlphaString(10));
        });
        this.await();
    }

    @Test
    public void testHandlerRegistration() throws Exception {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        MessageConsumer consumer = this.vertx.eventBus().consumer(ADDRESS1, msg -> {});
        CountDownLatch latch = new CountDownLatch(1);
        consumer.completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertEquals(1L, metrics.getRegistrations().size());
        HandlerMetric registration = metrics.getRegistrations().get(0);
        this.assertEquals(ADDRESS1, registration.address);
        this.assertEquals(false, registration.replyHandler);
        consumer.unregister(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, metrics.getRegistrations().size());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testHandlerProcessMessage() {
        this.testHandlerProcessMessage(this.vertx, this.vertx, 1);
    }

    @Test
    public void testHandlerProcessMessageFromRemote() {
        this.startNodes(2);
        this.testHandlerProcessMessage(this.vertices[0], this.vertices[1], 0);
    }

    private HandlerMetric assertRegistration(FakeEventBusMetrics metrics) {
        Optional<HandlerMetric> registration = metrics.getRegistrations().stream().filter(reg -> reg.address.equals(ADDRESS1)).findFirst();
        this.assertTrue(registration.isPresent());
        return registration.get();
    }

    private void testHandlerProcessMessage(Vertx from, Vertx to, int expectedLocalCoult) {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        to.eventBus().consumer(ADDRESS1, msg -> {
            HandlerMetric registration = this.assertRegistration(metrics);
            this.assertEquals(ADDRESS1, registration.address);
            this.assertEquals(false, registration.replyHandler);
            this.assertEquals(1L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(0L, registration.failureCount.get());
            this.assertEquals(expectedLocalCoult, registration.localCount.get());
            msg.reply((Object)"pong");
        }).completionHandler(this.onSuccess(v -> from.eventBus().send(ADDRESS1, (Object)"ping", reply -> {
            HandlerMetric registration = this.assertRegistration(metrics);
            this.assertEquals(ADDRESS1, registration.address);
            this.assertEquals(false, registration.replyHandler);
            this.assertEquals(1L, registration.beginCount.get());
            this.waitUntil(() -> 1 == handlerMetric.endCount.get());
            this.assertEquals(0L, registration.failureCount.get());
            this.assertEquals(expectedLocalCoult, registration.localCount.get());
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testHandlerProcessMessageFailure() throws Exception {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        MessageConsumer consumer = this.vertx.eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(1L, metrics.getReceivedMessages().size());
            HandlerMetric registration = metrics.getRegistrations().get(0);
            this.assertEquals(1L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(0L, registration.failureCount.get());
            throw new RuntimeException();
        });
        CountDownLatch latch = new CountDownLatch(1);
        consumer.completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.vertx.eventBus().send(ADDRESS1, (Object)"ping");
        this.assertEquals(1L, metrics.getReceivedMessages().size());
        HandlerMetric registration = metrics.getRegistrations().get(0);
        long now = System.currentTimeMillis();
        while (registration.failureCount.get() < 1 && System.currentTimeMillis() - now < 10000L) {
            Thread.sleep(10L);
        }
        this.assertEquals(1L, registration.beginCount.get());
        this.assertEquals(1L, registration.endCount.get());
        this.assertEquals(1L, registration.failureCount.get());
    }

    @Test
    public void testHandlerMetricReply() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        this.vertx.eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(ADDRESS1, fakeEventBusMetrics.getRegistrations().get((int)0).address);
            this.waitUntil(() -> metrics.getRegistrations().size() == 2);
            HandlerMetric registration = metrics.getRegistrations().get(1);
            this.assertTrue(registration.replyHandler);
            this.assertEquals(0L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(0L, registration.localCount.get());
            msg.reply((Object)"pong");
        }).completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.vertx.eventBus().send(ADDRESS1, (Object)"ping", reply -> {
            this.assertEquals(ADDRESS1, fakeEventBusMetrics.getRegistrations().get((int)0).address);
            HandlerMetric registration = metrics.getRegistrations().get(1);
            this.assertTrue(registration.replyHandler);
            this.assertEquals(1L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(1L, registration.localCount.get());
            this.vertx.runOnContext(v -> {
                this.assertEquals(ADDRESS1, fakeEventBusMetrics.getRegistrations().get((int)0).address);
                this.assertTrue(handlerMetric.replyHandler);
                this.assertEquals(1L, handlerMetric.beginCount.get());
                this.assertEquals(1L, handlerMetric.endCount.get());
                this.assertEquals(1L, handlerMetric.localCount.get());
            });
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testBytesCodec() throws Exception {
        this.startNodes(2);
        FakeEventBusMetrics fromMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[0].eventBus());
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[1].eventBus());
        this.vertices[1].eventBus().consumer(ADDRESS1, msg -> {
            int encoded = fromMetrics.getEncodedBytes(ADDRESS1);
            int decoded = toMetrics.getDecodedBytes(ADDRESS1);
            this.assertTrue("Expected to have more " + encoded + " > 1000 encoded bytes", encoded > 1000);
            this.assertTrue("Expected to have more " + decoded + " > 1000 decoded bytes", decoded > 1000);
            this.testComplete();
        }).completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, fromMetrics.getEncodedBytes(ADDRESS1));
            this.assertEquals(0L, toMetrics.getDecodedBytes(ADDRESS1));
            this.vertices[0].eventBus().send(ADDRESS1, (Object)Buffer.buffer((byte[])new byte[1000]));
        });
        this.await();
    }

    @Test
    public void testServerWebSocket() throws Exception {
        HttpServer server = this.vertx.createHttpServer();
        server.websocketHandler(ws -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)server);
            WebSocketMetric metric = metrics.getMetric((ServerWebSocket)ws);
            this.assertNotNull(metric);
            this.assertNotNull(metric.soMetric);
            ws.handler(buffer -> ws.close());
            ws.closeHandler(closed -> {
                this.assertNull(metrics.getMetric((ServerWebSocket)ws));
                this.testComplete();
            });
        });
        server.listen(8080, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", "/", ws -> ws.write(Buffer.buffer((String)"wibble")));
        });
        this.await();
    }

    @Test
    public void testWebSocket() throws Exception {
        HttpServer server = this.vertx.createHttpServer();
        server.websocketHandler(ws -> ws.write(Buffer.buffer((String)"wibble")));
        server.listen(8080, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", "/", ws -> {
                FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client);
                WebSocketMetric metric = metrics.getMetric((WebSocket)ws);
                this.assertNotNull(metric);
                this.assertNotNull(metric.soMetric);
                ws.closeHandler(closed -> {
                    this.assertNull(metrics.getMetric((WebSocket)ws));
                    this.testComplete();
                });
                ws.handler(buffer -> ws.close());
            });
        });
        this.await();
    }

    @Test
    public void testMulti() {
        HttpServer s1 = this.vertx.createHttpServer();
        s1.requestHandler(req -> {});
        s1.listen(8080, ar1 -> {
            this.assertTrue(ar1.succeeded());
            HttpServer s2 = this.vertx.createHttpServer();
            s2.requestHandler(req -> req.response().end());
            s2.listen(8080, ar2 -> {
                this.assertTrue(ar2.succeeded());
                FakeHttpServerMetrics metrics1 = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)ar1.result());
                this.assertSame(ar1.result(), metrics1.server);
                FakeHttpServerMetrics metrics2 = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)ar2.result());
                this.assertSame(ar2.result(), metrics2.server);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testHttpConnect() {
        AtomicReference clientMetric = new AtomicReference();
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)server);
            HttpServerMetric serverMetric = metrics.getMetric((HttpServerRequest)req);
            this.assertNotNull(serverMetric);
            req.response().setStatusCode(200);
            req.response().setStatusMessage("Connection established");
            req.response().end();
            NetSocket so = req.netSocket();
            so.handler(arg_0 -> ((NetSocket)req.netSocket()).write(arg_0));
            so.closeHandler(v -> {
                this.assertNull(metrics.getMetric((HttpServerRequest)req));
                this.assertFalse(httpServerMetric.socket.connected.get());
                this.assertEquals(5L, httpServerMetric.socket.bytesRead.get());
                this.assertEquals(5L, httpServerMetric.socket.bytesWritten.get());
                this.assertFalse(((HttpClientMetric)atomicReference.get()).socket.connected.get());
                this.assertEquals(5L, ((HttpClientMetric)atomicReference.get()).socket.bytesRead.get());
                this.assertEquals(5L, ((HttpClientMetric)atomicReference.get()).socket.bytesWritten.get());
                this.testComplete();
            });
        }).listen(8080, ar1 -> {
            this.assertTrue(ar1.succeeded());
            HttpClient client = this.vertx.createHttpClient();
            HttpClientRequest request = client.request(HttpMethod.CONNECT, 8080, "localhost", "/");
            FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client);
            request.handler(resp -> {
                this.assertEquals(200L, resp.statusCode());
                clientMetric.set(metrics.getMetric(request));
                this.assertNotNull(clientMetric.get());
                NetSocket socket = resp.netSocket();
                socket.write(Buffer.buffer((String)"hello"));
                socket.handler(buf -> {
                    this.assertEquals("hello", buf.toString());
                    this.assertNull(metrics.getMetric(request));
                    socket.close();
                });
            }).end();
        });
        this.await();
    }
}

