/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Starter;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.metrics.impl.DummyVertxMetrics;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.test.core.ConfigurableMetricsFactory;
import io.vertx.test.core.CustomMetricsOptions;
import io.vertx.test.core.TestVerticle;
import io.vertx.test.core.VertxTestBase;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StarterTest
extends VertxTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestVerticle.instanceCount.set(0);
        TestVerticle.processArgs = null;
        TestVerticle.conf = null;
    }

    @Override
    public void tearDown() throws Exception {
        this.clearProperties();
        super.tearDown();
    }

    @Test
    public void testVersion() throws Exception {
        String[] args = new String[]{"-version"};
        MyStarter starter = new MyStarter();
        starter.run(args);
        this.assertEquals(System.getProperty("vertxVersion"), starter.getVersion());
    }

    @Test
    public void testRunVerticle() throws Exception {
        this.testRunVerticleMultiple(1);
    }

    @Test
    public void testRunVerticleMultipleInstances() throws Exception {
        this.testRunVerticleMultiple(10);
    }

    public void testRunVerticleMultiple(int instances) throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-instances", String.valueOf(instances)};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == instances);
        this.assertTrue(t.isAlive());
        List<String> processArgs = TestVerticle.processArgs;
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.assertHooksInvoked();
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    @Test
    public void testRunVerticleClustered() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertTrue(t.isAlive());
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.assertHooksInvoked();
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    @Test
    public void testRunVerticleHA() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-ha"};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertTrue(t.isAlive());
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.assertHooksInvoked();
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestNoArgs() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertTrue(t.isAlive());
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestWithArgs() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"-cluster", "-worker"};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertTrue(t.isAlive());
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    @Test
    public void testRunVerticleWithConfString() throws Exception {
        MyStarter starter = new MyStarter();
        JsonObject conf = new JsonObject().put("foo", "bar").put("wibble", Integer.valueOf(123));
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-conf", conf.encode()};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertTrue(t.isAlive());
        this.assertEquals(conf, TestVerticle.conf);
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    @Test
    public void testRunVerticleWithConfFile() throws Exception {
        Path tempDir = this.testFolder.newFolder().toPath();
        Path tempFile = Files.createTempFile(tempDir, "conf", "json", new FileAttribute[0]);
        MyStarter starter = new MyStarter();
        JsonObject conf = new JsonObject().put("foo", "bar").put("wibble", Integer.valueOf(123));
        Files.write(tempFile, conf.encode().getBytes(), new OpenOption[0]);
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-conf", tempFile.toString()};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertTrue(t.isAlive());
        this.assertEquals(conf, TestVerticle.conf);
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    @Test
    public void testConfigureFromSystemProperties() throws Exception {
        this.testConfigureFromSystemProperties(false);
    }

    @Test
    public void testConfigureFromSystemPropertiesClustered() throws Exception {
        this.testConfigureFromSystemProperties(true);
    }

    private void testConfigureFromSystemProperties(boolean clustered) throws Exception {
        System.setProperty("vertx.options.eventLoopPoolSize", "123");
        System.setProperty("vertx.options.maxEventLoopExecuteTime", "123767667");
        System.setProperty("vertx.metrics.options.enabled", "true");
        System.setProperty("vertx.options.haGroup", "somegroup");
        MyStarter starter = new MyStarter();
        String[] args = clustered ? new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"} : new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = starter.getVertxOptions();
        this.assertEquals(123.0, (double)opts.getEventLoopPoolSize(), 0.0);
        this.assertEquals(123767667L, opts.getMaxEventLoopExecuteTime());
        this.assertEquals(true, opts.getMetricsOptions().isEnabled());
        this.assertEquals("somegroup", opts.getHAGroup());
    }

    private void clearProperties() {
        HashSet<String> toClear = new HashSet<String>();
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.startsWith("vertx.options")) continue;
            toClear.add(propName);
        }
        for (String propName : toClear) {
            System.clearProperty(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomMetricsOptions() throws Exception {
        try {
            ConfigurableMetricsFactory.delegate = new VertxMetricsFactory(){

                public VertxMetrics metrics(Vertx vertx, VertxOptions options) {
                    return new DummyVertxMetrics();
                }

                public MetricsOptions newOptions() {
                    return new CustomMetricsOptions();
                }
            };
            System.setProperty("vertx.metrics.options.enabled", "true");
            System.setProperty("vertx.metrics.options.customProperty", "customPropertyValue");
            MyStarter starter = new MyStarter();
            String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
            Thread t = new Thread(() -> starter.run(args));
            t.start();
            this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
            VertxOptions opts = starter.getVertxOptions();
            CustomMetricsOptions custom = (CustomMetricsOptions)opts.getMetricsOptions();
            this.assertEquals("customPropertyValue", custom.getCustomProperty());
        }
        finally {
            ConfigurableMetricsFactory.delegate = null;
        }
    }

    @Test
    public void testConfigureFromSystemPropertiesInvalidPropertyName() throws Exception {
        System.setProperty("vertx.options.nosuchproperty", "123");
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = starter.getVertxOptions();
        this.assertEquals(new VertxOptions(), opts);
    }

    @Test
    public void testConfigureFromSystemPropertiesInvalidPropertyType() throws Exception {
        System.setProperty("vertx.options.eventLoopPoolSize", "sausages");
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        Thread t = new Thread(() -> starter.run(args));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = starter.getVertxOptions();
        this.assertEquals(new VertxOptions(), opts);
    }

    @Test
    public void testRunWithCommandLine() throws Exception {
        MyStarter starter = new MyStarter();
        int instances = 10;
        String cl = "run java:" + TestVerticle.class.getCanonicalName() + " -instances " + instances;
        Thread t = new Thread(() -> starter.run(cl));
        t.start();
        this.waitUntil(() -> TestVerticle.instanceCount.get() == instances);
        this.assertTrue(t.isAlive());
        starter.unblock();
        this.waitUntil(() -> !t.isAlive());
    }

    class MyStarter
    extends Starter {
        boolean beforeStartingVertxInvoked = false;
        boolean afterStartingVertxInvoked = false;
        boolean beforeDeployingVerticle = false;

        MyStarter() {
        }

        public Vertx getVert() {
            return this.vertx;
        }

        public VertxOptions getVertxOptions() {
            return this.options;
        }

        public DeploymentOptions getDeploymentOptions() {
            return this.deploymentOptions;
        }

        public void run(String[] sargs) {
            super.run(sargs);
        }

        public void run(String commandLine) {
            super.run(commandLine);
        }

        public void beforeStartingVertx(VertxOptions options) {
            this.beforeStartingVertxInvoked = true;
        }

        public void afterStartingVertx() {
            this.afterStartingVertxInvoked = true;
        }

        protected void beforeDeployingVerticle(DeploymentOptions deploymentOptions) {
            this.beforeDeployingVerticle = true;
        }

        public void assertHooksInvoked() {
            StarterTest.this.assertTrue(this.beforeStartingVertxInvoked);
            StarterTest.this.assertTrue(this.afterStartingVertxInvoked);
            StarterTest.this.assertTrue(this.beforeDeployingVerticle);
        }
    }
}

