/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.buffer.Buffer;
import java.util.Random;
import org.junit.Assert;

public class TestUtils {
    private static Random random = new Random();

    public static Buffer randomBuffer(int length) {
        return TestUtils.randomBuffer(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length) {
        return TestUtils.randomByteArray(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length, boolean avoid, byte avoidByte) {
        byte[] line = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte rand;
            do {
                rand = TestUtils.randomByte();
            } while (avoid && rand == avoidByte);
            line[i] = rand;
        }
        return line;
    }

    public static Buffer randomBuffer(int length, boolean avoid, byte avoidByte) {
        byte[] line = TestUtils.randomByteArray(length, avoid, avoidByte);
        return Buffer.buffer((byte[])line);
    }

    public static byte randomByte() {
        return (byte)((int)(Math.random() * 255.0) - 128);
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomPortInt() {
        return random.nextInt(65536);
    }

    public static int randomPositiveInt() {
        int rand;
        while ((rand = random.nextInt()) <= 0) {
        }
        return rand;
    }

    public static long randomPositiveLong() {
        long rand;
        while ((rand = random.nextLong()) <= 0L) {
        }
        return rand;
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static char randomChar() {
        return (char)random.nextInt(16);
    }

    public static short randomShort() {
        return (short)(random.nextInt(16) - Short.MAX_VALUE);
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static String randomUnicodeString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c;
            while ((c = (char)(65535.0 * Math.random())) >= '\ufffe' && c <= '\uffff' || c >= '\ud800' && c <= '\udfff') {
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String randomAlphaString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = (char)(65.0 + 25.0 * Math.random());
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean byteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static void assertIllegalArgumentException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void assertNullPointerException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void assertIllegalStateException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void assertIndexOutOfBoundsException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

