/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.ServerWebSocketStream;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketStream;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.streams.ReadStream;
import io.vertx.test.core.KeyCert;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.Trust;
import io.vertx.test.core.VertxTestBase;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.Test;

public class WebsocketTest
extends VertxTestBase {
    private HttpClient client;
    private HttpServer server;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(new HttpClientOptions());
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.close();
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(ar -> {
                this.assertTrue(ar.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        super.tearDown();
    }

    @Test
    public void testRejectHybi00() throws Exception {
        this.testReject(WebsocketVersion.V00);
    }

    @Test
    public void testRejectHybi08() throws Exception {
        this.testReject(WebsocketVersion.V08);
    }

    @Test
    public void testWSBinaryHybi00() throws Exception {
        this.testWSFrames(true, WebsocketVersion.V00);
    }

    @Test
    public void testWSStringHybi00() throws Exception {
        this.testWSFrames(false, WebsocketVersion.V00);
    }

    @Test
    public void testWSBinaryHybi08() throws Exception {
        this.testWSFrames(true, WebsocketVersion.V08);
    }

    @Test
    public void testWSStringHybi08() throws Exception {
        this.testWSFrames(false, WebsocketVersion.V08);
    }

    @Test
    public void testWSBinaryHybi17() throws Exception {
        this.testWSFrames(true, WebsocketVersion.V13);
    }

    @Test
    public void testWSStringHybi17() throws Exception {
        this.testWSFrames(false, WebsocketVersion.V13);
    }

    @Test
    public void testWSStreamsHybi00() throws Exception {
        this.testWSWriteStream(WebsocketVersion.V00);
    }

    @Test
    public void testWSStreamsHybi08() throws Exception {
        this.testWSWriteStream(WebsocketVersion.V08);
    }

    @Test
    public void testWSStreamsHybi17() throws Exception {
        this.testWSWriteStream(WebsocketVersion.V13);
    }

    @Test
    public void testWriteFromConnectHybi00() throws Exception {
        this.testWriteFromConnectHandler(WebsocketVersion.V00);
    }

    @Test
    public void testWriteFromConnectHybi08() throws Exception {
        this.testWriteFromConnectHandler(WebsocketVersion.V08);
    }

    @Test
    public void testWriteFromConnectHybi17() throws Exception {
        this.testWriteFromConnectHandler(WebsocketVersion.V13);
    }

    @Test
    public void testContinuationWriteFromConnectHybi08() throws Exception {
        this.testContinuationWriteFromConnectHandler(WebsocketVersion.V08);
    }

    @Test
    public void testContinuationWriteFromConnectHybi17() throws Exception {
        this.testContinuationWriteFromConnectHandler(WebsocketVersion.V13);
    }

    @Test
    public void testValidSubProtocolHybi00() throws Exception {
        this.testValidSubProtocol(WebsocketVersion.V00);
    }

    @Test
    public void testValidSubProtocolHybi08() throws Exception {
        this.testValidSubProtocol(WebsocketVersion.V08);
    }

    @Test
    public void testValidSubProtocolHybi17() throws Exception {
        this.testValidSubProtocol(WebsocketVersion.V13);
    }

    @Test
    public void testInvalidSubProtocolHybi00() throws Exception {
        this.testInvalidSubProtocol(WebsocketVersion.V00);
    }

    @Test
    public void testInvalidSubProtocolHybi08() throws Exception {
        this.testInvalidSubProtocol(WebsocketVersion.V08);
    }

    @Test
    public void testInvalidSubProtocolHybi17() throws Exception {
        this.testInvalidSubProtocol(WebsocketVersion.V13);
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.NONE, KeyCert.JKS, Trust.NONE, false, false, true, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.PKCS12, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.PEM, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustServerCertPEM_CA() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM_CA, KeyCert.PEM_CA, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPKCS12ServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PKCS12, KeyCert.JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientTrustPEMServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM, KeyCert.JKS, Trust.NONE, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.NONE, KeyCert.JKS, Trust.NONE, false, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.JKS, false, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPKCS12() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.PKCS12, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredPEM() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.PEM, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPKCS12Required() throws Exception {
        this.testTLS(KeyCert.PKCS12, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEMRequired() throws Exception {
        this.testTLS(KeyCert.PEM, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertPEM_CARequired() throws Exception {
        this.testTLS(KeyCert.PEM_CA, Trust.JKS, KeyCert.JKS, Trust.PEM_CA, true, false, false, false, true, new String[0]);
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.JKS, KeyCert.JKS, Trust.JKS, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(KeyCert.JKS, Trust.JKS, KeyCert.JKS, Trust.NONE, true, false, false, false, false, new String[0]);
    }

    @Test
    public void testTLSClientRevokedServerCert() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.PEM_CA, KeyCert.PEM_CA, Trust.NONE, false, false, false, true, false, new String[0]);
    }

    @Test
    public void testTLSRevokedClientCertServer() throws Exception {
        this.testTLS(KeyCert.PEM_CA, Trust.JKS, KeyCert.JKS, Trust.PEM_CA, true, true, false, false, false, new String[0]);
    }

    @Test
    public void testTLSCipherSuites() throws Exception {
        this.testTLS(KeyCert.NONE, Trust.NONE, KeyCert.JKS, Trust.NONE, false, false, true, false, true, ENABLED_CIPHER_SUITES);
    }

    private void testTLS(KeyCert clientCert, Trust clientTrust, KeyCert serverCert, Trust serverTrust, boolean requireClientAuth, boolean serverUsesCrl, boolean clientTrustAll, boolean clientUsesCrl, boolean shouldPass, String ... enabledCipherSuites) throws Exception {
        HttpClientOptions options = new HttpClientOptions();
        options.setSsl(true);
        if (clientTrustAll) {
            options.setTrustAll(true);
        }
        if (clientUsesCrl) {
            options.addCrlPath(this.findFileOnClasspath("tls/ca/crl.pem"));
        }
        this.setOptions((TCPSSLOptions)options, this.getClientTrustOptions(clientTrust));
        this.setOptions((TCPSSLOptions)options, this.getClientCertOptions(clientCert));
        for (String suite : enabledCipherSuites) {
            options.addEnabledCipherSuite(suite);
        }
        this.client = this.vertx.createHttpClient(options);
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setSsl(true);
        this.setOptions((TCPSSLOptions)serverOptions, this.getServerTrustOptions(serverTrust));
        this.setOptions((TCPSSLOptions)serverOptions, this.getServerCertOptions(serverCert));
        if (requireClientAuth) {
            serverOptions.setClientAuthRequired(true);
        }
        if (serverUsesCrl) {
            serverOptions.addCrlPath(this.findFileOnClasspath("tls/ca/crl.pem"));
        }
        for (String suite : enabledCipherSuites) {
            serverOptions.addEnabledCipherSuite(suite);
        }
        this.server = this.vertx.createHttpServer(serverOptions.setPort(4043));
        this.server.websocketHandler(ws -> ws.handler(arg_0 -> ((ServerWebSocket)ws).write(arg_0)));
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocketStream(4043, "localhost", "/").exceptionHandler(t -> {
                if (shouldPass) {
                    t.printStackTrace();
                    this.fail("Should not throw exception");
                } else {
                    this.testComplete();
                }
            }).handler(ws -> {
                int size = 100;
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == size) {
                        ws.close();
                        this.testComplete();
                    }
                });
                Buffer buff = Buffer.buffer((byte[])TestUtils.randomByteArray(size));
                ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
            });
        });
        this.await();
    }

    @Test
    public void testHandleWSManually() throws Exception {
        String path = "/some/path";
        String message = "here is some text data";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> {
            NetSocket sock = this.getUpgradedNetSocket((HttpServerRequest)req, path);
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)-127);
            buff.appendByte((byte)message.length());
            buff.appendString(message);
            sock.write(buff);
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocketStream(8080, "localhost", path).exceptionHandler(t -> this.fail(t.getMessage())).handler(ws -> ws.handler(buff -> {
                this.assertEquals(message, buff.toString("UTF-8"));
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        int numServers = 5;
        int numConnections = numServers * 100;
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        ConcurrentHashSet connectedServers = new ConcurrentHashSet();
        ConcurrentHashMap connectCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numConnections);
        for (int i = 0; i < numServers; ++i) {
            HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
            servers.add(theServer);
            theServer.websocketHandler(arg_0 -> WebsocketTest.lambda$testSharedServersRoundRobin$295((Set)connectedServers, theServer, connectCount, latchConns, arg_0)).listen(ar -> {
                if (ar.succeeded()) {
                    latchListen.countDown();
                } else {
                    this.fail("Failed to bind server");
                }
            });
        }
        this.assertTrue(latchListen.await(10L, TimeUnit.SECONDS));
        CountDownLatch latchClient = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.websocket(8080, "localhost", "/someuri", ws -> {
                ws.closeHandler(v -> latchClient.countDown());
                ws.close();
            });
        }
        this.assertTrue(latchClient.await(10L, TimeUnit.SECONDS));
        this.assertTrue(latchConns.await(10L, TimeUnit.SECONDS));
        this.assertEquals(numServers, connectedServers.size());
        for (HttpServer server : servers) {
            this.assertTrue(connectedServers.contains(server));
        }
        this.assertEquals(numServers, connectCount.size());
        Iterator<Object> i = connectCount.values().iterator();
        while (i.hasNext()) {
            int cnt = (Integer)i.next();
            this.assertEquals(numConnections / numServers, cnt);
        }
        CountDownLatch closeLatch = new CountDownLatch(numServers);
        for (HttpServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                closeLatch.countDown();
            });
        }
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(4321));
        theServer.websocketHandler(ws -> this.fail("Should not connect")).listen(ar -> {
            if (ar.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpServer theServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(4321));
        theServer.websocketHandler(ws -> this.fail("Should not connect")).listen(ar -> {
            if (ar.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        theServer.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testWebsocketFrameFactoryArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> WebSocketFrame.binaryFrame(null, (boolean)true));
        TestUtils.assertNullPointerException(() -> WebSocketFrame.textFrame(null, (boolean)true));
        TestUtils.assertNullPointerException(() -> WebSocketFrame.continuationFrame(null, (boolean)true));
    }

    private String sha1(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] bytes = md.digest(s.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new InternalError("Failed to compute sha-1");
        }
    }

    private NetSocket getUpgradedNetSocket(HttpServerRequest req, String path) {
        this.assertEquals(path, req.path());
        this.assertEquals("Upgrade", req.headers().get("Connection"));
        NetSocket sock = req.netSocket();
        String secHeader = req.headers().get("Sec-WebSocket-Key");
        String tmp = secHeader + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        String encoded = this.sha1(tmp);
        sock.write("HTTP/1.1 101 Web Socket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: " + encoded + "\r\n" + "\r\n");
        return sock;
    }

    private void testWSWriteStream(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        String query = "foo=bar&wibble=eek";
        String uri = path + "?" + query;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(ws -> {
            this.assertEquals(uri, ws.uri());
            this.assertEquals(path, ws.path());
            this.assertEquals(query, ws.query());
            this.assertEquals("Upgrade", ws.headers().get("Connection"));
            ws.handler(data -> ws.write(data));
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            int bsize = 100;
            int sends = 10;
            this.client.websocket(8080, "localhost", path + "?" + query, null, version, ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == bsize * sends) {
                        ws.close();
                        this.testComplete();
                    }
                });
                Buffer sent = Buffer.buffer();
                for (int i = 0; i < sends; ++i) {
                    Buffer buff = Buffer.buffer((byte[])TestUtils.randomByteArray(bsize));
                    ws.write(buff);
                    sent.appendBuffer(buff);
                }
            });
        });
        this.await();
    }

    private void testWSFrames(boolean binary, WebsocketVersion version) throws Exception {
        String path = "/some/path";
        String query = "foo=bar&wibble=eek";
        String uri = path + "?" + query;
        int frames = version == WebsocketVersion.V00 ? 1 : 10;
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(ws -> {
            this.assertEquals(uri, ws.uri());
            this.assertEquals(path, ws.path());
            this.assertEquals(query, ws.query());
            this.assertEquals("Upgrade", ws.headers().get("Connection"));
            AtomicInteger count = new AtomicInteger();
            ws.frameHandler(frame -> {
                if (count.get() == 0) {
                    if (binary) {
                        this.assertTrue(frame.isBinary());
                        this.assertFalse(frame.isText());
                    } else {
                        this.assertFalse(frame.isBinary());
                        this.assertTrue(frame.isText());
                    }
                    this.assertFalse(frame.isContinuation());
                } else {
                    this.assertFalse(frame.isBinary());
                    this.assertFalse(frame.isText());
                    this.assertTrue(frame.isContinuation());
                }
                if (count.get() == frames - 1) {
                    this.assertTrue(frame.isFinal());
                } else {
                    this.assertFalse(frame.isFinal());
                }
                ws.writeFrame(frame);
                if (count.incrementAndGet() == frames) {
                    count.set(0);
                }
            });
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            int bsize = 100;
            int msgs = 10;
            this.client.websocket(8080, "localhost", path + "?" + query, null, version, ws -> {
                ArrayList<Buffer> sent = new ArrayList<Buffer>();
                ArrayList received = new ArrayList();
                AtomicReference<Buffer> currentReceived = new AtomicReference<Buffer>(Buffer.buffer());
                ws.frameHandler(frame -> {
                    ((Buffer)currentReceived.get()).appendBuffer(frame.binaryData());
                    if (frame.isFinal()) {
                        received.add(currentReceived.get());
                        currentReceived.set(Buffer.buffer());
                    }
                    if (received.size() == msgs) {
                        int pos = 0;
                        for (Buffer rec : received) {
                            this.assertEquals(rec, sent.get(pos++));
                        }
                        this.testComplete();
                    }
                });
                AtomicReference<Buffer> currentSent = new AtomicReference<Buffer>(Buffer.buffer());
                for (int i = 0; i < msgs; ++i) {
                    for (int j = 0; j < frames; ++j) {
                        WebSocketFrame frame2;
                        Buffer buff;
                        if (binary) {
                            buff = Buffer.buffer((byte[])TestUtils.randomByteArray(bsize));
                            frame2 = j == 0 ? WebSocketFrame.binaryFrame((Buffer)buff, (boolean)false) : WebSocketFrame.continuationFrame((Buffer)buff, (j == frames - 1 ? 1 : 0) != 0);
                        } else {
                            String str = TestUtils.randomAlphaString(bsize);
                            buff = Buffer.buffer((String)str);
                            frame2 = j == 0 ? WebSocketFrame.textFrame((String)str, (boolean)false) : WebSocketFrame.continuationFrame((Buffer)buff, (j == frames - 1 ? 1 : 0) != 0);
                        }
                        currentSent.get().appendBuffer(buff);
                        ws.writeFrame(frame2);
                        if (j != frames - 1) continue;
                        sent.add(currentSent.get());
                        currentSent.set(Buffer.buffer());
                    }
                }
            });
        });
        this.await();
    }

    @Test
    public void testWriteFinalTextFrame() throws Exception {
        this.testWriteFinalFrame(false);
    }

    @Test
    public void testWriteFinalBinaryFrame() throws Exception {
        this.testWriteFinalFrame(true);
    }

    private void testWriteFinalFrame(boolean binary) throws Exception {
        String text = TestUtils.randomUnicodeString(100);
        Buffer data = TestUtils.randomBuffer(100);
        Consumer<WebSocketFrame> frameConsumer = frame -> {
            if (binary) {
                this.assertTrue(frame.isBinary());
                this.assertFalse(frame.isText());
                this.assertEquals(data, frame.binaryData());
            } else {
                this.assertFalse(frame.isBinary());
                this.assertTrue(frame.isText());
                this.assertEquals(text, frame.textData());
            }
            this.assertTrue(frame.isFinal());
        };
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(ws -> ws.frameHandler(frame -> {
            frameConsumer.accept((WebSocketFrame)frame);
            if (binary) {
                ws.writeFinalBinaryFrame(frame.binaryData());
            } else {
                ws.writeFinalTextFrame(frame.textData());
            }
        }));
        this.server.listen(this.onSuccess(s -> this.client.websocket(8080, "localhost", "/", ws -> {
            ws.frameHandler(frame -> {
                frameConsumer.accept((WebSocketFrame)frame);
                this.testComplete();
            });
            if (binary) {
                ws.writeFinalBinaryFrame(data);
            } else {
                ws.writeFinalTextFrame(text);
            }
        })));
        this.await();
    }

    private void testContinuationWriteFromConnectHandler(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        String firstFrame = "AAA";
        String continuationFrame = "BBB";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> {
            NetSocket sock = this.getUpgradedNetSocket((HttpServerRequest)req, path);
            Buffer buff = Buffer.buffer();
            buff.appendByte((byte)1);
            buff.appendByte((byte)firstFrame.length());
            buff.appendString(firstFrame);
            sock.write(buff);
            buff = Buffer.buffer();
            buff.appendByte((byte)-128);
            buff.appendByte((byte)continuationFrame.length());
            buff.appendString(continuationFrame);
            sock.write(buff);
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocket(8080, "localhost", path, null, version, ws -> {
                AtomicBoolean receivedFirstFrame = new AtomicBoolean();
                ws.frameHandler(received -> {
                    Buffer receivedBuffer = Buffer.buffer((String)received.textData());
                    if (!received.isFinal()) {
                        this.assertEquals(firstFrame, receivedBuffer.toString());
                        receivedFirstFrame.set(true);
                    } else if (receivedFirstFrame.get() && received.isFinal()) {
                        this.assertEquals(continuationFrame, receivedBuffer.toString());
                        ws.close();
                        this.testComplete();
                    }
                });
            });
        });
        this.await();
    }

    private void testWriteFromConnectHandler(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocket(8080, "localhost", path, null, version, ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == buff.length()) {
                        this.assertEquals(buff, received);
                        ws.close();
                        this.testComplete();
                    }
                });
            });
        });
        this.await();
    }

    private void testValidSubProtocol(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        String subProtocol = "myprotocol";
        Buffer buff = Buffer.buffer((String)"AAA");
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setWebsocketSubProtocol(subProtocol)).websocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buff, (boolean)true));
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocket(8080, "localhost", path, null, version, subProtocol, ws -> {
                Buffer received = Buffer.buffer();
                ws.handler(data -> {
                    received.appendBuffer(data);
                    if (received.length() == buff.length()) {
                        this.assertEquals(buff, received);
                        ws.close();
                        this.testComplete();
                    }
                });
            });
        });
        this.await();
    }

    private void testInvalidSubProtocol(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        String subProtocol = "myprotocol";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setWebsocketSubProtocol("invalid")).websocketHandler(ws -> {});
        this.server.listen(this.onSuccess(ar -> this.client.websocketStream(8080, "localhost", path, null, version, subProtocol).exceptionHandler(t -> this.testComplete()).handler(ws -> {})));
        this.await();
    }

    private void testReject(WebsocketVersion version) throws Exception {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(ws -> {
            this.assertEquals(path, ws.path());
            ws.reject();
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocketStream(8080, "localhost", path, null, version).exceptionHandler(t -> this.testComplete()).handler(ws -> this.fail("Should not be called"));
        });
        this.await();
    }

    @Test
    public void testWriteMessageHybi00() {
        this.testWriteMessage(256, WebsocketVersion.V00);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi00() {
        this.testWriteMessage(65792, WebsocketVersion.V00);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi00() {
        this.testWriteMessage(131328, WebsocketVersion.V00);
    }

    @Test
    public void testWriteMessageHybi08() {
        this.testWriteMessage(256, WebsocketVersion.V08);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi08() {
        this.testWriteMessage(65792, WebsocketVersion.V08);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi08() {
        this.testWriteMessage(131328, WebsocketVersion.V08);
    }

    @Test
    public void testWriteMessageHybi17() {
        this.testWriteMessage(256, WebsocketVersion.V13);
    }

    @Test
    public void testWriteFragmentedMessage1Hybi17() {
        this.testWriteMessage(65792, WebsocketVersion.V13);
    }

    @Test
    public void testWriteFragmentedMessage2Hybi17() {
        this.testWriteMessage(131328, WebsocketVersion.V13);
    }

    private void testWriteMessage(int size, WebsocketVersion version) {
        String path = "/some/path";
        byte[] expected = TestUtils.randomByteArray(size);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(ws -> {
            ws.writeBinaryMessage(Buffer.buffer((byte[])expected));
            ws.close();
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocket(8080, "localhost", path, null, version, ws -> {
                Buffer actual = Buffer.buffer();
                ws.handler(arg_0 -> ((Buffer)actual).appendBuffer(arg_0));
                ws.closeHandler(v -> {
                    this.assertArrayEquals(expected, actual.getBytes());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testWebsocketPauseAndResume() {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setConnectTimeout(1000));
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setAcceptBacklog(1).setPort(8080));
        AtomicBoolean paused = new AtomicBoolean();
        ServerWebSocketStream stream = this.server.websocketStream();
        stream.handler(ws -> {
            this.assertFalse(paused.get());
            ws.writeBinaryMessage(Buffer.buffer((String)"whatever"));
            ws.close();
        });
        this.server.listen(arg_0 -> this.lambda$testWebsocketPauseAndResume$354((ReadStream)stream, paused, path, arg_0));
        this.await();
    }

    @Test
    public void testClosingServerClosesWebSocketStreamEndHandler() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        ServerWebSocketStream stream = this.server.websocketStream();
        AtomicBoolean closed = new AtomicBoolean();
        stream.endHandler(v -> closed.set(true));
        stream.handler(ws -> {});
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertFalse(closed.get());
            this.server.close(v -> {
                this.assertTrue(ar.succeeded());
                this.assertTrue(closed.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWebsocketStreamCallbackAsynchronously() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger done = new AtomicInteger();
        ServerWebSocketStream stream = this.server.websocketStream();
        stream.handler(req -> {});
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            if (done.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.server.listen(ar -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            ThreadLocal<Boolean> stack2 = new ThreadLocal<Boolean>();
            stack2.set(true);
            this.server.close(v -> {
                this.assertTrue(Vertx.currentContext().isEventLoopContext());
                this.assertNull(stack2.get());
                if (done.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
            stack2.set(null);
        });
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.websocketStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testEndHandlerCalled() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(WebSocketBase::close);
        AtomicInteger doneCount = new AtomicInteger();
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocketStream(8080, "localhost", path, null).endHandler(done -> doneCount.incrementAndGet()).handler(ws -> {
                this.assertEquals(0L, doneCount.get());
                ws.closeHandler(v -> {
                    this.assertEquals(1L, doneCount.get());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testClearClientHandlersOnEnd() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).websocketHandler(WebSocketBase::close);
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocketStream(8080, "localhost", path, null).handler(ws -> ws.endHandler(v -> {
                try {
                    ws.endHandler(null);
                    ws.exceptionHandler(null);
                    ws.handler(null);
                }
                catch (Exception e) {
                    this.fail("Was expecting to set to null the handlers when the socket is closed");
                    return;
                }
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testUpgrade() {
        this.testUpgrade(false);
    }

    @Test
    public void testUpgradeDelayed() {
        this.testUpgrade(true);
    }

    private void testUpgrade(boolean delayed) {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(request -> {
            Runnable runner = () -> {
                ServerWebSocket ws = request.upgrade();
                ws.handler(buff -> {
                    ws.write(Buffer.buffer((String)"helloworld"));
                    ws.close();
                });
            };
            if (delayed) {
                this.vertx.runOnContext(v -> runner.run());
            } else {
                runner.run();
            }
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.websocketStream(8080, "localhost", path, null).handler(ws -> {
                Buffer buff = Buffer.buffer();
                ws.handler(b -> buff.appendBuffer(b));
                ws.endHandler(v -> {
                    this.assertEquals("helloworld", buff.toString());
                    this.testComplete();
                });
                ws.write(Buffer.buffer((String)"foo"));
            });
        });
        this.await();
    }

    @Test
    public void testUpgradeInvalidRequest() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(request -> {
            try {
                request.upgrade();
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.testComplete();
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.request(HttpMethod.GET, 8080, "localhost", "/", resp -> {}).end();
        });
        this.await();
    }

    @Test
    public void testRaceConditionWithWebsocketClientEventLoop() {
        this.testRaceConditionWithWebsocketClient(this.vertx.getOrCreateContext());
    }

    @Test
    public void testRaceConditionWithWebsocketClientWorker() throws Exception {
        final CompletableFuture fut = new CompletableFuture();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                fut.complete(this.context);
            }
        }, new DeploymentOptions().setWorker(true), ar -> {
            if (ar.failed()) {
                fut.completeExceptionally(ar.cause());
            }
        });
        this.testRaceConditionWithWebsocketClient((Context)fut.get());
    }

    private void testRaceConditionWithWebsocketClient(Context context) {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.requestHandler(req -> {
            byte[] accept;
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                byte[] inputBytes = (req.getHeader("Sec-WebSocket-Key") + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes();
                digest.update(inputBytes);
                byte[] hashedBytes = digest.digest();
                accept = Base64.getEncoder().encode(hashedBytes);
            }
            catch (NoSuchAlgorithmException e) {
                this.fail(e.getMessage());
                return;
            }
            NetSocket so = req.netSocket();
            Buffer data = Buffer.buffer();
            data.appendString("HTTP/1.1 101 Switching Protocols\r\n");
            data.appendString("Upgrade: websocket\r\n");
            data.appendString("Connection: Upgrade\r\n");
            data.appendString("Sec-WebSocket-Accept: " + new String(accept) + "\r\n");
            data.appendString("\r\n");
            data.appendBytes(new byte[]{-126, 5, 104, 101, 108, 108, 111});
            so.write(data);
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            context.runOnContext(v -> this.client.websocket(8080, "localhost", "/", ws -> ws.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            })));
        });
        this.await();
    }

    @Test
    public void testRaceConditionWithWebsocketClientWorker2() throws Exception {
        int size = this.getOptions().getWorkerPoolSize() - 4;
        List<Context> workers = this.createWorkers(size + 1);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.server.websocketHandler(ws -> ws.write(Buffer.buffer((String)"hello")));
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            ((Context)workers.get(0)).runOnContext(v -> {
                WebSocketStream webSocketStream = this.client.websocketStream(8080, "localhost", "/");
                webSocketStream.handler(ws -> ws.handler(buf -> {
                    this.assertEquals("hello", buf.toString());
                    this.testComplete();
                }));
            });
        });
        this.await();
    }

    private /* synthetic */ void lambda$testWebsocketPauseAndResume$354(ReadStream readStream, AtomicBoolean atomicBoolean, String string, AsyncResult listenAR) {
        this.assertTrue(listenAR.succeeded());
        readStream.pause();
        atomicBoolean.set(true);
        this.client.websocketStream(8080, "localhost", string).exceptionHandler(err -> {
            this.assertTrue(atomicBoolean.get());
            this.assertTrue(err instanceof WebSocketHandshakeException);
            atomicBoolean.set(false);
            readStream.resume();
            this.client.websocket(8080, "localhost", string, ws -> ws.handler(buffer -> {
                this.assertEquals("whatever", buffer.toString("UTF-8"));
                ws.closeHandler(v2 -> this.testComplete());
            }));
        }).handler(ws -> this.fail());
    }

    private static /* synthetic */ void lambda$testSharedServersRoundRobin$295(Set set, HttpServer httpServer, Map map, CountDownLatch countDownLatch, ServerWebSocket ws) {
        set.add(httpServer);
        Integer cnt = (Integer)map.get(httpServer);
        int icnt = cnt == null ? 0 : cnt;
        map.put(httpServer, ++icnt);
        countDownLatch.countDown();
    }
}

