/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FakeHttpClientMetrics
extends FakeMetricsBase
implements HttpClientMetrics<HttpClientMetric, WebSocketMetric, SocketMetric> {
    private final ConcurrentMap<WebSocketBase, WebSocketMetric> webSockets = new ConcurrentHashMap<WebSocketBase, WebSocketMetric>();
    private final ConcurrentMap<HttpClientRequest, HttpClientMetric> requests = new ConcurrentHashMap<HttpClientRequest, HttpClientMetric>();

    public WebSocketMetric getMetric(WebSocket ws) {
        return (WebSocketMetric)this.webSockets.get(ws);
    }

    public HttpClientMetric getMetric(HttpClientRequest request) {
        return (HttpClientMetric)this.requests.get(request);
    }

    public FakeHttpClientMetrics(HttpClient measured) {
        super((Measured)measured);
    }

    public WebSocketMetric connected(SocketMetric socketMetric, WebSocket webSocket) {
        WebSocketMetric metric = new WebSocketMetric(socketMetric, (WebSocketBase)webSocket);
        this.webSockets.put((WebSocketBase)webSocket, metric);
        return metric;
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.webSockets.remove(webSocketMetric.ws);
    }

    public HttpClientMetric requestBegin(SocketMetric socketMetric, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        HttpClientMetric metric = new HttpClientMetric(request, socketMetric);
        this.requests.put(request, metric);
        return metric;
    }

    public void responseEnd(HttpClientMetric requestMetric, HttpClientResponse response) {
        this.requests.remove(requestMetric.request);
    }

    public SocketMetric connected(SocketAddress remoteAddress) {
        return new SocketMetric(remoteAddress);
    }

    public void disconnected(SocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.connected.set(false);
    }

    public void bytesRead(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesRead.addAndGet(numberOfBytes);
    }

    public void bytesWritten(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesWritten.addAndGet(numberOfBytes);
    }

    public void exceptionOccurred(SocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
    }
}

