/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.MissingOptionException;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.TypedArgument;
import io.vertx.core.cli.TypedOption;
import io.vertx.core.cli.impl.DefaultCLI;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class DefaultParserTest {
    private CLI cli;

    @Before
    public void setUp() {
        this.cli = new DefaultCLI().setName("test");
    }

    @Test
    public void testWithOneLongOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Collections.singletonList("--file=hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
        StringBuilder usage = new StringBuilder();
        this.cli.usage(usage);
        Assertions.assertThat((CharSequence)usage).startsWith((CharSequence)"Usage: test [-f <value>]");
        Assertions.assertThat((CharSequence)usage).contains(new CharSequence[]{"-f,--file <value>"});
    }

    @Test
    public void testWithOneLongOptionUsingSpace() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("--file", "hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
        StringBuilder usage = new StringBuilder();
        this.cli.usage(usage);
        Assertions.assertThat((CharSequence)usage).startsWith((CharSequence)"Usage: test [-f <value>]");
    }

    @Test
    public void testWithOneShortOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Collections.singletonList("-f=hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
    }

    @Test
    public void testWithOneShortOptionUsingSpace() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-f", "hello.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
    }

    @Test
    public void testTheDifferentFormatForLongOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("--file", "hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("--file=hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("-filehello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Arrays.asList("--FILE", "hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
    }

    @Test
    public void testTheDifferentFormatForShortOption() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-f", "hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("-f=hello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        evaluated = this.cli.parse(Collections.singletonList("-fhello.txt"));
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
    }

    @Test
    public void testWithMultipleValues() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setMultiValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-f=hello.txt", "--file=hello2.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt", "hello2.txt"});
    }

    @Test
    public void testWithList() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("file").setParsedAsList(true).setType(String.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Collections.singletonList("-f=hello.txt,hello2.txt"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt,hello2.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt", "hello2.txt"});
    }

    @Test
    public void testWithFlag() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setType(Boolean.TYPE).setShortName("f").setLongName("flag").setFlag(true).setSingleValued(true), new TypedOption().setType(Boolean.TYPE).setShortName("f2").setLongName("flag2").setFlag(true).setSingleValued(true), new TypedOption().setType(Boolean.TYPE).setShortName("f3").setLongName("flag3").setFlag(true)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("--flag", "--flag2", "--flag3"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(true);
        evaluated = cli.parse(Arrays.asList("--flag=true", "--flag2=false", "--flag3"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(false);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(true);
        evaluated = cli.parse(Arrays.asList("--flag", "--flag2"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(false);
        evaluated = cli.parse(Arrays.asList("--flag", "true", "--flag2", "false", "--flag3"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isEqualTo(true);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag2"))).isEqualTo(false);
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag3"))).isEqualTo(true);
    }

    @Test
    public void testArguments() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("org.acme.Foo", "-f=no"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"org.acme.Foo"});
        evaluated = this.cli.parse(Arrays.asList("-f=no", "org.acme.Foo"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"org.acme.Foo"});
        evaluated = this.cli.parse(Arrays.asList("-f=no", "org.acme.Foo", "bar"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"org.acme.Foo", "bar"});
    }

    @Test
    public void testUnknownOption() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setRequired(true).setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("-flag=true", "-unknown=x"));
        Assertions.assertThat((List)evaluated.allArguments()).contains((Object[])new String[]{"-unknown=x"});
    }

    @Test(expected=MissingOptionException.class)
    public void testNotFulfilledRequiredOptions() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setRequired(true).setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Collections.emptyList());
    }

    @Test
    public void testRequiredOptions() throws CLIException {
        Option[] options = new Option[]{new TypedOption().setShortName("f").setLongName("flag").setType(Boolean.class).setRequired(true).setFlag(true)};
        this.cli.addOptions(Arrays.asList(options));
        this.cli.parse(Collections.singletonList("-f"));
    }

    @Test
    public void testQuotedValues() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = this.cli.parse(Arrays.asList("--file", "\"hello.txt\""));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)evaluated.getOptionValue("file"))).isEqualTo((Object)"hello.txt");
        Assertions.assertThat((List)evaluated.getOptionValues("f")).containsExactly(new Object[]{"hello.txt"});
    }

    @Test
    public void testNegativeNumbers() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setLongName("num").setSingleValued(true).setType(Double.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("--num", "-1.5"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((List)cli.getArguments()).isEmpty();
        Assertions.assertThat((double)((Double)evaluated.getOptionValue("num"))).isEqualTo(-1.5);
        evaluated = cli.parse(Collections.singletonList("--num=-1.5"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(1);
        Assertions.assertThat((List)cli.getArguments()).isEmpty();
        Assertions.assertThat((double)((Double)evaluated.getOptionValue("num"))).isEqualTo(-1.5);
    }

    @Test(expected=MissingValueException.class)
    public void testMissingValue() throws CLIException {
        Option[] options = new Option[]{new Option().setShortName("f").setLongName("file").setSingleValued(true)};
        this.cli.addOptions(Arrays.asList(options));
        this.cli.parse(Collections.singletonList("--file"));
    }

    @Test
    public void testVertxRun() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setLongName("conf").setType(String.class).setSingleValued(true), new TypedOption().setLongName("instances").setType(Integer.class).setSingleValued(true).setDefaultValue("1"), new TypedOption().setLongName("worker").setType(Boolean.class).setFlag(true), new TypedOption().setLongName("classpath").setShortName("cp").setListSeparator(File.pathSeparator).setType(String.class).setSingleValued(true), new TypedOption().setLongName("cluster").setType(Boolean.class).setFlag(true), new TypedOption().setLongName("cluster-port").setType(Integer.class).setSingleValued(true), new TypedOption().setLongName("cluster-host").setType(String.class).setSingleValued(true), new TypedOption().setLongName("ha").setType(Boolean.class).setFlag(true).setSingleValued(true), new TypedOption().setLongName("quorum").setType(Integer.class).setSingleValued(true), new TypedOption().setLongName("ha-group").setType(String.class).setDefaultValue("__DEFAULT__").setSingleValued(true)};
        cli.addOptions(Arrays.asList(options));
        cli.addArgument((Argument)new TypedArgument().setType(String.class).setArgName("verticle").setIndex(0).setRequired(false));
        CommandLine evaluated = cli.parse(Collections.singletonList("-ha"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isNull();
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isNull();
        evaluated = cli.parse(Arrays.asList("-ha", "true"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        evaluated = cli.parse(Collections.singletonList("-ha=true"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        evaluated = cli.parse(Collections.singletonList("--ha"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isTrue();
        evaluated = cli.parse(Arrays.asList("--ha", "false"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isFalse();
        evaluated = cli.parse(Collections.singletonList("--ha=no"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("ha"))).isFalse();
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-instances=4", "-cp", "." + File.pathSeparator + "my.jar"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        int instances = (Integer)evaluated.getOptionValue("instances");
        List classpath = evaluated.getOptionValues("classpath");
        Assertions.assertThat((int)instances).isEqualTo(4);
        Assertions.assertThat((List)classpath).containsExactly((Object[])new String[]{".", "my.jar"});
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "--cluster"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "-cluster-host", "127.0.0.1"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "--cluster-host", "127.0.0.1"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "-cluster-host=127.0.0.1"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        evaluated = cli.parse(Arrays.asList("org.acme.FooVerticle", "-cluster", "-cluster-host", "127.0.0.1", "-cluster-port", "1234"));
        ((AbstractListAssert)Assertions.assertThat((List)evaluated.allArguments()).hasSize(1)).containsExactly((Object[])new String[]{"org.acme.FooVerticle"});
        Assertions.assertThat((String)((String)evaluated.getArgumentValue("verticle"))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((String)((String)evaluated.getArgumentValue(0))).isEqualTo((Object)"org.acme.FooVerticle");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("cluster"))).isTrue();
        Assertions.assertThat((String)((String)evaluated.getOptionValue("cluster-host"))).isEqualTo((Object)"127.0.0.1");
        Assertions.assertThat((int)((Integer)evaluated.getOptionValue("cluster-port"))).isEqualTo(1234);
    }

    @Test
    public void testWithDashD() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setShortName("D").setLongName("systemProperty").setMultiValued(true).setType(String.class), new TypedOption().setShortName("F").setLongName("flag").setFlag(true).setType(Boolean.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("-Dx=y", "-F"));
        Assertions.assertThat((List)evaluated.cli().getOptions()).hasSize(2);
        Assertions.assertThat((String)evaluated.getRawValueForOption(evaluated.cli().getOption("systemProperty"))).isEqualTo((Object)"x=y");
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("flag"))).isTrue();
    }

    @Test
    public void testConcatenatedOptions() throws CLIException {
        CLI cli = new DefaultCLI().setName("test");
        Option[] options = new Option[]{new TypedOption().setShortName("d").setFlag(true).setType(Boolean.class), new TypedOption().setShortName("e").setFlag(true).setType(Boolean.class), new TypedOption().setShortName("f").setFlag(true).setType(Boolean.class)};
        cli.addOptions(Arrays.asList(options));
        CommandLine evaluated = cli.parse(Arrays.asList("-d", "-e", "-f"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("d"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("e"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("f"))).isTrue();
        evaluated = cli.parse(Collections.singletonList("-de"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("d"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("e"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("f"))).isFalse();
        evaluated = cli.parse(Collections.singletonList("-def"));
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("d"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("e"))).isTrue();
        Assertions.assertThat((boolean)((Boolean)evaluated.getOptionValue("f"))).isTrue();
    }
}

