/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.InvalidValueException;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.TypedArgument;
import io.vertx.core.cli.converters.Converter;
import io.vertx.core.cli.converters.Person4;
import io.vertx.core.cli.converters.Person4Converter;
import io.vertx.core.cli.impl.DefaultCLI;
import io.vertx.core.cli.impl.ReflectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class TypedArgumentTest {
    private CLI cli;
    private CommandLine evaluated;

    @Before
    public void setUp() {
        this.cli = new DefaultCLI().setName("test");
    }

    @Test(expected=CLIException.class)
    public void testThatArgumentWithTheSameIndexAreDetected() throws CLIException {
        this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setType(String.class));
        this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setType(String.class));
        this.evaluated = this.cli.parse(Arrays.asList("a", "b"));
    }

    @Test
    public void testThatMissingArgumentsAreDetected() throws CLIException {
        this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setType(String.class).setRequired(true));
        this.cli.addArgument((Argument)new TypedArgument().setIndex(1).setType(String.class).setRequired(true));
        try {
            this.evaluated = this.cli.parse(Collections.emptyList());
            Assertions.fail((String)"Missing Value Exception expected");
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        try {
            this.evaluated = this.cli.parse(Collections.singletonList("a"));
            Assertions.fail((String)"Missing Value Exception expected");
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        this.evaluated = this.cli.parse(Arrays.asList("a", "b"));
    }

    @Test
    public void testMixedOfRequiredAnOptionalArguments() throws CLIException {
        this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setType(String.class).setRequired(true));
        this.cli.addArgument((Argument)new TypedArgument().setIndex(1).setType(String.class).setRequired(false));
        try {
            this.evaluated = this.cli.parse(Collections.emptyList());
            Assertions.fail((String)"Missing Value Exception expected");
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        this.evaluated = this.cli.parse(Collections.singletonList("a"));
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue(0))).isEqualTo((Object)"a");
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue(1))).isNull();
        this.evaluated = this.cli.parse(Arrays.asList("a", "b"));
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue(0))).isEqualTo((Object)"a");
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue(1))).isEqualTo((Object)"b");
    }

    @Test
    public void testThatArgumentsAreOrdered() throws CLIException {
        this.cli.addArgument((Argument)new TypedArgument().setIndex(1).setArgName("1").setType(String.class));
        this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setArgName("2").setType(String.class));
        this.cli.addArgument((Argument)new TypedArgument().setIndex(2).setArgName("3").setType(String.class));
        Assertions.assertThat((List)this.cli.getArguments()).hasSize(3);
        Iterator iterator = this.cli.getArguments().iterator();
        Assertions.assertThat((String)((Argument)iterator.next()).getArgName()).isEqualTo((Object)"2");
        Assertions.assertThat((String)((Argument)iterator.next()).getArgName()).isEqualTo((Object)"1");
        Assertions.assertThat((String)((Argument)iterator.next()).getArgName()).isEqualTo((Object)"3");
        this.evaluated = this.cli.parse(Arrays.asList("a", "b", "c"));
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue("2"))).isEqualTo((Object)"a");
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue("1"))).isEqualTo((Object)"b");
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue("3"))).isEqualTo((Object)"c");
    }

    @Test
    public void testThatDefaultValuesAreHandled() throws CLIException {
        this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setArgName("1").setType(String.class).setDefaultValue("hello").setRequired(false));
        this.evaluated = this.cli.parse(Collections.singletonList("a"));
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue(0))).isEqualTo((Object)"a");
        this.evaluated = this.cli.parse(Collections.emptyList());
        Assertions.assertThat((String)((String)this.evaluated.getArgumentValue(0))).isEqualTo((Object)"hello");
    }

    @Test
    public void testThatInvalidValuesAreReported() throws CLIException {
        this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setArgName("1").setType(Integer.class));
        try {
            this.evaluated = this.cli.parse(Collections.singletonList("a"));
            this.evaluated.getArgumentValue(0);
            Assertions.fail((String)"Exception expected");
        }
        catch (CLIException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(InvalidValueException.class);
            InvalidValueException cause = (InvalidValueException)((Object)e);
            Assertions.assertThat((int)cause.getArgument().getIndex()).isEqualTo(0);
            Assertions.assertThat((String)cause.getArgument().getArgName()).isEqualTo((Object)"1");
            Assertions.assertThat((String)cause.getValue()).isEqualTo((Object)"a");
        }
    }

    @Test
    public void testThatInvalidValuesAsDefaultValueAreReported() throws CLIException {
        try {
            this.cli.addArgument((Argument)new TypedArgument().setIndex(0).setArgName("1").setType(Integer.class).setDefaultValue("a"));
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(InvalidValueException.class);
            InvalidValueException cause = (InvalidValueException)e.getCause();
            Assertions.assertThat((int)cause.getArgument().getIndex()).isEqualTo(0);
            Assertions.assertThat((String)cause.getArgument().getArgName()).isEqualTo((Object)"1");
            Assertions.assertThat((String)cause.getValue()).isEqualTo((Object)"a");
        }
    }

    @Test
    public void testThatConvertersAreHandled() throws CLIException {
        TypedArgument arg = new TypedArgument().setIndex(0).setArgName("person").setType(Person4.class).setConverter((Converter)ReflectionUtils.newInstance(Person4Converter.class)).setDefaultValue("Bill,Ballantine").setRequired(false);
        this.cli.addArgument((Argument)arg);
        this.evaluated = this.cli.parse(Collections.singletonList("Bob,Morane"));
        Person4 person = (Person4)this.evaluated.getArgumentValue("person");
        Assertions.assertThat((String)person.first).isEqualTo((Object)"Bob");
        Assertions.assertThat((String)person.last).isEqualTo((Object)"Morane");
        this.evaluated = this.cli.parse(Collections.emptyList());
        person = (Person4)this.evaluated.getArgumentValue("person");
        Assertions.assertThat((String)person.first).isEqualTo((Object)"Bill");
        Assertions.assertThat((String)person.last).isEqualTo((Object)"Ballantine");
    }
}

