/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher;

import io.vertx.core.cli.CLI;
import io.vertx.core.impl.launcher.ServiceCommandFactoryLoader;
import io.vertx.core.spi.launcher.CommandFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ServiceCommandLoaderTest {
    ServiceCommandFactoryLoader loader = new ServiceCommandFactoryLoader();

    @Test
    public void testLookup() throws Exception {
        Collection commands = this.loader.lookup();
        this.ensureCommand(commands, "Hello");
        this.ensureCommand(commands, "Bye");
    }

    private void ensureCommand(Collection<CommandFactory<?>> commands, String name) {
        ArrayList<CLI> clis = new ArrayList<CLI>();
        for (CommandFactory<?> command : commands) {
            CLI cli = command.define();
            clis.add(cli);
            if (!cli.getName().equalsIgnoreCase(name)) continue;
            return;
        }
        Assertions.fail((String)("Cannot find '" + name + "' in " + clis.stream().map(CLI::getName).collect(Collectors.toList())));
    }
}

