/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher;

import io.vertx.core.impl.launcher.VertxCommandLauncher;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class VertxCommandLineInterfaceTest {
    VertxCommandLauncher itf = new VertxCommandLauncher();
    private PrintStream out;

    @Before
    public void setUp() {
        this.out = System.out;
    }

    @After
    public void tearDown() {
        System.setOut(this.out);
    }

    @Test
    public void testUsage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("--help", new String[0]);
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"hello"}).contains(new CharSequence[]{"bye"}).doesNotContain((CharSequence)"hidden").contains(new CharSequence[]{"A command saying hello"});
    }

    @Test
    public void testUsageOnDifferentStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final PrintStream stream = new PrintStream(baos);
        this.itf = new VertxCommandLauncher(){

            public PrintStream getPrintStream() {
                return stream;
            }
        };
        this.itf.execute("--help", new String[0]);
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"hello"}).contains(new CharSequence[]{"bye"}).doesNotContain((CharSequence)"hidden").contains(new CharSequence[]{"A command saying hello"});
    }

    @Test
    public void testCommandUsageForHello() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("hello", new String[]{"--help"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"Usage: "}).contains(new CharSequence[]{"A command saying hello."}).contains(new CharSequence[]{"A simple command to wish you a good day."}).contains(new CharSequence[]{"-n,--name <name>"}).contains(new CharSequence[]{"your name"});
    }

    @Test
    public void testCommandUsageForGoodbye() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("bye", new String[]{"--help"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"A command saying goodbye."}).contains(new CharSequence[]{"-n <value>"});
    }

    @Test
    public void testCommandNotFound() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("missing", new String[0]);
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"The command", "missing", "See", "--help"});
        baos.reset();
        this.itf.execute("missing", new String[]{"--help"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"The command", "missing", "See", "--help"});
    }

    @Test
    public void testMissingValue() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("hello", new String[]{"-n"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"The option 'name' requires a value"});
    }

    @Test
    public void testMissingOption() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("hello", new String[0]);
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"The option", "name", "is required"});
    }

    @Test
    public void testInvalidValue() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("hidden", new String[]{"-n", "vert.x", "-c", "hello"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"The value 'hello' is not accepted by 'count'"});
    }

    @Test
    public void testComplexCommandUsage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("complex", new String[]{"-h"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"-o1 <opt>", " [-o2] "}).contains(new CharSequence[]{"arg1 [arg2]"}).contains(new CharSequence[]{"A command with options and arguments."}).contains(new CharSequence[]{"This is a complex command."}).contains(new CharSequence[]{"-o1,--option1 <opt>"}).contains(new CharSequence[]{"-o2,--option2"});
    }

    @Test
    public void testHiddenCommandUsage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("hidden", new String[]{"-h"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"-n <value>"}).doesNotContain((CharSequence)"-c ").doesNotContain((CharSequence)"count");
    }

    @Test
    public void testComplexCommandExecutions() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        this.itf.execute("complex", new String[]{"-option1=vertx", "-o2", "this is arg 1", "25"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"Option 1 : vertx"}).contains(new CharSequence[]{"Option 2 : true"}).contains(new CharSequence[]{"Arg 1 : this is arg 1"}).contains(new CharSequence[]{"Arg 2 : 25"});
        baos.reset();
        this.itf = new VertxCommandLauncher();
        this.itf.execute("complex", new String[]{"-option1=vertx", "this is arg 1"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"Option 1 : vertx"}).contains(new CharSequence[]{"Option 2 : false"}).contains(new CharSequence[]{"Arg 1 : this is arg 1"}).contains(new CharSequence[]{"Arg 2 : 0"});
        baos.reset();
        this.itf = new VertxCommandLauncher();
        this.itf.execute("complex", new String[]{"-option1=vertx", "this is arg 1", "24", "xxx", "yyy"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"Option 1 : vertx"}).contains(new CharSequence[]{"Option 2 : false"}).contains(new CharSequence[]{"Arg 1 : this is arg 1"}).contains(new CharSequence[]{"Arg 2 : 24"}).contains(new CharSequence[]{"xxx", "yyy"});
        baos.reset();
        this.itf = new VertxCommandLauncher();
        this.itf.execute("complex", new String[]{"this is arg 1", "24"});
        Assertions.assertThat((String)baos.toString()).doesNotContain((CharSequence)"Option 1 : vertx").doesNotContain((CharSequence)"Arg 1 : this is arg 1").contains(new CharSequence[]{"Usage"}).contains(new CharSequence[]{"The option", "is required"});
        baos.reset();
        this.itf = new VertxCommandLauncher();
        this.itf.execute("complex", new String[]{"-option1=vertx"});
        Assertions.assertThat((String)baos.toString()).doesNotContain((CharSequence)"Option 1 : vertx").contains(new CharSequence[]{"Usage"}).contains(new CharSequence[]{"The argument 'arg1' is required"});
    }

    @Test
    public void testUsingDifferentPrinter() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final PrintStream stream = new PrintStream(baos);
        this.itf = new VertxCommandLauncher(){

            public PrintStream getPrintStream() {
                return stream;
            }
        };
        this.itf.execute("complex", new String[]{"-option1=vertx", "-o2", "this is arg 1", "25"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"Option 1 : vertx"}).contains(new CharSequence[]{"Option 2 : true"}).contains(new CharSequence[]{"Arg 1 : this is arg 1"}).contains(new CharSequence[]{"Arg 2 : 25"});
        baos.reset();
        this.itf = new VertxCommandLauncher(){

            public PrintStream getPrintStream() {
                return stream;
            }
        };
        this.itf.execute("complex", new String[]{"-option1=vertx", "this is arg 1"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"Option 1 : vertx"}).contains(new CharSequence[]{"Option 2 : false"}).contains(new CharSequence[]{"Arg 1 : this is arg 1"}).contains(new CharSequence[]{"Arg 2 : 0"});
        baos.reset();
        this.itf = new VertxCommandLauncher(){

            public PrintStream getPrintStream() {
                return stream;
            }
        };
        this.itf.execute("complex", new String[]{"-option1=vertx", "this is arg 1", "24", "xxx", "yyy"});
        Assertions.assertThat((String)baos.toString()).contains(new CharSequence[]{"Option 1 : vertx"}).contains(new CharSequence[]{"Option 2 : false"}).contains(new CharSequence[]{"Arg 1 : this is arg 1"}).contains(new CharSequence[]{"Arg 2 : 24"}).contains(new CharSequence[]{"xxx", "yyy"});
        baos.reset();
        this.itf = new VertxCommandLauncher(){

            public PrintStream getPrintStream() {
                return stream;
            }
        };
        this.itf.execute("complex", new String[]{"this is arg 1", "24"});
        Assertions.assertThat((String)baos.toString()).doesNotContain((CharSequence)"Option 1 : vertx").doesNotContain((CharSequence)"Arg 1 : this is arg 1").contains(new CharSequence[]{"Usage"}).contains(new CharSequence[]{"The option", "is required"});
        baos.reset();
        this.itf = new VertxCommandLauncher(){

            public PrintStream getPrintStream() {
                return stream;
            }
        };
        this.itf.execute("complex", new String[]{"-option1=vertx"});
        Assertions.assertThat((String)baos.toString()).doesNotContain((CharSequence)"Option 1 : vertx").contains(new CharSequence[]{"Usage"}).contains(new CharSequence[]{"The argument 'arg1' is required"});
    }
}

