/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.Launcher;
import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.core.impl.launcher.commands.HttpTestVerticle;
import io.vertx.core.impl.launcher.commands.RunCommandTest;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class StartStopListCommandsTest
extends CommandTestBase {
    @Override
    @Before
    public void setUp() throws IOException {
        File manifest = new File("target/test-classes/META-INF/MANIFEST.MF");
        if (manifest.isFile()) {
            manifest.delete();
        }
        super.setUp();
    }

    @Test
    public void testStartListStop() throws InterruptedException {
        this.record();
        this.cli.dispatch(new String[]{"start", "run", HttpTestVerticle.class.getName(), "--launcher-class", Launcher.class.getName()});
        this.waitForStartup();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Starting vert.x application"});
        this.output.reset();
        this.cli.dispatch(new String[]{"list"});
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2);
        String[] lines = this.output.toString().split(System.lineSeparator());
        String id = lines[1];
        this.output.reset();
        this.cli.dispatch(new String[]{"stop", id});
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Stopping vert.x application '" + id + "'"}).contains(new CharSequence[]{"Application '" + id + "' stopped"});
        this.waitForShutdown();
        this.waitUntil(() -> {
            this.output.reset();
            this.cli.dispatch(new String[]{"list"});
            return !this.output.toString().contains(id);
        });
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"No vert.x application found"});
    }

    @Test
    public void testStartListStopWithJVMOptions() throws InterruptedException, IOException {
        this.record();
        this.cli.dispatch(new String[]{"start", "run", HttpTestVerticle.class.getName(), "--launcher-class", Launcher.class.getName(), "--java-opts=-Dfoo=bar -Dbaz=bar", "--redirect-output"});
        this.waitForStartup();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Starting vert.x application"});
        JsonObject content = RunCommandTest.getContent();
        Assertions.assertThat((String)content.getString("foo")).isEqualToIgnoringCase((CharSequence)"bar");
        Assertions.assertThat((String)content.getString("baz")).isEqualToIgnoringCase((CharSequence)"bar");
        this.output.reset();
        this.cli.dispatch(new String[]{"list"});
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2);
        String[] lines = this.output.toString().split(System.lineSeparator());
        String id = lines[1];
        this.output.reset();
        this.cli.dispatch(new String[]{"stop", id});
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Stopping vert.x application '" + id + "'"}).contains(new CharSequence[]{"Application '" + id + "' stopped"});
        this.waitForShutdown();
        this.waitUntil(() -> {
            this.output.reset();
            this.cli.dispatch(new String[]{"list"});
            return !this.output.toString().contains(id);
        });
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"No vert.x application found"});
    }

    private void waitForShutdown() {
        this.waitUntil(() -> {
            try {
                this.getHttpCode();
            }
            catch (IOException e) {
                return true;
            }
            return false;
        });
    }

    private void waitForStartup() {
        this.waitUntil(() -> {
            try {
                return this.getHttpCode() == 200;
            }
            catch (IOException iOException) {
                return false;
            }
        });
    }

    @Test
    public void testStartListStopWithId() throws InterruptedException, IOException {
        this.record();
        this.cli.dispatch(new String[]{"start", "run", HttpTestVerticle.class.getName(), "--launcher-class", Launcher.class.getName(), "--vertx-id=hello"});
        this.waitForStartup();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Starting vert.x application"}).contains(new CharSequence[]{"hello"});
        this.output.reset();
        this.cli.dispatch(new String[]{"list"});
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"hello"});
        String[] lines = this.output.toString().split(System.lineSeparator());
        String id = lines[1];
        Assertions.assertThat((String)id).isEqualToIgnoringCase((CharSequence)"hello");
        this.output.reset();
        this.cli.dispatch(new String[]{"stop", id});
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Stopping vert.x application '" + id + "'"}).contains(new CharSequence[]{"Application '" + id + "' stopped"});
        this.waitForShutdown();
        this.waitUntil(() -> {
            this.output.reset();
            this.cli.dispatch(new String[]{"list"});
            return !this.output.toString().contains(id);
        });
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"No vert.x application found"});
    }

    @Test
    public void testStartListStopWithIdAndAnotherArgument() throws InterruptedException, IOException {
        this.record();
        this.cli.dispatch(new String[]{"start", "run", HttpTestVerticle.class.getName(), "--launcher-class", Launcher.class.getName(), "--vertx-id=hello", "-cluster"});
        this.waitForStartup();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Starting vert.x application"}).contains(new CharSequence[]{"hello"});
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isTrue();
        this.output.reset();
        this.cli.dispatch(new String[]{"list"});
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"hello"});
        String[] lines = this.output.toString().split(System.lineSeparator());
        String id = lines[1];
        Assertions.assertThat((String)id).isEqualToIgnoringCase((CharSequence)"hello");
        this.output.reset();
        this.cli.dispatch(new String[]{"stop", id});
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Stopping vert.x application '" + id + "'"}).contains(new CharSequence[]{"Application '" + id + "' stopped"});
        this.waitForShutdown();
        this.waitUntil(() -> {
            this.output.reset();
            this.cli.dispatch(new String[]{"list"});
            return !this.output.toString().contains(id);
        });
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"No vert.x application found"});
    }

    @Test
    public void testStartListStopWithIdAndAnotherArgumentBeforeId() throws InterruptedException, IOException {
        this.record();
        this.cli.dispatch(new String[]{"start", "run", HttpTestVerticle.class.getName(), "--launcher-class", Launcher.class.getName(), "-cluster", "--vertx-id=hello"});
        this.waitForStartup();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Starting vert.x application"}).contains(new CharSequence[]{"hello"});
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isTrue();
        this.output.reset();
        this.cli.dispatch(new String[]{"list"});
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"hello"});
        String[] lines = this.output.toString().split(System.lineSeparator());
        String id = lines[1];
        Assertions.assertThat((String)id).isEqualToIgnoringCase((CharSequence)"hello");
        this.output.reset();
        this.cli.dispatch(new String[]{"stop", id});
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Stopping vert.x application '" + id + "'"}).contains(new CharSequence[]{"Application '" + id + "' stopped"});
        this.waitForShutdown();
        this.waitUntil(() -> {
            this.output.reset();
            this.cli.dispatch(new String[]{"list"});
            return !this.output.toString().contains(id);
        });
        Assertions.assertThat((String)this.output.toString()).hasLineCount(2).contains(new CharSequence[]{"No vert.x application found"});
    }

    private int getHttpCode() throws IOException {
        return ((HttpURLConnection)new URL("http://localhost:8080").openConnection()).getResponseCode();
    }
}

