/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.KeyCert;
import io.vertx.test.core.RepeatRule;
import io.vertx.test.core.Trust;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;

public class VertxTestBase
extends AsyncTestBase {
    private static final Logger log = LoggerFactory.getLogger(VertxTestBase.class);
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    protected Vertx vertx;
    protected Vertx[] vertices;
    protected static final String[] ENABLED_CIPHER_SUITES = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_MD5", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV", "TLS_DH_anon_WITH_AES_128_GCM_SHA256", "TLS_DH_anon_WITH_AES_128_CBC_SHA256", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_anon_WITH_RC4_128_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_NULL_SHA256", "TLS_ECDHE_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_SHA", "TLS_ECDH_ECDSA_WITH_NULL_SHA", "TLS_ECDH_RSA_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", "TLS_KRB5_WITH_DES_CBC_SHA", "TLS_KRB5_WITH_DES_CBC_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5"};

    protected void vinit() {
        this.vertx = null;
        this.vertices = null;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vinit();
        this.vertx = Vertx.vertx((VertxOptions)this.getOptions());
    }

    protected VertxOptions getOptions() {
        return new VertxOptions();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.vertx != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.vertx.close(ar -> latch.countDown());
            this.awaitLatch(latch);
        }
        if (this.vertices != null) {
            int numVertices = 0;
            for (int i = 0; i < this.vertices.length; ++i) {
                if (this.vertices[i] == null) continue;
                ++numVertices;
            }
            CountDownLatch latch = new CountDownLatch(numVertices);
            for (Vertx vertx : this.vertices) {
                if (vertx == null) continue;
                vertx.close(ar -> {
                    if (ar.failed()) {
                        log.error((Object)"Failed to shutdown vert.x", ar.cause());
                    }
                    latch.countDown();
                });
            }
            this.assertTrue(latch.await(180L, TimeUnit.SECONDS));
        }
        FakeClusterManager.reset();
        super.tearDown();
    }

    protected ClusterManager getClusterManager() {
        return null;
    }

    protected void startNodes(int numNodes) {
        this.startNodes(numNodes, this.getOptions());
    }

    protected void startNodes(int numNodes, VertxOptions options) {
        CountDownLatch latch = new CountDownLatch(numNodes);
        this.vertices = new Vertx[numNodes];
        int i = 0;
        while (i < numNodes) {
            int index = i++;
            Vertx.clusteredVertx((VertxOptions)options.setClusterHost("localhost").setClusterPort(0).setClustered(true).setClusterManager(this.getClusterManager()), ar -> {
                if (ar.failed()) {
                    ar.cause().printStackTrace();
                }
                this.assertTrue("Failed to start node", ar.succeeded());
                this.vertices[index] = (Vertx)ar.result();
                latch.countDown();
            });
        }
        try {
            this.assertTrue(latch.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            this.fail(e.getMessage());
        }
    }

    protected String findFileOnClasspath(String fileName) {
        URL url = this.getClass().getClassLoader().getResource(fileName);
        if (url == null) {
            throw new IllegalArgumentException("Cannot find file " + fileName + " on classpath");
        }
        try {
            File file = new File(url.toURI());
            return file.getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new VertxException((Throwable)e);
        }
    }

    protected void setOptions(TCPSSLOptions sslOptions, KeyCertOptions options) {
        if (options instanceof JksOptions) {
            sslOptions.setKeyStoreOptions((JksOptions)options);
        } else if (options instanceof PfxOptions) {
            sslOptions.setPfxKeyCertOptions((PfxOptions)options);
        } else {
            sslOptions.setPemKeyCertOptions((PemKeyCertOptions)options);
        }
    }

    protected void setOptions(TCPSSLOptions sslOptions, TrustOptions options) {
        if (options instanceof JksOptions) {
            sslOptions.setTrustStoreOptions((JksOptions)options);
        } else if (options instanceof PfxOptions) {
            sslOptions.setPfxTrustOptions((PfxOptions)options);
        } else {
            sslOptions.setPemTrustOptions((PemTrustOptions)options);
        }
    }

    protected TrustOptions getClientTrustOptions(Trust trust) {
        switch (trust) {
            case JKS: {
                return new JksOptions().setPath(this.findFileOnClasspath("tls/client-truststore.jks")).setPassword("wibble");
            }
            case JKS_CA: {
                return new JksOptions().setPath(this.findFileOnClasspath("tls/client-truststore-ca.jks")).setPassword("wibble");
            }
            case PKCS12: {
                return new PfxOptions().setPath(this.findFileOnClasspath("tls/client-truststore.p12")).setPassword("wibble");
            }
            case PKCS12_CA: {
                return new PfxOptions().setPath(this.findFileOnClasspath("tls/client-truststore-ca.p12")).setPassword("wibble");
            }
            case PEM: {
                return new PemTrustOptions().addCertPath(this.findFileOnClasspath("tls/server-cert.pem"));
            }
            case PEM_CA: {
                return new PemTrustOptions().addCertPath(this.findFileOnClasspath("tls/ca/ca-cert.pem"));
            }
        }
        return null;
    }

    protected KeyCertOptions getClientCertOptions(KeyCert cert) {
        switch (cert) {
            case JKS: {
                return new JksOptions().setPath(this.findFileOnClasspath("tls/client-keystore.jks")).setPassword("wibble");
            }
            case JKS_CA: {
                throw new UnsupportedOperationException();
            }
            case PKCS12: {
                return new PfxOptions().setPath(this.findFileOnClasspath("tls/client-keystore.p12")).setPassword("wibble");
            }
            case PKCS12_CA: {
                throw new UnsupportedOperationException();
            }
            case PEM: {
                return new PemKeyCertOptions().setKeyPath(this.findFileOnClasspath("tls/client-key.pem")).setCertPath(this.findFileOnClasspath("tls/client-cert.pem"));
            }
            case PEM_CA: {
                return new PemKeyCertOptions().setKeyPath(this.findFileOnClasspath("tls/client-key.pem")).setCertPath(this.findFileOnClasspath("tls/client-cert-ca.pem"));
            }
        }
        return null;
    }

    protected TrustOptions getServerTrustOptions(Trust trust) {
        switch (trust) {
            case JKS: {
                return new JksOptions().setPath(this.findFileOnClasspath("tls/server-truststore.jks")).setPassword("wibble");
            }
            case JKS_CA: {
                throw new UnsupportedOperationException();
            }
            case PKCS12: {
                return new PfxOptions().setPath(this.findFileOnClasspath("tls/server-truststore.p12")).setPassword("wibble");
            }
            case PKCS12_CA: {
                throw new UnsupportedOperationException();
            }
            case PEM: {
                return new PemTrustOptions().addCertPath(this.findFileOnClasspath("tls/client-cert.pem"));
            }
            case PEM_CA: {
                return new PemTrustOptions().addCertPath(this.findFileOnClasspath("tls/ca/ca-cert.pem"));
            }
        }
        return null;
    }

    protected KeyCertOptions getServerCertOptions(KeyCert cert) {
        switch (cert) {
            case JKS: {
                return new JksOptions().setPath(this.findFileOnClasspath("tls/server-keystore.jks")).setPassword("wibble");
            }
            case JKS_CA: {
                return new JksOptions().setPath(this.findFileOnClasspath("tls/server-keystore-ca.jks")).setPassword("wibble");
            }
            case PKCS12: {
                return new PfxOptions().setPath(this.findFileOnClasspath("tls/server-keystore.p12")).setPassword("wibble");
            }
            case PKCS12_CA: {
                return new PfxOptions().setPath(this.findFileOnClasspath("tls/server-keystore-ca.p12")).setPassword("wibble");
            }
            case PEM: {
                return new PemKeyCertOptions().setKeyPath(this.findFileOnClasspath("tls/server-key.pem")).setCertPath(this.findFileOnClasspath("tls/server-cert.pem"));
            }
            case PEM_CA: {
                return new PemKeyCertOptions().setKeyPath(this.findFileOnClasspath("tls/server-key.pem")).setCertPath(this.findFileOnClasspath("tls/server-cert-ca.pem"));
            }
        }
        return null;
    }

    protected Context createWorker() throws Exception {
        final CompletableFuture fut = new CompletableFuture();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                fut.complete(this.context);
            }
        }, new DeploymentOptions().setWorker(true), ar -> {
            if (ar.failed()) {
                fut.completeExceptionally(ar.cause());
            }
        });
        return (Context)fut.get();
    }

    protected List<Context> createWorkers(int num) throws Exception {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (int i = 0; i < num; ++i) {
            contexts.add(this.createWorker());
        }
        return contexts;
    }
}

