/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.converters;

import io.vertx.core.cli.converters.Converters;
import io.vertx.core.cli.converters.Person2;
import io.vertx.core.cli.converters.Person3;
import java.io.File;
import java.net.URL;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ConvertersTest {
    @Test
    public void testCreatingSingleValueUsingValueOfOnEnumeration() {
        Assertions.assertThat((Comparable)((Comparable)Converters.create(HttpMethod.class, (String)"GET"))).isEqualTo((Object)HttpMethod.GET);
        try {
            Assertions.assertThat((Comparable)((Comparable)Converters.create(HttpMethod.class, null))).isNull();
            Assertions.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Assertions.assertThat((Comparable)((Comparable)Converters.create(HttpMethod.class, (String)"FOO_IS_NOT_A_METHOD"))).isNull();
            Assertions.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWithString() throws NoSuchMethodException {
        Assertions.assertThat((String)((String)Converters.create(String.class, (String)"Hello"))).isEqualTo((Object)"Hello");
        Assertions.assertThat((String)((String)Converters.create(String.class, (String)""))).isEqualTo((Object)"");
    }

    @Test
    public void testWithPrimitives() throws NoSuchMethodException {
        Assertions.assertThat((Integer)((Integer)Converters.create(Integer.class, (String)"1"))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)Converters.create(Integer.TYPE, (String)"1"))).isEqualTo(1);
        Assertions.assertThat((Long)((Long)Converters.create(Long.class, (String)"2"))).isEqualTo(2L);
        Assertions.assertThat((Long)((Long)Converters.create(Long.TYPE, (String)"2"))).isEqualTo(2L);
        Assertions.assertThat((Short)((Short)Converters.create(Short.class, (String)"3"))).isEqualTo((short)3);
        Assertions.assertThat((Short)((Short)Converters.create(Short.TYPE, (String)"3"))).isEqualTo((short)3);
        Assertions.assertThat((Byte)((Byte)Converters.create(Byte.class, (String)"4"))).isEqualTo((byte)4);
        Assertions.assertThat((Byte)((Byte)Converters.create(Byte.TYPE, (String)"4"))).isEqualTo((byte)4);
        Assertions.assertThat((Float)((Float)Converters.create(Float.class, (String)"5.5"))).isEqualTo(5.5f);
        Assertions.assertThat((Float)((Float)Converters.create(Float.TYPE, (String)"5.5"))).isEqualTo(5.5f);
        Assertions.assertThat((Double)((Double)Converters.create(Double.class, (String)"5.5"))).isEqualTo(5.5);
        Assertions.assertThat((Double)((Double)Converters.create(Double.TYPE, (String)"5.5"))).isEqualTo(5.5);
        Assertions.assertThat((Character)((Character)Converters.create(Character.class, (String)"a"))).isEqualTo('a');
        Assertions.assertThat((Character)((Character)Converters.create(Character.TYPE, (String)"a"))).isEqualTo('a');
        Assertions.assertThat((Boolean)((Boolean)Converters.create(Boolean.class, (String)"true"))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)Converters.create(Boolean.TYPE, (String)"on"))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)Converters.create(Boolean.class, (String)""))).isFalse();
    }

    @Test
    public void testUsingFrom() throws NoSuchMethodException {
        Assertions.assertThat((String)((Person2)Converters.create(Person2.class, (String)"vertx")).name).isEqualTo((Object)"vertx");
    }

    @Test
    public void testUsingFromString() throws NoSuchMethodException {
        Assertions.assertThat((String)((Person3)Converters.create(Person3.class, (String)"vertx")).name).isEqualTo((Object)"vertx");
    }

    @Test(expected=NoSuchElementException.class)
    public void testMissingConvertion() throws NoSuchMethodException {
        Converters.create(Object.class, (String)"hello");
    }

    @Test
    public void testWithURL() {
        URL url = (URL)Converters.create(URL.class, (String)"http://vertx.io");
        Assertions.assertThat((String)url.toExternalForm()).isEqualToIgnoringCase((CharSequence)"http://vertx.io");
    }

    @Test
    public void testWithFile() {
        File file = (File)Converters.create(File.class, (String)"foo/hello.txt");
        Assertions.assertThat((File)file).hasName("hello.txt").doesNotExist();
    }

    private static enum HttpMethod {
        GET;

    }
}

