/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.Launcher;
import io.vertx.core.Vertx;
import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.core.impl.launcher.commands.HttpTestVerticle;
import io.vertx.core.impl.launcher.commands.RunCommand;
import io.vertx.core.json.JsonObject;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RunCommandTest
extends CommandTestBase {
    private File manifest = new File("target/test-classes/META-INF/MANIFEST.MF");

    @Override
    @Before
    public void setUp() throws IOException {
        super.setUp();
        if (this.manifest.isFile()) {
            this.manifest.delete();
        }
    }

    @Override
    @After
    public void tearDown() throws InterruptedException {
        super.tearDown();
        RunCommand run = (RunCommand)this.cli.getExistingCommandInstance("run");
        if (run != null) {
            Vertx vertx = run.vertx;
            this.close(vertx);
        }
        FakeClusterManager.reset();
    }

    private void setManifest(String name) throws IOException {
        File source = new File("target/test-classes/META-INF/" + name);
        Files.copy(source.toPath(), this.manifest.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    @Test
    public void testDeploymentOfJavaVerticle() {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName()});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    @Test
    public void testDeploymentOfJavaVerticleWithCluster() throws IOException {
        this.cli.dispatch((Object)new Launcher(), new String[]{"run", HttpTestVerticle.class.getName(), "-cluster"});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isTrue();
    }

    @Test
    public void testFatJarWithoutMainVerticle() throws IOException {
        this.setManifest("MANIFEST-Launcher-No-Main-Verticle.MF");
        this.record();
        this.cli.dispatch((Object)new Launcher(), new String[0]);
        this.stop();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"Usage:"});
    }

    @Test
    public void testFatJarWithMissingMainVerticle() throws IOException, InterruptedException {
        this.setManifest("MANIFEST-Launcher-Missing-Main-Verticle.MF");
        this.record();
        this.cli.dispatch((Object)new Launcher(), new String[0]);
        this.waitUntil(() -> this.error.toString().contains("ClassNotFoundException"));
        this.stop();
    }

    @Test
    public void testFatJarWithHTTPVerticle() throws IOException, InterruptedException {
        this.setManifest("MANIFEST-Launcher-Http-Verticle.MF");
        this.cli.dispatch((Object)new Launcher(), new String[0]);
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isFalse();
    }

    @Test
    public void testFatJarWithHTTPVerticleWithCluster() throws IOException, InterruptedException {
        this.setManifest("MANIFEST-Launcher-Http-Verticle.MF");
        this.cli.dispatch((Object)new Launcher(), new String[]{"-cluster"});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isTrue();
    }

    @Test
    public void testThatHADeploysVerticleWhenCombinedWithCluster() throws IOException {
        this.setManifest("MANIFEST-Launcher-Http-Verticle.MF");
        this.cli.dispatch((Object)new Launcher(), new String[]{"-ha", "-cluster"});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isTrue();
    }

    @Test
    public void testThatHADeploysVerticle() throws IOException {
        this.setManifest("MANIFEST-Launcher-Http-Verticle.MF");
        this.cli.dispatch((Object)new Launcher(), new String[]{"-ha", "-cluster"});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isTrue();
    }

    @Test
    public void testWithConfProvidedInline() throws IOException {
        this.setManifest("MANIFEST-Launcher-Http-Verticle.MF");
        this.cli.dispatch((Object)new Launcher(), new String[]{"--conf={\"name\":\"vertx\"}"});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((String)RunCommandTest.getContent().getJsonObject("conf").getString("name")).isEqualToIgnoringCase((CharSequence)"vertx");
    }

    @Test
    public void testWithConfProvidedAsFile() throws IOException {
        this.setManifest("MANIFEST-Launcher-Http-Verticle.MF");
        this.cli.dispatch((Object)new Launcher(), new String[]{"--conf", "target/test-classes/conf.json"});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((String)RunCommandTest.getContent().getJsonObject("conf").getString("name")).isEqualToIgnoringCase((CharSequence)"vertx");
    }

    @Test
    public void testMetricsEnabledFromCommandLine() throws IOException {
        this.setManifest("MANIFEST-Launcher-Http-Verticle.MF");
        this.cli.dispatch((Object)new Launcher(), new String[]{"-Dvertx.metrics.options.enabled=true"});
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((boolean)((RunCommand)this.cli.getExistingCommandInstance((String)"run")).options.getMetricsOptions().isEnabled()).isTrue();
    }

    public static int getHttpCode() throws IOException {
        return ((HttpURLConnection)new URL("http://localhost:8080").openConnection()).getResponseCode();
    }

    public static JsonObject getContent() throws IOException {
        String line;
        URL url = new URL("http://localhost:8080");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        InputStreamReader in = new InputStreamReader((InputStream)conn.getContent());
        BufferedReader buff = new BufferedReader(in);
        StringBuilder builder = new StringBuilder();
        do {
            line = buff.readLine();
            builder.append(line).append("\n");
        } while (line != null);
        buff.close();
        return new JsonObject(builder.toString());
    }
}

