/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Lock;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class AsynchronousLockTest
extends VertxTestBase {
    protected Vertx getVertx() {
        return this.vertx;
    }

    @Test
    public void testIllegalArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLock(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLock("foo", null));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLockWithTimeout(null, 1L, ar -> {}));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLockWithTimeout("foo", 1L, null));
        TestUtils.assertIllegalArgumentException(() -> this.getVertx().sharedData().getLockWithTimeout("foo", -1L, ar -> {}));
    }

    @Test
    public void testAcquire() {
        this.getVertx().sharedData().getLock("foo", ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            Lock lock = (Lock)ar.result();
            this.vertx.setTimer(1000L, tid -> lock.release());
            this.getVertx().sharedData().getLock("foo", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAcquireDifferentLocks() {
        this.getVertx().sharedData().getLock("foo", ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            Lock lock = (Lock)ar.result();
            this.getVertx().sharedData().getLock("bar", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertTrue(System.currentTimeMillis() - start < 2000L);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAcquireTimeout() {
        this.getVertx().sharedData().getLock("foo", ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            this.getVertx().sharedData().getLockWithTimeout("foo", 1000L, ar2 -> {
                this.assertFalse(ar2.succeeded());
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.testComplete();
            });
        });
        this.await();
    }
}

