/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class ContextTest
extends VertxTestBase {
    @Test
    public void testRunOnContext() throws Exception {
        this.vertx.runOnContext(v -> {
            final Thread th = Thread.currentThread();
            final Context ctx = Vertx.currentContext();
            ctx.runOnContext(v2 -> {
                this.assertEquals(th, Thread.currentThread());
                for (int i = 0; i < 10; ++i) {
                    Context c = Vertx.currentContext();
                    this.assertEquals(ctx, c);
                }
                new Thread(){

                    @Override
                    public void run() {
                        ctx.runOnContext(v3 -> {
                            ContextTest.this.assertEquals(th, Thread.currentThread());
                            ContextTest.this.assertEquals(ctx, Vertx.currentContext());
                            ContextTest.this.testComplete();
                        });
                    }
                }.start();
            });
        });
        this.await();
    }

    @Test
    public void testNoContext() throws Exception {
        this.assertNull(Vertx.currentContext());
    }

    @Test
    public void testPutGetRemoveData() throws Exception {
        SomeObject obj = new SomeObject();
        this.vertx.runOnContext(v -> {
            Context ctx = Vertx.currentContext();
            ctx.put("foo", (Object)obj);
            ctx.runOnContext(v2 -> {
                this.assertEquals(obj, ctx.get("foo"));
                this.assertTrue(ctx.remove("foo"));
                ctx.runOnContext(v3 -> {
                    this.assertNull(ctx.get("foo"));
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testGettingContextContextUnderContextAnotherInstanceShouldReturnDifferentContext() throws Exception {
        Vertx other = Vertx.vertx();
        Context context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> {
            Context otherContext = other.getOrCreateContext();
            this.assertNotSame(otherContext, context);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testExecuteOrderedBlocking() throws Exception {
        Context context = this.vertx.getOrCreateContext();
        context.executeBlocking(f -> {
            this.assertTrue(Context.isOnWorkerThread());
            f.complete((Object)3);
        }, r -> {
            this.assertTrue(Context.isOnEventLoopThread());
            this.assertEquals(r.result(), (Object)3);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testExecuteUnorderedBlocking() throws Exception {
        Context context = this.vertx.getOrCreateContext();
        context.executeBlocking(f -> {
            this.assertTrue(Context.isOnWorkerThread());
            f.complete((Object)3);
        }, false, r -> {
            this.assertTrue(Context.isOnEventLoopThread());
            this.assertEquals(r.result(), (Object)3);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEventLoopExecuteFromIo() throws Exception {
        ContextInternal eventLoopContext = (ContextInternal)this.vertx.getOrCreateContext();
        try {
            eventLoopContext.executeFromIO(this::fail);
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        eventLoopContext.nettyEventLoop().execute(() -> {
            this.assertNull(Vertx.currentContext());
            Thread vertxThread = Thread.currentThread();
            AtomicBoolean nested = new AtomicBoolean(true);
            eventLoopContext.executeFromIO(() -> {
                this.assertTrue(nested.get());
                this.assertSame(eventLoopContext, Vertx.currentContext());
                this.assertSame(vertxThread, Thread.currentThread());
            });
            nested.set(false);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testWorkerExecuteFromIo() throws Exception {
        final AtomicReference workerContext = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                workerContext.set((ContextInternal)this.context);
                latch.countDown();
            }
        }, new DeploymentOptions().setWorker(true));
        this.awaitLatch(latch);
        ((ContextInternal)workerContext.get()).nettyEventLoop().execute(() -> {
            this.assertNull(Vertx.currentContext());
            ((ContextInternal)workerContext.get()).executeFromIO(() -> {
                this.assertSame(workerContext.get(), Vertx.currentContext());
                this.assertTrue(Context.isOnWorkerThread());
                this.testComplete();
            });
        });
        this.await();
    }

    class SomeObject {
        SomeObject() {
        }
    }
}

