/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.test.core.AsyncTestBase;
import org.junit.Test;

public class CreateVertxTest
extends AsyncTestBase {
    @Test
    public void testCreateSimpleVertx() {
        Vertx vertx = Vertx.vertx();
        this.assertNotNull(vertx);
    }

    @Test
    public void testCreateVertxWithOptions() {
        VertxOptions options = new VertxOptions();
        Vertx vertx = Vertx.vertx((VertxOptions)options);
        this.assertNotNull(vertx);
        this.assertFalse(vertx.isClustered());
    }

    @Test
    public void testFailCreateClusteredVertxSynchronously() {
        VertxOptions options = new VertxOptions();
        options.setClustered(true);
        try {
            Vertx.vertx((VertxOptions)options);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateClusteredVertxAsync() {
        VertxOptions options = new VertxOptions();
        options.setClustered(true);
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertNotNull(ar.result());
            this.assertTrue(((Vertx)ar.result()).isClustered());
            Vertx v = (Vertx)ar.result();
            v.close(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testCreateClusteredVertxAsyncDontSetClustered() {
        VertxOptions options = new VertxOptions();
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertNotNull(ar.result());
            this.assertTrue(options.isClustered());
            this.assertTrue(((Vertx)ar.result()).isClustered());
            Vertx v = (Vertx)ar.result();
            v.close(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }
}

