/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.FileResolver;
import io.vertx.core.impl.VertxInternal;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public abstract class FileResolverTestBase
extends VertxTestBase {
    protected FileResolver resolver;
    protected String webRoot;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.resolver = new FileResolver(this.vertx);
    }

    @Override
    protected void tearDown() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.resolver.close(this.onSuccess(res -> latch.countDown()));
        this.awaitLatch(latch);
        super.tearDown();
    }

    @Test
    public void testResolveNotExistFile() {
        File file = this.resolver.resolveFile("doesnotexist.txt");
        this.assertFalse(file.exists());
        this.assertEquals("doesnotexist.txt", file.getPath());
    }

    @Test
    public void testResolveNotExistDirectory() {
        File file = this.resolver.resolveFile("somedir");
        this.assertFalse(file.exists());
        this.assertEquals("somedir", file.getPath());
    }

    @Test
    public void testResolveNotExistFileInDirectory() {
        File file = this.resolver.resolveFile("somedir/doesnotexist.txt");
        this.assertFalse(file.exists());
        this.assertEquals("somedir" + File.separator + "doesnotexist.txt", file.getPath());
    }

    @Test
    public void testResolveFileFromClasspath() throws Exception {
        for (int i = 0; i < 2; ++i) {
            File file = this.resolver.resolveFile("afile.html");
            this.assertTrue(file.exists());
            this.assertTrue(file.getPath().startsWith(".vertx" + File.separator + "file-cache-"));
            this.assertFalse(file.isDirectory());
            this.assertEquals("<html><body>afile</body></html>", this.readFile(file));
        }
    }

    @Test
    public void testResolveFileFromClasspathDisableCaching() throws Exception {
        System.setProperty("vertx.disableFileCaching", "true");
        this.resolver = new FileResolver(this.vertx);
        for (int i = 0; i < 2; ++i) {
            File file = this.resolver.resolveFile("afile.html");
            this.assertTrue(file.exists());
            this.assertTrue(file.getPath().startsWith(".vertx" + File.separator + "file-cache-"));
            this.assertFalse(file.isDirectory());
            this.assertEquals("<html><body>afile</body></html>", this.readFile(file));
        }
    }

    @Test
    public void testResolveFileWithSpacesFromClasspath() throws Exception {
        for (int i = 0; i < 2; ++i) {
            File file = this.resolver.resolveFile("afile with spaces.html");
            this.assertTrue(file.exists());
            this.assertTrue(file.getPath().startsWith(".vertx" + File.separator + "file-cache-"));
            this.assertFalse(file.isDirectory());
            this.assertEquals("<html><body>afile with spaces</body></html>", this.readFile(file));
        }
    }

    @Test
    public void testResolveDirectoryFromClasspath() throws Exception {
        for (int i = 0; i < 2; ++i) {
            File file = this.resolver.resolveFile(this.webRoot);
            this.assertTrue(file.exists());
            this.assertTrue(file.getPath().startsWith(".vertx" + File.separator + "file-cache-"));
            this.assertTrue(file.isDirectory());
        }
    }

    @Test
    public void testResolveFileInDirectoryFromClasspath() throws Exception {
        for (int i = 0; i < 2; ++i) {
            File file = this.resolver.resolveFile(this.webRoot + "/somefile.html");
            this.assertTrue(file.exists());
            this.assertTrue(file.getPath().startsWith(".vertx" + File.separator + "file-cache-"));
            this.assertFalse(file.isDirectory());
            this.assertEquals("<html><body>blah</body></html>", this.readFile(file));
        }
    }

    @Test
    public void testResolveSubDirectoryFromClasspath() throws Exception {
        for (int i = 0; i < 2; ++i) {
            File file = this.resolver.resolveFile(this.webRoot + "/subdir");
            this.assertTrue(file.exists());
            this.assertTrue(file.getPath().startsWith(".vertx" + File.separator + "file-cache-"));
            this.assertTrue(file.isDirectory());
        }
    }

    @Test
    public void testResolveFileInSubDirectoryFromClasspath() throws Exception {
        for (int i = 0; i < 2; ++i) {
            File file = this.resolver.resolveFile(this.webRoot + "/subdir/subfile.html");
            this.assertTrue(file.exists());
            this.assertTrue(file.getPath().startsWith(".vertx" + File.separator + "file-cache-"));
            this.assertFalse(file.isDirectory());
            this.assertEquals("<html><body>subfile</body></html>", this.readFile(file));
        }
    }

    @Test
    public void testRecursivelyUnpack() throws Exception {
        File file = this.resolver.resolveFile(this.webRoot + "/subdir");
        this.assertTrue(file.exists());
        File sub = new File(file, "subfile.html");
        this.assertTrue(sub.exists());
        this.assertEquals("<html><body>subfile</body></html>", this.readFile(sub));
    }

    @Test
    public void testRecursivelyUnpack2() throws Exception {
        File file = this.resolver.resolveFile(this.webRoot + "/subdir");
        this.assertTrue(file.exists());
        File sub = new File(new File(file, "subdir2"), "subfile2.html");
        this.assertTrue(sub.exists());
        this.assertEquals("<html><body>subfile2</body></html>", this.readFile(sub));
    }

    @Test
    public void testDeleteCacheDir() throws Exception {
        Vertx vertx2 = Vertx.vertx();
        FileResolver resolver2 = new FileResolver(vertx2);
        File file = resolver2.resolveFile(this.webRoot + "/somefile.html");
        this.assertTrue(file.exists());
        File cacheDir = file.getParentFile().getParentFile();
        this.assertTrue(cacheDir.exists());
        resolver2.close(this.onSuccess(res -> {
            this.assertFalse(cacheDir.exists());
            vertx2.close(res2 -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testCacheDirDeletedOnVertxClose() {
        VertxInternal vertx2 = (VertxInternal)Vertx.vertx();
        File file = vertx2.resolveFile(this.webRoot + "/somefile.html");
        this.assertTrue(file.exists());
        File cacheDir = file.getParentFile().getParentFile();
        this.assertTrue(cacheDir.exists());
        vertx2.close(this.onSuccess(v -> {
            this.assertFalse(cacheDir.exists());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testFileSystemReadFile() {
        this.assertTrue(this.vertx.fileSystem().existsBlocking("afile.html"));
        this.assertFalse(this.vertx.fileSystem().propsBlocking("afile.html").isDirectory());
        Buffer buffer = this.vertx.fileSystem().readFileBlocking("afile.html");
        this.assertNotNull(buffer);
        this.assertTrue(buffer.toString().startsWith("<html><body>afile</body></html>"));
    }

    @Test
    public void testFileSystemReadDirectory() {
        this.assertTrue(this.vertx.fileSystem().existsBlocking("webroot"));
        this.assertTrue(this.vertx.fileSystem().propsBlocking("webroot").isDirectory());
    }

    @Test
    public void testSendFileFromClasspath() {
        this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(res -> res.response().sendFile(this.webRoot + "/somefile.html")).listen(this.onSuccess(res -> this.vertx.createHttpClient(new HttpClientOptions()).request(HttpMethod.GET, 8080, "localhost", "/", resp -> resp.bodyHandler(buff -> {
            this.assertTrue(buff.toString().startsWith("<html><body>blah</body></html>"));
            this.testComplete();
        })).end()));
        this.await();
    }

    private String readFile(File file) {
        return this.vertx.fileSystem().readFileBlocking(file.getAbsolutePath()).toString();
    }
}

