/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.test.core.HttpTestBase;
import org.junit.Test;

public class HttpCompressionTest
extends HttpTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setTryUseCompression(true));
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setCompressionSupported(true));
    }

    @Test
    public void testDefaultRequestHeaders() {
        this.server.requestHandler(req -> {
            this.assertEquals(2L, req.headers().size());
            this.assertEquals("localhost:8080", req.headers().get("host"));
            this.assertNotNull(req.headers().get("Accept-Encoding"));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete()).end()));
        this.await();
    }
}

