/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.Random;
import org.junit.Test;

public class MetricsOptionsTest
extends VertxTestBase {
    @Test
    public void testOptions() {
        MetricsOptions options = new MetricsOptions();
        this.assertFalse(options.isEnabled());
        this.assertEquals(options, options.setEnabled(true));
        this.assertTrue(options.isEnabled());
    }

    @Test
    public void testCopyOptions() {
        MetricsOptions options = new MetricsOptions();
        Random rand = new Random();
        boolean metricsEnabled = rand.nextBoolean();
        options.setEnabled(metricsEnabled);
        options = new MetricsOptions(options);
        this.assertEquals(metricsEnabled, options.isEnabled());
    }

    @Test
    public void testJsonOptions() {
        MetricsOptions options = new MetricsOptions(new JsonObject());
        this.assertFalse(options.isEnabled());
        Random rand = new Random();
        boolean metricsEnabled = rand.nextBoolean();
        String customValue = TestUtils.randomAlphaString(10);
        options = new MetricsOptions(new JsonObject().put("enabled", Boolean.valueOf(metricsEnabled)).put("custom", customValue));
        this.assertEquals(metricsEnabled, options.isEnabled());
        this.assertEquals(metricsEnabled, options.toJson().getBoolean("enabled"));
        this.assertEquals(customValue, options.toJson().getString("custom"));
    }
}

