/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.PacketMetric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FakeDatagramSocketMetrics
extends FakeMetricsBase
implements DatagramSocketMetrics {
    private volatile SocketAddress localAddress;
    private final List<PacketMetric> reads = Collections.synchronizedList(new ArrayList());
    private final List<PacketMetric> writes = Collections.synchronizedList(new ArrayList());

    public FakeDatagramSocketMetrics(Measured measured) {
        super(measured);
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public List<PacketMetric> getReads() {
        return this.reads;
    }

    public List<PacketMetric> getWrites() {
        return this.writes;
    }

    public void listening(SocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.reads.add(new PacketMetric(remoteAddress, numberOfBytes));
    }

    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.writes.add(new PacketMetric(remoteAddress, numberOfBytes));
    }

    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
    }
}

