/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptionsConverter;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true)
public class AddressResolverOptions {
    public static final List<String> DEFAULT_SERVERS = null;
    public static final boolean DEFAULT_OPT_RESOURCE_ENABLED = true;
    public static final int DEFAULT_CACHE_MIN_TIME_TO_LIVE = 0;
    public static final int DEFAULT_CACHE_MAX_TIME_TO_LIVE = Integer.MAX_VALUE;
    public static final int DEFAULT_CACHE_NEGATIVE_TIME_TO_LIVE = 0;
    public static final int DEFAULT_QUERY_TIMEOUT = 5000;
    public static final int DEFAULT_MAX_QUERIES = 3;
    public static final boolean DEFAULT_RD_FLAG = true;
    private String hostsPath;
    private Buffer hostsValue;
    private List<String> servers;
    private boolean optResourceEnabled;
    private int cacheMinTimeToLive;
    private int cacheMaxTimeToLive;
    private int cacheNegativeTimeToLive;
    private long queryTimeout;
    private int maxQueries;
    private boolean rdFlag;

    public AddressResolverOptions() {
        this.servers = DEFAULT_SERVERS;
        this.optResourceEnabled = true;
        this.cacheMinTimeToLive = 0;
        this.cacheMaxTimeToLive = Integer.MAX_VALUE;
        this.cacheNegativeTimeToLive = 0;
        this.queryTimeout = 5000L;
        this.maxQueries = 3;
        this.rdFlag = true;
    }

    public AddressResolverOptions(AddressResolverOptions other) {
        this.hostsPath = other.hostsPath;
        this.hostsValue = other.hostsValue != null ? other.hostsValue.copy() : null;
        this.servers = other.servers != null ? new ArrayList<String>(other.servers) : null;
        this.optResourceEnabled = other.optResourceEnabled;
        this.cacheMinTimeToLive = other.cacheMinTimeToLive;
        this.cacheMaxTimeToLive = other.cacheMaxTimeToLive;
        this.cacheNegativeTimeToLive = other.cacheNegativeTimeToLive;
        this.queryTimeout = other.queryTimeout;
        this.maxQueries = other.maxQueries;
        this.rdFlag = other.rdFlag;
    }

    public AddressResolverOptions(JsonObject json) {
        this();
        AddressResolverOptionsConverter.fromJson(json, this);
    }

    public String getHostsPath() {
        return this.hostsPath;
    }

    public AddressResolverOptions setHostsPath(String hostsPath) {
        this.hostsPath = hostsPath;
        return this;
    }

    public Buffer getHostsValue() {
        return this.hostsValue;
    }

    public AddressResolverOptions setHostsValue(Buffer hostsValue) {
        this.hostsValue = hostsValue;
        return this;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public AddressResolverOptions setServers(List<String> servers) {
        this.servers = servers;
        return this;
    }

    public AddressResolverOptions addServer(String server) {
        if (this.servers == null) {
            this.servers = new ArrayList<String>();
        }
        this.servers.add(server);
        return this;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public AddressResolverOptions setOptResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    public int getCacheMinTimeToLive() {
        return this.cacheMinTimeToLive;
    }

    public AddressResolverOptions setCacheMinTimeToLive(int cacheMinTimeToLive) {
        this.cacheMinTimeToLive = cacheMinTimeToLive;
        return this;
    }

    public int getCacheMaxTimeToLive() {
        return this.cacheMaxTimeToLive;
    }

    public AddressResolverOptions setCacheMaxTimeToLive(int cacheMaxTimeToLive) {
        this.cacheMaxTimeToLive = cacheMaxTimeToLive;
        return this;
    }

    public int getCacheNegativeTimeToLive() {
        return this.cacheNegativeTimeToLive;
    }

    public AddressResolverOptions setCacheNegativeTimeToLive(int cacheNegativeTimeToLive) {
        this.cacheNegativeTimeToLive = cacheNegativeTimeToLive;
        return this;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public AddressResolverOptions setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public int getMaxQueries() {
        return this.maxQueries;
    }

    public AddressResolverOptions setMaxQueries(int maxQueries) {
        this.maxQueries = maxQueries;
        return this;
    }

    public boolean getRdFlag() {
        return this.rdFlag;
    }

    public AddressResolverOptions setRdFlag(boolean rdFlag) {
        this.rdFlag = rdFlag;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressResolverOptions that = (AddressResolverOptions)o;
        if (this.optResourceEnabled != that.optResourceEnabled) {
            return false;
        }
        if (this.cacheMinTimeToLive != that.cacheMinTimeToLive) {
            return false;
        }
        if (this.cacheMaxTimeToLive != that.cacheMaxTimeToLive) {
            return false;
        }
        if (this.cacheNegativeTimeToLive != that.cacheNegativeTimeToLive) {
            return false;
        }
        if (this.queryTimeout != that.queryTimeout) {
            return false;
        }
        if (this.maxQueries != that.maxQueries) {
            return false;
        }
        if (this.rdFlag != that.rdFlag) {
            return false;
        }
        return this.servers != null ? this.servers.equals(that.servers) : that.servers == null;
    }

    public int hashCode() {
        int result = this.optResourceEnabled ? 1 : 0;
        result = 31 * result + (this.servers != null ? this.servers.hashCode() : 0);
        result = 31 * result + this.cacheMinTimeToLive;
        result = 31 * result + this.cacheMaxTimeToLive;
        result = 31 * result + this.cacheNegativeTimeToLive;
        result = 31 * result + Long.hashCode(this.queryTimeout);
        result = 31 * result + this.maxQueries;
        result = 31 * result + Boolean.hashCode(this.rdFlag);
        return result;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AddressResolverOptionsConverter.toJson(this, json);
        return json;
    }
}

