/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.logging.Recording;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JULLogDelegateTest {
    private static Recording recording;

    @BeforeClass
    public static void initialize() throws IOException {
        System.clearProperty("vertx.logger-delegate-factory-class-name");
        recording = new Recording();
    }

    @Test
    @Ignore
    public void testInfo() {
        String result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello");
        });
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"exception", (Throwable)new NullPointerException());
        });
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0} and {1}", new Object[]{"Paulo", "Julien"});
        });
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0} - {1}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x - {1}"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0}", new Object[]{"vert.x", "foo"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"{0}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"{0}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    @Ignore
    public void testError() {
        String result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello");
        });
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"exception", (Throwable)new NullPointerException());
        });
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0} and {1}", new Object[]{"Paulo", "Julien"});
        });
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0} - {1}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x - {1}"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0}", new Object[]{"vert.x", "foo"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"{0}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"{0}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    @Ignore
    public void testWarning() {
        String result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello");
        });
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"exception", (Throwable)new NullPointerException());
        });
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0} and {1}", new Object[]{"Paulo", "Julien"});
        });
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0} - {1}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x - {1}"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0}", new Object[]{"vert.x", "foo"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"{0}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> {
            Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"{0}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }
}

