/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class Recording {
    private ByteArrayOutputStream error = new ByteArrayOutputStream();
    private Handler handler = new StreamHandler(this.error, new SimpleFormatter());
    private Logger logger = LogManager.getLogManager().getLogger("");

    private void start() {
        this.error.reset();
        this.logger.addHandler(this.handler);
    }

    public void stop() {
        this.logger.removeHandler(this.handler);
    }

    public String get() {
        this.handler.flush();
        return this.error.toString();
    }

    public String execute(Runnable runnable) {
        String result;
        this.start();
        try {
            runnable.run();
            result = this.get();
        }
        finally {
            this.stop();
        }
        return result;
    }
}

