/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.test.core.AsyncTestBase;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.ComparisonFailure;
import org.junit.Test;

public class AsyncTestBaseTest
extends AsyncTestBase {
    private ExecutorService executor;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.disableThreadChecks();
        this.executor = Executors.newFixedThreadPool(10);
    }

    @Override
    protected void tearDown() throws Exception {
        this.executor.shutdownNow();
        super.tearDown();
    }

    @Test
    public void testAssertionFailedFromOtherThread() {
        this.executor.execute(() -> {
            this.assertEquals("foo", "bar");
            this.testComplete();
        });
        try {
            this.await();
        }
        catch (ComparisonFailure error) {
            this.assertTrue(error.getMessage().startsWith("expected:"));
        }
    }

    @Test
    public void testAssertionFailedFromOtherThreadAwaitBeforeAssertAndTestComplete() {
        this.executor.execute(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.fail(e.getMessage());
            }
            this.assertEquals("foo", "bar");
            this.testComplete();
        });
        try {
            this.await();
        }
        catch (ComparisonFailure error) {
            this.assertTrue(error.getMessage().startsWith("expected:"));
        }
    }

    @Test
    public void testAssertionFailedFromOtherThreadForgotToCallAwait() throws Exception {
        this.executor.execute(() -> {
            this.assertEquals("foo", "bar");
            this.testComplete();
        });
        Thread.sleep(500L);
        try {
            super.afterAsyncTestBase();
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            this.clearThrown();
        }
    }

    @Test
    public void testAssertionFailedFromMainThread() {
        try {
            this.assertEquals("foo", "bar");
        }
        catch (ComparisonFailure error) {
            this.assertTrue(error.getMessage().startsWith("expected:"));
        }
        this.testComplete();
    }

    @Test
    public void testAssertionPassedFromOtherThread() {
        this.executor.execute(() -> {
            this.assertEquals("foo", "foo");
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAssertionPassedFromMainThread() {
        this.assertEquals("foo", "foo");
        this.testComplete();
        this.await();
    }

    @Test
    public void testTimeout() {
        long timeout = 5000L;
        long start = System.currentTimeMillis();
        try {
            this.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException error) {
            long now = System.currentTimeMillis();
            this.assertTrue(error.getMessage().startsWith("Timed out in waiting for test complete"));
            long delay = now - start;
            this.assertTrue(delay >= timeout);
            this.assertTrue((double)delay < (double)timeout * 1.5);
        }
    }

    @Test
    public void testFailFromOtherThread() {
        String msg = "too many aardvarks!";
        this.executor.execute(() -> {
            this.fail(msg);
            this.testComplete();
        });
        try {
            this.await();
        }
        catch (AssertionError error) {
            this.assertTrue(((Throwable)((Object)error)).getMessage().equals(msg));
        }
    }

    @Test
    public void testSuccessfulCompletion() {
        this.executor.execute(() -> {
            this.assertEquals("foo", "foo");
            this.assertFalse(false);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testTestCompleteCalledMultipleTimes() {
        this.executor.execute(() -> {
            this.assertEquals("foo", "foo");
            this.testComplete();
            try {
                this.testComplete();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.await();
    }

    @Test
    public void testAwaitCalledMultipleTimes() {
        this.executor.execute(() -> {
            this.assertEquals("foo", "foo");
            this.testComplete();
        });
        this.await();
        try {
            this.await();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNoAssertionsNoTestComplete() {
    }

    @Test
    public void testNoAssertionsTestComplete() {
        this.testComplete();
    }

    @Test
    public void testAssertionOKTestComplete() {
        this.assertEquals("foo", "foo");
        this.testComplete();
    }

    @Test
    public void testAssertionFailedFromMainThreadWithNoTestComplete() {
        try {
            this.assertEquals("foo", "bar");
        }
        catch (AssertionError e) {
            this.testComplete();
            try {
                super.afterAsyncTestBase();
            }
            catch (IllegalStateException e2) {
                this.fail("Should not throw exception");
            }
            finally {
                this.clearThrown();
            }
        }
    }

    @Test
    public void waitForMultiple() {
        int toWaitFor = 10;
        this.waitFor(10);
        AtomicInteger cnt = new AtomicInteger();
        for (int i = 0; i < toWaitFor; ++i) {
            this.executor.execute(() -> {
                cnt.incrementAndGet();
                this.complete();
            });
        }
        this.await();
        this.assertEquals(toWaitFor, cnt.get());
    }

    @Test
    public void increaseToWait() {
        int toWaitFor = 10;
        this.waitFor(3);
        this.complete();
        this.complete();
        this.waitForMore(9);
        AtomicInteger cnt = new AtomicInteger();
        for (int i = 0; i < toWaitFor; ++i) {
            this.executor.execute(() -> {
                cnt.incrementAndGet();
                this.complete();
            });
        }
        this.await();
        this.assertEquals(toWaitFor, cnt.get());
    }
}

